/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2s09
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.BlurFilter;
	import flash.geom.*;
	
	[SWF(width=465,height=465,backgroundColor=0x0)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const NUM:int = 70;		
		private const CENTER_X:int = 232 ;
		private const CENTER_Y:int = 232 ;
		
		private var circles:Vector.<Circle> = new Vector.<Circle>();
		private var angle:Number = 0;
		private var cAngle:Number = 0;
		private var container:Sprite;
		private var canvas:BitmapData;
		private var ct:ColorTransform = new ColorTransform(1, 1, 1, 0.98);
		private var blur:BlurFilter = new BlurFilter(15,15,1);
		
		public function Main():void 
		{
			container = new Sprite();
			
			for (var i:int = 0; i < NUM; i++) 
			{
				var circle:Circle = new Circle(((i + 1)*5) * Math.random());
				circle.x = CENTER_X + (Math.random() * circle.radius - circle.radius / 2);
				circle.y = CENTER_Y + (Math.random() * circle.radius - circle.radius / 2);
				container.addChild(circle);
				circles[i] = circle;
			}
			
			canvas = new BitmapData(465, 465, false, 0x0);
			var bmp:Bitmap = addChild(new Bitmap(canvas)) as Bitmap;
			bmp.blendMode = BlendMode.DIFFERENCE;
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			angle += .065;
			cAngle += 0.01;
			for (var i:int = 0; i < NUM; i++) 
			{
				var color:uint = (
					100 * (Math.sin(cAngle)) + 100) << 16 | 
					((128 / NUM) * (i + 1)) << 8 | 
					100 * (Math.cos(cAngle)) + 100;
					
				var c:Circle = circles[i];
				c.color = color;
				var rotate:Number = c.radius / i * (i*0.1);
				if (i % 4 == 0)
				{
					c.x = Math.cos(angle/i*(Math.sin(cAngle*i/5))) * rotate; 
					c.y = Math.sin(angle/i*(Math.cos(cAngle*i/5))) * rotate; 
				}
				else
				{
					c.x = Math.cos(cAngle*(Math.sin(cAngle*i/5))) * rotate; 
					c.y = Math.sin(cAngle*(Math.cos(cAngle*i/5))) * rotate; 
				}
			}
			canvas.applyFilter(canvas, canvas.rect, new Point(), blur);
			canvas.colorTransform(canvas.rect, ct);
			canvas.draw(container,new Matrix(1,0,0,1,CENTER_X,CENTER_Y));
		}
	}
}

import flash.display.Sprite;

class Circle extends Sprite
{
	public var radius:Number;
	private var _color:uint = 0xffffff;
	public function Circle(radius:Number)
	{
		this.radius = radius;
		draw();
	}
	
	public function get color():uint { return _color; }
	public function set color(value:uint):void 
	{
		_color = value;
		draw();
	}
	private function draw():void
	{
		graphics.clear();
		graphics.lineStyle(0,_color,.25);
		graphics.drawCircle(0, 0, this.radius);
	}
}