/**
 * Copyright Arkatufus ( http://wonderfl.net/user/Arkatufus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2ryE
 */

/*
 *
 * This is the standard example for importing external classes 
 * from an ApplicationDomain class, but it won't work in wonderfl.
 *
 * Is there a way to make this work, or is it just impossible to do?
 *
 */
package {
    import flash.display.DisplayObject;
    import flash.display.Sprite;
	import flash.display.MovieClip;
    import flash.errors.IllegalOperationError;
    import flash.events.Event;

    [SWF(backgroundColor="#FFFFFF", frameRate=60)]
    public class BounceLoader extends Sprite {
        private var loader:ClassLoader;

        public function BounceLoader() {
            loader = new ClassLoader();
            loader.addEventListener(ClassLoader.LOAD_ERROR,loadErrorHandler);
            loader.addEventListener(ClassLoader.CLASS_LOADED,classLoadedHandler);
            loader.load("http://samplerinfo.com/wonderfl/Bounce.swf");
        }

        private function loadErrorHandler(e:Event):void {
            trace("Cannot load the specified file.");
        }

        private function classLoadedHandler(e:Event):void {
            var Bounce:Class = loader.getClass("Bounce");
            var bounce:MovieClip;
            
            for(var i:int=0; i<10; i++){
                bounce = new Bounce();
                bounce.x = Math.random() * 200;
                bounce.y = Math.random() * 200;
                addChild(bounce);
            }
		}
    }
}

import flash.display.Loader;
import flash.errors.IllegalOperationError;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.net.URLRequest;
import flash.system.ApplicationDomain;
import flash.system.LoaderContext;

class ClassLoader extends EventDispatcher {
    public static var CLASS_LOADED:String = "classLoaded";
    public static var LOAD_ERROR:String = "loadError";
    private var loader:Loader;
    private var swfLib:String;
    private var request:URLRequest;
    private var loadedClass:Class;

    public function ClassLoader() {

        loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE,completeHandler);
        loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR,ioErrorHandler);
        loader.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
    }

    public function load(lib:String):void {
        swfLib = lib;
        request = new URLRequest(swfLib);
        var context:LoaderContext = new LoaderContext();
        context.applicationDomain=ApplicationDomain.currentDomain;
        loader.load(request,context);
    }

    public function getClass(className:String):Class {
        try {
            return loader.contentLoaderInfo.applicationDomain.getDefinition(className)  as  Class;
        } catch (e:Error) {
            throw new IllegalOperationError(className + " definition not found in " + swfLib);
        }
        return null;
    }

    private function completeHandler(e:Event):void {
        dispatchEvent(new Event(ClassLoader.CLASS_LOADED));
    }

    private function ioErrorHandler(e:Event):void {
        dispatchEvent(new Event(ClassLoader.LOAD_ERROR));
    }

    private function securityErrorHandler(e:Event):void {
        dispatchEvent(new Event(ClassLoader.LOAD_ERROR));
    }
}
