/**
 * Copyright foo9 ( http://wonderfl.net/user/foo9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2r8A
 */

package
{
    import flash.display.Sprite;
	import flash.display.Shape;

	[SWF(backgroundColor="#CCCCCC")]
    public class BezierTest extends Sprite
    {
    		public function BezierTest()
    		{
            var s:Shape = Bezier.drawBezier(0, 120, 60, 20, 180, 40, 260, 160);
    			addChild(s);
    		}
    }
}

//************************************************************************************************

//@see ベジエ曲線の仕組み (4) - ActionScript 3.0 でベジエ曲線を描く - てっく煮ブログ
//     http://d.hatena.ne.jp/nitoyon/20070921/bezier_4

import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Point;
class Bezier
{
	/*
	private var sp:Point; //start point
	private var cp1:Point; //control point 1
	private var cp2:Point; //control point 2
	private var ep:Point; //end point
	
	public function Bezier(spx:Number, spy:Number, cp1x:Number, cp1y:Number, cp2x:Number, cp2y:Number, epx:Number, epy:Number)
    {
    		sp = new Point(spx, spy);
    		cp1 = new Point(cp1x, cp1y);
    		cp2 = new Point(cp2x, cp2y);
    		ep = new Point(epx, epy);
    		drawBezier();
    }
    */
    
    public static function drawBezier(spx:Number, spy:Number, cp1x:Number, cp1y:Number, cp2x:Number, cp2y:Number, epx:Number, epy:Number):Shape
    {
    		var sp:Point = new Point(spx, spy);
    		var cp1:Point = new Point(cp1x, cp1y);
    		var cp2:Point = new Point(cp2x, cp2y);
    		var ep:Point = new Point(epx, epy);
    		    		
    		var shape:Shape = new Shape();
    		var graphics:Graphics = shape.graphics;
    		
    		var pt:Point;
    		var pt2:Point;
    		var pt3:Point;
    		var diff:Number = 0.25; // 1/4
    		
    		graphics.moveTo(sp.x, sp.y);
    		graphics.lineStyle(1.0, 0xff0000);
    		for(var t:Number = diff * 2; t <= 1.0; t += diff * 2)
    		{
    			pt  = new Point(Math.pow(1 - t, 3)  * sp.x + 3 * t * Math.pow(1 - t, 2) * cp1.x + 3 * t * t * (1 - t) * cp2.x + t * t * t * ep.x, Math.pow(1 - t, 3)  * sp.y + 3 * t * Math.pow(1 - t, 2) * cp1.y + 3 * t * t * (1 - t) * cp2.y + t * t * t * ep.y);
			pt2 = new Point(Math.pow(1 - (t - diff), 3)  * sp.x + 3 * (t - diff) * Math.pow(1 - (t - diff), 2) * cp1.x + 3 * (t - diff) * (t - diff) * (1 - (t - diff)) * cp2.x + (t - diff) * (t - diff) * (t - diff) * ep.x, Math.pow(1 - (t - diff), 3)  * sp.y + 3 * (t - diff) * Math.pow(1 - (t - diff), 2) * cp1.y + 3 * (t - diff) * (t - diff) * (1 - (t - diff)) * cp2.y + (t - diff) * (t - diff) * (t - diff) * ep.y);
    			pt3 = new Point(Math.pow(1 - (t - 2 * diff), 3)  * sp.x + 3 * (t - 2 * diff) * Math.pow(1 - (t - 2 * diff), 2) * cp1.x + 3 * (t - 2 * diff) * (t - 2 * diff) * (1 - (t - 2 * diff)) * cp2.x + (t - 2 * diff) * (t - 2 * diff) * (t - 2 * diff) * ep.x, Math.pow(1 - (t - 2 * diff), 3)  * sp.y + 3 * (t - 2 * diff) * Math.pow(1 - (t - 2 * diff), 2) * cp1.y + 3 * (t - 2 * diff) * (t - 2 * diff) * (1 - (t - 2 * diff)) * cp2.y + (t - 2 * diff) * (t - 2 * diff) * (t - 2 * diff) * ep.y);
    			pt2 = new Point(2 * pt2.x - (pt.x + pt3.x) / 2, 2 * pt2.y - (pt.y + pt3.y) / 2);
    			graphics.curveTo(pt2.x, pt2.y, pt.x, pt.y);
    		}
    		
    		return shape;
    }
    
    /*
    private function drawBezier():void
    {
    		var pt:Point;
    		var pt2:Point;
    		var pt3:Point;
    		var diff:Number = 0.25; // 1/4
    		
    		graphics.moveTo(sp.x, sp.y);
    		graphics.lineStyle(1.0, 0xff0000);
    		for(var t:Number = diff * 2; t <= 1.0; t += diff * 2)
    		{
    			pt  = getBezierPoint(t);
    			pt2 = getBezierPoint(t - diff);
    			pt3 = getBezierPoint(t - 2 * diff);
    			pt2 = new Point(2 * pt2.x - (pt.x + pt3.x) / 2, 2 * pt2.y - (pt.y + pt3.y) / 2);
    			graphics.curveTo(pt2.x, pt2.y, pt.x, pt.y);
    		}
    	}
        
    private function getBezierPoint(t:Number):Point
    {  
		return new Point(Math.pow(1 - t, 3)  * sp.x + 3 * t * Math.pow(1 - t, 2) * cp1.x + 3 * t * t * (1 - t) * cp2.x + t * t * t * ep.x, Math.pow(1 - t, 3)  * sp.y + 3 * t * Math.pow(1 - t, 2) * cp1.y + 3 * t * t * (1 - t) * cp2.y + t * t * t * ep.y);
	}
	*/
}