/**
 * Copyright Lorenz82 ( http://wonderfl.net/user/Lorenz82 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2r5M
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.MovieClip;
    public class FlashTest extends Sprite {      
        
        private var gridWidth:Number;
        private var gridHeight:Number;
        private var gridColumns:int;
        private var gridRows:int;
        private var numVariants:int = 2; // How many different sizes of square?
        
        private var pictureGrid:Array;//keeps track of what grid cells are taken by previous placement of pictures
        private var arrayOfPictures:Array;
        
        public function FlashTest() {
            gridWidth = 50;
            gridHeight = 50;
            gridColumns = 450/gridWidth;
            gridRows = 450/gridHeight;
            pictureGrid = createGrid();
            
            arrayOfPictures=createPictures(gridColumns*gridRows);
            
            addPictures(arrayOfPictures);           
        }
        
        
        
        private function createGrid():Array // this creates a grid that keeps track of what cells have been already occupied by previous pictures
        {
            var a:Array=new Array();
            var b:Array;
            for(var i:int=0;i<gridColumns;i++)
            {
                b=new Array();
                for(var j:int=0;j<gridRows;j++)
                {
                    b.push(false);//false indicates that the grid square is not yet taken
                }
                b.push(true);// This creates a cap at the end of the COLUMN to prevent pictures being placed off the edge
                a.push(b);
            }
            
            b=new Array();// This creates a cap at the end of the ROW to prevent pictures being placed off the edge
            for(var k:int=0;k<gridRows;k++)
            {
                b.push(true);//false indicates that the grid square is not yet taken
            }
            a.push(b);
            
            return(a);
        }
        
        private function addPictures(picArray:Array):void // iterate through the grid, check for an empty grid square, check if adjacent grid squares for size of picture are unoccupied, set the pictures target coordinates
        {
            for(var i:int=0;i<picArray.length;i++)//run through each picture
            {
                var m:MovieClip = picArray[i];
                searchLoop: for(var r:int=0;r<gridRows;r++)//run through each row
                {
                    for(var c:int=0;c<gridColumns;c++)//run through each column
                    {
                        if(pictureGrid[c][r]==false)//if the current square is unoccupied
                        {
                            // Matt: iterate through adjacent grid squares and check if available
                            var safe:Boolean=true;
                            for(var x:int=0;x<m.gridSquares*3;x++)
                            {
                                for(var y:int=0;y<m.gridSquares*2;y++)
                                {
                                    if(pictureGrid[c+x][r+y]==true)
                                    {
                                    safe=false;
                                    break; // from the "for y" loop
                                    }
                                }
                                if (safe==false) {break} // from the "for x" loop
                            }
                            
                            if (safe==true) // Matt: Probably a better way to pass the exit status of the for loops than this, but since I don't know AS...
                            {
                                m.x=c*gridWidth;
                                m.y=r*gridWidth;
                                addChild(m);
                                
                                for(x=0;x<m.gridSquares*3;x++)
                                {
                                    for(y=0;y<m.gridSquares*2;y++)
                                    {
                                        pictureGrid[c+x][r+y]=true //Mark grid squares as occupied.
                                    }
                                }
                                break searchLoop;//from the switch statement
                            }
                        }
                    }
                }
            }
        }        
        
        
        private function createPictures(n:int=30):Array
        {
            var a:Array=new Array();
            for(var i:int=0;i<n;i++)
            {
                var r:int=Math.random()*numVariants+1; // random
                var c:int=Math.random()*numVariants+1; // control
                var d:int=Math.random()*1+1; // horizonal or vertical
                if (r<=c) // make less squares the bigger they are.
                {
                    var rectX:int=gridWidth*r*3-1;
                    var rectY:int=gridWidth*r*2-1;
                    var m:MovieClip=new MovieClip();
                    m.graphics.beginFill(Math.random()*0xFFFFFF);
                    m.graphics.drawRect(0,0,rectX,rectY);
                    m.gridSquares=r;
                    a.push(m);
                }
            }
            return(a);
        }       

    }
}