/**
 * Copyright ameo ( http://wonderfl.net/user/ameo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2qJS
 */

// forked from ameo's forked from: 車が動くアニメーション
// forked from 9re's 車が動くアニメーション
//チョロQにする課題のやつ。

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent; 
    import flash.events.Event;

    public class AnimationExample extends Sprite{
        // 車のクラス
        private var _car:Car;
        private var _Xzahyou:Number = 0;
        private var _zenmai:Boolean = false;
        private var _lock:Boolean = false;
        public function AnimationExample() {
            // 車のクラスのインスタンスを作る
            // 色は木賊色にする
            _car = new Car(0x3b7960);
            _car.x = 100;          // 車のx座標を100に
            _car.y = 200;          // 車のy座標を200に

            addChild(_car);        // 表示リストに追加
            _car.buttonMode = true; //手のカーソルに変更
            _car.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            _car.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);   

           // 1フレーム毎に実行する処理にmoveCarを追加する
            addEventListener(Event.ENTER_FRAME, moveCar);
        }
        

        //マウス・ダウン時にドラッグ開始
        private function onMouseDown(e:MouseEvent):void
        {
           _lock = true;
           _zenmai = true;
 　         _Xzahyou = _car.x;
            e.currentTarget.startDrag();

        }
        //ガソリン注入
        private function onMouseMove(e:MouseEvent):void
        {
        	  if (_zenmai){
            if (_car.x > _Xzahyou)
            _Xzahyou = _car.x;
            _car.putGas(_Xzahyou - _car.x) ;
        	  }
        }
        
        //マウス・アップ時にドラッグ終了
        private function onMouseUp(e:MouseEvent):void
        {
            _car.putGas(_Xzahyou - _car.x);
        	   　_zenmai = false;
        	    _lock = false;
            e.currentTarget.stopDrag();
        }
        
       private function moveCar(e:Event):void {
          if (!_lock)
              _car.move();
    }
    

    }
}


import flash.display.Sprite;

class Car extends  Sprite {
    // ガソリンの量最初は入っていない = 0
    private var _gas:int = 0;
    
    // コンストラクタ
    // 製造時に車の色は決まる
    public function Car(_fillColor:uint) {
        // 描画
        _draw(_fillColor);
    }
    
    // ガソリンを入れる。
    public function putGas(_amount:int):void {
        if (_amount < 0) {     // もしガソリンの量が0以下だったら
            return;            // 何もしないで、ここで終了
        }
        
        _gas += _amount;       // $amountだけ_gasの量を増やす
    }
    
    // 車を動かす
    public function move():void {
        if (_gas > 20) {        // ガスの残量が20より大きい場合
            x += 5;             // x座標を5だけ増やす
        } else {                // ガスの量が20以下の場合
            x += _gas / 3;      // 残りのガスの量によって動きが変わる
        }
        
        _gas--;                 // 車が動くとガスは減る
        if (_gas < 0) {         // もしガスの量が0より小さいなら
            _gas = 0;           // ガスの量を0にセットする
        }                       // ガスの量はマイナスにはならない
    }
    // 描画メソッド。privateなので外からは見えない
    // 車の形や色は製造される時に決まってしまうので外部からは
    // 呼べない
    private function _draw(_fillColor:uint):void
    {
        // 車輪を書く
        graphics.beginFill(0x333333);
        graphics.drawCircle(10, 20, 5);
        graphics.drawCircle(45, 20, 5);
        graphics.endFill();
        // 車体を書く
        graphics.beginFill(_fillColor);
        graphics.moveTo(0, 12);
        graphics.lineTo(10, 5);
        graphics.lineTo(25, 5);
        graphics.lineTo(35, 10);
        graphics.lineTo(45, 10);
        graphics.lineTo(55, 15);
        graphics.lineTo(55, 20);
        graphics.lineTo(0, 20);
        graphics.endFill();
    }
}