/**
 * Copyright bshh ( http://wonderfl.net/user/bshh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2qHE
 */

package {
    import frocessing.display.F5MovieClip2DBmp;
    import flash.geom.ColorTransform;
    
    public class Frocessing_basic02_1 extends F5MovieClip2DBmp
    {
        private var ct:ColorTransform = new ColorTransform( 0.8, 0.98, 0.98 );
        private var lines:Array     = [];
        private var drawCount:int   = 30;
        private var cx:Number       = 250;
        private var cy:Number       = 250;
        private var nz:Number       = 0;
        private var noiseScale:Number = 100;
        private var line_length:Number = 10;
        
        public function Frocessing_basic02_1() {
            super( false, 0 );
            size( 500, 500 );
        }
        
        public function draw():void {
            //CurveDataの追加
            for ( var n:int = 0; n < 10 ; n++ ){
                var da:Number = random( 6 );
                lines.push( new CurveData( cx+cos(da)*100, cy+sin(da)*100 ) );
            }
            //描画
            noFill();
            for (var i:int = 0; i < lines.length; i++) {
                var c:CurveData = lines[i];
                var b:Number = noise( c.x3/noiseScale, c.y3/noiseScale, nz )*30;
                c.add( cos(b)*line_length, sin(b)*line_length );
                stroke( 255, 1*(drawCount - c.n)/drawCount );
                curve( c.x0, c.y0, c.x1, c.y1, c.x2, c.y2, c.x3, c.y3 );
                if ( c.n >= drawCount ) {
                    lines.splice( i, 1 ); i--;
                }
                trace(lines.length);
            }
            //アニメーション
            if ( !isMousePressed ) {
                bitmapData.colorTransform( bitmapData.rect, ct );
                nz += 0.02;
            }
        }
    }
}

class CurveData {
        public var x0:Number, x1:Number, x2:Number, x3:Number;
        public var y0:Number, y1:Number, y2:Number, y3:Number;
        public var n:int = 0;
        public function CurveData( x:Number, y:Number ) {
            x0 = x1 = x2 = x3 = x;
            y0 = y1 = y2 = y3 = y;
        }
        public function add( dx:Number, dy:Number ):void {
            x0 = x1; x1 = x2; x2 = x3; x3 += dx;
            y0 = y1; y1 = y2; y2 = y3; y3 += dy;
            n++;
        }
    }
