/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2pC8
 */

package
{
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import frocessing.math.Random;
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.Prop;
	import jp.progression.commands.Wait;
	
	public class Main extends Sprite
	{
		private var data:Array;
		private var SIZE:int = 5;
		private var num:int = 80;
		private var list:SerialList = new SerialList();
		
		public function Main()
		{
			graphics.beginFill(0xF0F0F0);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			data = new Array(num);
			for (var i:int = 0; i < data.length; i++)
			{
				var rect:Rect = new Rect(SIZE);
				rect.x = i * SIZE;
				rect.y = i * SIZE;
				addChild(rect);
				data[i] = rect;
			}
			init();

			new PushButton(this, 185, 400, "execute", execute);
		}
		
		private function execute(event:Event):void
		{
			if (list.state == 2) return;
			list = new SerialList();
			
			init();
			sort();
			list.execute();
		}
		
		private function init():void
		{
			var random:Array = Random.shakedIntegers(num);
			for (var i:int = 0; i < data.length; i++)
			{
				data[i].x = random[i] * SIZE;
			}
		}
		
		private function sort():void
		{
			var copy:Array = new Array(num);
			for (var i:int = 0; i < data.length; i++)
			{
				copy[i] = data[i].x;
			}
			
			var swapped:Boolean;
			var h:int = copy.length;
			while (true)
			{
				swapped = false;
				for (i = 0; i + h < copy.length; i++)
				{
					if (copy[i] > copy[i + h])
					{
						list.addCommand(new Func(function(a:int, b:int, value1:int, value2:int):void { data[b].x = value1; data[a].x = value2;}, [i, i + h, copy[i], copy[i + h]]));
						list.addCommand(new Wait(20 / 1000.0));
						
						var temp:int = copy[i];
						copy[i] = copy[i + h];
						copy[i + h] = temp;
						swapped = true;
					}
				}
 
				if (h == 1)
				{
					if (!swapped) break;
				}
				else h /= 1.3;
			}
		}
	}
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;

class Rect extends Sprite
{
	public function Rect(size:int)
	{
		graphics.beginFill(0x0);
		graphics.drawRect(0, 0, size, size);
		graphics.endFill();
		
		this.filters = [new DropShadowFilter(2)];
	}
}