/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2oER
 */

package {
    //▼インポート
    import flash.display.Sprite;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Collision.Shapes.b2PolygonDef; 
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import Box2D.Collision.Shapes.b2MassData;
   
   
   public class Box2D_05_03 extends Sprite {
        //▼定数定義
        //1mを表すピクセル数
        private static const DRAW_SCALE:Number = 100;
        //▼プロパティ定義
        private var _world:b2World;
        private var _bArrow:b2Body;
        //▼コンストラクタ定義
        public function Box2D_05_03() {
            //▼物理エンジンのセットアップ
            //物理エンジン適用範囲の設定（ステージの100ピクセル外側）
            var worldRegion:b2AABB = new b2AABB();//矩形作成
            worldRegion.lowerBound.Set(-1, -1);
            worldRegion.upperBound.Set(6.5, 5);
            //重力の設定
            var gravity:b2Vec2 = new b2Vec2(0, 0.98);
            //範囲・重力・スリープの有無を指定して物理ワールドを作成
            _world = new b2World(worldRegion, gravity, true);

            //▼床（静体）の生成
            //BodyDefの設定
            var bdFloor:b2BodyDef = new b2BodyDef();
            bdFloor.position.Set(5.5 / 2, 4);
            //ShapeDefの設定
            var pdFloor:b2PolygonDef = new b2PolygonDef();
            pdFloor.SetAsBox(4, 0.15);
            //ボディの生成
            var bFloor:b2Body = _world.CreateBody(bdFloor);
            bFloor.CreateShape(pdFloor);

            //▼やじり型（動体）の生成
            
           
            
            
            
            var bdArrow:b2BodyDef = new b2BodyDef(); 
            bdArrow.position.Set(0,0);  
            //1つめのb2ShapeDefオブジェクトを生成
            var shape1:b2PolygonDef = new b2PolygonDef();
            shape1.vertexCount = 3;
            shape1.vertices[0].Set(0, -0.25);
            shape1.vertices[1].Set(0,0);
            shape1.vertices[2].Set(-0.25, 0.25);
            shape1.density = 1;
            shape1.restitution = 0.5;
            //2つめのb2ShapeDefオブジェクトを生成
            var shape2:b2PolygonDef = new b2PolygonDef();
            shape2.vertexCount = 3;
            shape2.vertices[0].Set(0, -0.25);
            shape2.vertices[1].Set(0.25, 0.25);
            shape2.vertices[2].Set(0, 0);
            shape1.density = 1;
            shape2.restitution = 0.5;
            //ボディの生成
            _bArrow = _world.CreateBody(bdArrow);
            _bArrow.CreateShape(shape1);
            _bArrow.CreateShape(shape2);
            //位置の設定
            _bArrow.SetXForm(new b2Vec2(5.5 / 2, 1), Math.PI/180* 30); 
            //質量の設定
            _bArrow.SetMassFromShapes();
            
           //
            var massData:b2MassData = new b2MassData();
            massData.mass = _bArrow.GetMass();
            massData.center = new b2Vec2(0,0);
            massData.I = _bArrow.GetInertia();  
            _bArrow.SetMass(massData);
            
            //
            _bArrow.SetLinearVelocity(new b2Vec2(0,0)); 
            

            //▼描画設定
            var dd:b2DebugDraw = new b2DebugDraw();
            dd.m_sprite = this;
            dd.m_drawScale = DRAW_SCALE; //1mを100ピクセルにする
            dd.m_fillAlpha = 0.3; //塗りのアルファ値
            dd.SetFlags(b2DebugDraw.e_shapeBit);//物体を表示する設定に
            _world.SetDebugDraw(dd);//物理ワールドにセット
            
            
            var btn:Sprite =new Sprite();
            btn.graphics.beginFill(0xff0000);
            btn.graphics.drawCircle(100,100,10); 
            btn.graphics.endFill();
            
            addChild(btn);
            //▼イベントリスナーの追加
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            btn.addEventListener(MouseEvent.CLICK,btnclick);
            
        }

        //▼イベントリスナー定義
        private function _enterFrameHandler(eventObj:Event):void {
            _world.Step(1 / 24, 10);//物理シミュレーションの更新
        }
        private function btnclick(eventObj:MouseEvent):void{
        	
        	  _bArrow.ApplyImpulse(new b2Vec2(0,-0.05),_bArrow.GetWorldCenter().Copy());
        	   _bArrow.SetAngularVelocity(-3); 
    }}  
}