/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2oAB
 */

// forked from juna's flash on 2010-3-3
/**
 * YouTubeのようなフルスクリーンへの画面モード切替
 * http://d.hatena.ne.jp/ActionScript/20080925/as3_youtube_fullscreen
 * 右下のボタンを押すとフルスクリーンに切り替わります。
 */
package  
{
    import flash.display.Sprite;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.FullScreenEvent;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    
    public class FullScreenButton extends Sprite 
    {
        private var textField:TextField;
        
        public function FullScreenButton():void 
        {
            addEventListener(Event.ADDED_TO_STAGE, setup);
        }
        
        private function setup(event:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, setup);
            
            createFullScreenButton();
            
            // FullScreenEventの状態表示用テキスト
            textField = new TextField();
            textField.textColor = 0xffffff
            textField.autoSize = TextFieldAutoSize.LEFT;
          //  textField.text = "【FullScreenEventをキャッチ】";
            textField.selectable = false;
            textField.alpha = 0;
            stage.addChild(textField);
            
            stage.addEventListener(FullScreenEvent.FULL_SCREEN, fullScreenEventHandler);
        }
        
        private function createFullScreenButton():void
        {
            // 画面右下にボタン配置（YouTube風）
            var margin:Number = 10;
            var button:Sprite = new Sprite();
            button.graphics.beginFill(0xf4f4f4);
            button.graphics.lineStyle(1, 0xb1b1b1);
            button.graphics.drawRect(0, 0, 34, 24);
            button.graphics.lineStyle();
            button.graphics.beginFill(0x4d4d4d);
            button.graphics.drawRoundRect(7, 5, 21, 14, 3);
            button.graphics.beginFill(0xc1c1c1);
            button.graphics.drawRoundRect(8, 6, 10, 6, 2);
            button.graphics.endFill();
            button.x = stage.stageWidth - button.width - margin;
            button.y = stage.stageHeight - button.height - margin;
            button.buttonMode = true;
            
            // フルスクリーンと通常画面を切り替える無名関数
            button.addEventListener(MouseEvent.CLICK, function():void
            {
                if (stage.displayState == StageDisplayState.NORMAL)
                    stage.displayState = StageDisplayState.FULL_SCREEN; // フルスクリーン化
                else
                    stage.displayState = StageDisplayState.NORMAL; // 通常化
            });
            
            addChild(button);
        }
        
        private function fullScreenEventHandler(event:FullScreenEvent):void 
        {
            if (event.fullScreen)
                textField.alpha = 1; // 【FullScreenEventをキャッチ】を表示
            else
                textField.alpha = 0; // 【FullScreenEventをキャッチ】を非表示
        }
    }
}