/**
 * Copyright LuisReyes ( http://wonderfl.net/user/LuisReyes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2nWe
 */

package {
    import flash.display.MovieClip;
    import flash.display.Sprite;
    
    import com.actionsnippet.qbox.*;
    import flash.events.MouseEvent;
    import flash.utils.Dictionary;
    
    public class FlashTest extends MovieClip 
    {
        private var sim:QuickBox2D;
        private var lookup:Dictionary = new Dictionary();
        private static const POINTS_PER_HIT:int = 10;
        private static const WORLD_SCALE:int = 30;
        
        public function FlashTest()
        {
            sim = new QuickBox2D(this as MovieClip);
            sim.createStageWalls();
            
            var ball:QuickObject = sim.addCircle({x:20,y:10,radius:1});
            
            build();
            
            sim.start();
            sim.mouseDrag();
            
        }
        
        private function build():void
        {
            var boxes:Array = new Array();
            
            
            //Fork with these values for
            //--------------------------//
            var xOffset:Number = 2.5;
            var baseAmount:int = 16;
            var stacksAmount:int = 16;
            var boxSize:Number = .5;
            //--------------------------//
            
            
            var boxSpacing:Number = boxSize/2;
            
            for(var stacks:int = 0; stacks < stacksAmount; stacks++)
            {
                for(var i:int = 0; i < baseAmount-stacks; i++ )
                {
                    var box:QuickObject = sim.addBox({x:xOffset+(i*(boxSize+boxSpacing)),y:15-(stacks*boxSize),width:boxSize,height:boxSize});
                    boxes[i] = box;
                    lookup[box.userData] = box;
                    
                    box.userData.addEventListener(MouseEvent.CLICK, onBoxClick);
                    
                }
                
                xOffset += boxSize - (boxSize/4);
                //xOffset += .75;
            }
        }
        
        private function onBoxClick(e:MouseEvent):void
        {
            e.currentTarget.removeEventListener(MouseEvent.CLICK, onBoxClick);
            lookup[e.currentTarget].destroy();
        }
    }
}