/**
 * Copyright darman ( http://wonderfl.net/user/darman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2mRm
 */

/*
[CM]-------------------------------------------
週刊 フラッシュ コレクション創刊

毎号送られてくるパーツを、
ステップ・バイ・ステップで組み立てるオモシロさ。

有名フラッシャーの作品まで再現したこだわりの完成度。
マガジンにはファイル管理の仕方や、ちょっとした小ワザなど満載。
毎号送られてくるサンプルを、忠実に再現していけばあなたもフルフラッシュサイトが作れる！

創刊号は590円
オカゴスティーニ♪
----------------------------------------------

■創刊号：商品概要
記念すべき創刊号では、
画像の読み込みとローディングを表示するという、
基本的な仕組みだが奥深いフラッシュを作っていく。


〓パーツ
・読み込み状況を楽しく確実に表示する「レインボー！プログレスバー！」
・読み込み用の「癒し画像」で作業が楽しくなる！


〓ステップ・バイ・ステップ
・画像1枚を読み込む
1.画像の読み込みにはLoaderクラスを使おう
2.プログレスバーを滑らかにアニメーションさせ、華麗にローディングさせよう
3.画像をフェードインで艶かしく表示


★使用上の注意
・出来る限り関数毎なり一行毎なりコメントを入れるようにして下さい。
・casalibやTweenerなどのライブラリはまだ使用しないでください。
　早い段階でライブラリを使ってしまうと確実に命を落とします。
・毎週月曜日に送付されます。お問い合わせは、その週に送付された号の内容に限ります。
　バックナンバーのお問い合わせは対応しかねる場合がございますので、ご了承ください。

オカゴスティーニでは、毎週月曜日に組み立てキットをお送りいたしますが、
解答例としてオカゴスティーニ社長自らが組み立てたフラッシュを、
その「月の最後」にお送りいたします。
ご安心ください。
（あくまで、いち解答ですので皆様は気にせず自分なりのフラッシュをお作りください。）

しかし、定期購読者様には、
月の最後あたりで何かしらのアウトプットを要求いたしますので、お気をつけください。
現段階では、今まで送られてきたキットを使って何か作っていただきたいと考えております。

以上の点を踏まえ、
「週刊 フラッシュ コレクション」をお楽しみください。


※おそらく、このシリーズは100号で完結します。 
*/ 


package {
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Bitmap;
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.ProgressEvent;
	import flash.net.URLRequest;

	import flash.text.TextField;
	import flash.system.LoaderContext;
	
	public class FlashTest extends Sprite　{
		//画像のパス
		private var _imgPath:String = "http://assets.wonderfl.net/images/related_images/6/6e/6e04/6e04d22cf1ab7e9d31a53f73ce35094156383cb6";
		
		//読み込み状況を表示するスプライト
		private var _progressBar:ProgressBar;
		
		//パーセント
		private var _percent:Number = 0;
		
		//ローダーを徐々に伸ばすための摩擦係数
		private var _friction:Number = 0.15;
		
		//画像表示用のローダー
		private var _loader:Loader
		
		
		public function FlashTest() {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.HIGH;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			//プログレスバーの作成
			_progressBar = new ProgressBar(stage.stageWidth - 70 , 15);
			_progressBar.x = stage.stageWidth / 2 - _progressBar.width / 2;
			_progressBar.y = stage.stageHeight / 2 - _progressBar.height / 2;
			_progressBar.scaleX = 0;
			addChild(_progressBar);
			
			//画像読み込みの準備
			var req:URLRequest = new URLRequest(_imgPath);
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.OPEN, _imgLoadStart);
			_loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, _imgProgress);
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _imgLoadComp);
			_loader.load(req);
		}
		
		/*
		 * 画像の読み込みを開始
		 */
		private function _imgLoadStart(e:Event):void {
			_progressBar.addEventListener(Event.ENTER_FRAME, _onUpdate );
		}
		
		/*
		 * 読み込みのパーセントを算出
		 */
		private function _imgProgress(e:ProgressEvent):void {
			_percent = e.bytesLoaded / e.bytesTotal;
		}
		
		/*
		 * 画像の読み込み状況を表示
		 */
		private function _onUpdate(e:Event):void {
			
			//プログレスバーのスケールが限りなく1に近づいたときと、
			//パーセントが1だったらプログレスバーをフェードアウト
			if ( _progressBar.scaleX > 0.999 && _percent == 1) {
				
				//読み込み完了後 プログレスバーをフェードアウト
				_progressBar.scaleX = 1;
				_progressBar.alpha -= 0.1;
				
				if ( _progressBar.alpha <= 0 ) {
					removeChild(_progressBar);
					_progressBar.removeEventListener(Event.ENTER_FRAME, _onUpdate );
					
					//プログレスバーのフェードアウト完了後、画像をフェードインさせる
					_loader.addEventListener(Event.ENTER_FRAME, _imgFadeIn);
				}
				
			}else {
				//徐々にプログレスバーを伸ばす
				_progressBar.scaleX += ( _percent - _progressBar.scaleX ) * _friction;
			}
			
		}
		
		/*
		 * 読み込み完了
		 */
		private function _imgLoadComp(e:Event):void {
			_loader.alpha = 0;
			addChild(_loader);
		}
		
		/*
		 * 画像をフェードイン
		 */
		private function _imgFadeIn(e:Event):void {
			e.target.alpha += 0.05;
			if ( e.target.alpha >= 1 ) {
				e.target.removeEventListener(Event.ENTER_FRAME, _imgFadeIn );
			}
		}
		
	}
}

//レインボー プログレスバーのクラス
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.Matrix;
class ProgressBar extends Sprite
{
	public function ProgressBar(barW:uint=100, barH:uint=15)
	{
		var fillType:String = GradientType.LINEAR;
		//各グラデーションコントロールの色
  		var colors:Array = [0xFF0000,0xFFFF00,0x00FF00,0x00FFFF,0x0000FF,0xFF00FF,0xFF0000];
  		//各グラデーションコントロールの不透明度
  		var alphas:Array = [1,1,1,1,1,1,1];
  		//0～255段階での割合
  		var ratios:Array = [0,39,91,125,168,210,255];
  		var mat:Matrix = new Matrix();
  		//Matrixを使用したグラデーションの設定　createGradientBox(横幅,縦幅,角度,Xのオフセット値,Yのオフセット値);
  		mat.createGradientBox(barW, 15,0,0,0);
  		var spreadMethod:String = SpreadMethod.PAD;
		
		graphics.beginGradientFill(fillType, colors, alphas, ratios, mat, spreadMethod);
		graphics.drawRect(0, 0, barW, barH);
		graphics.endFill();
	}
}
