/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2kac
 */

package {
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.CurveModifiers;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	/**
        * 指定の場所へ、指定の向きで（ミサイルぽく）移動させてみたい
        * クリックで目標点切り替えて移動
        */
	[SWF(width="465", height="465", backgroundColor="0x0", frameRate="40")]
	public class LineVector extends Sprite
	{
		CurveModifiers.init();
		//動く子
		private var moveObj:mover = new mover();
		//目標のxy
		private var targetX:Number, targetY:Number;
		//目標の回転値
		private var R:Number = 70;
		//目標のしっぽ
		private var tPt:Point = new Point(0,0);
		private var tMC:Sprite = new Sprite();
		//目標の中間地点
		private var midPt:Point = new Point(0,0);
		private var mMC:Sprite = new Sprite();
		//次のステップ点
		private var nextPt:Point = new Point(0,0);
		private var nMC:Sprite = new  Sprite();
		//目印用の○
		private var pointer:Sprite = new Sprite();
		
		//目標の目印の子
		private var targetRect:Sprite = new Sprite();
		
		/**
		 * pararm
		 */
		private var trans:String = "easeOutQuint";
		
		public function LineVector()
		{
			addChild(targetRect);
			addChild(pointer);
			addChild(tMC);
			addChild(nMC);
			addChild(moveObj);
			moveObj.x = moveObj.y = 100;
			//ターゲット設定
			defineTarget();
			decideTails(targetRect,R,465*Math.random(), 465*Math.random());
			
			//pointer
			drawCirc(tMC);
			drawCirc(nMC);
			drawCirc(pointer);
			
			//ボール飛ばし
			gotoTargetR();
			
			addEventListener(Event.ADDED_TO_STAGE, addStageHandler);
		}
		
		private function addStageHandler(e:Event):void
		{
			stage.addEventListener(MouseEvent.CLICK, stageClickHandler);
		}
		//クリックで目標切り替え
		private function stageClickHandler(e:MouseEvent):void
		{
			R = 360 * Math.random();
			decideTails(targetRect,R,465*Math.random(), 465*Math.random());
			gotoTargetR();
		}
		private function drawCirc(mc:Sprite):void
		{
			mc.graphics.beginFill(0xFF0000);mc.graphics.drawCircle(0,0,4);
			mc.graphics.endFill();
		}
		
		//
		private function gotoTargetR():void
		{
			var bz:Array = [
				{x:nextPt.x,y:nextPt.y},{x:midPt.x,y:midPt.y},{x:tPt.x,y:tPt.y}
			];
			Tweener.addTween(moveObj,{x:targetRect.x, y:targetRect.y, _bezier:bz, time:3, transition:trans});
		}
		
		
		
		//目標の形設定
		private function defineTarget():void
		{
			targetRect.graphics.beginFill(0xCCCCCC);
			targetRect.graphics.moveTo(-20, -10);
			targetRect.graphics.lineTo(10,-5);
			targetRect.graphics.lineTo(10,5);
			targetRect.graphics.lineTo(-20,10);
			targetRect.graphics.endFill();
		}
		
		//目標のしっぽ//現在の次ステップ予定//目標との中間
		//を決める
		private function decideTails(targ:Sprite,r:Number,_x:Number,_y:Number):void
		{
			targetX = _x;
			targetY = _y;
			targetRect.x = targetX;
			targetRect.y = targetY;
			targetRect.rotation = R;
			
			var RR:Number = 100;
			//しっぽ
			tPt.x = targ.x - RR*Math.cos(r*Math.PI/180);
			tPt.y = targ.y - RR*Math.sin(r*Math.PI/180);
			tMC.x = tPt.x; tMC.y = tPt.y;
			//次ステップ
			nextPt.x = moveObj.x + moveObj.vx;
			nextPt.y = moveObj.y + moveObj.vy;
			nMC.x = nextPt.x; nMC.y = nextPt.y;
			//中間点
			var dx:Number = tPt.x-nextPt.x;
			var dy:Number = tPt.y-nextPt.y;
			var nR:Number = Math.atan2(dy,dx);
			var distance:Number = Math.sqrt(dx*dx + dy*dy);
			midPt.x = nextPt.x + (tPt.x-nextPt.x)/2 + distance*0.25*Math.cos(nR+90*Math.PI/180);
			midPt.y = nextPt.y + (tPt.y-nextPt.y)/2 + distance*0.25*Math.sin(nR+90*Math.PI/180);
			pointer.x = midPt.x; pointer.y = midPt.y;
			moveObj.vx = 100*Math.cos(targ.rotation*Math.PI/180);
			moveObj.vy = 100*Math.sin(targ.rotation*Math.PI/180);
		}
		
	}
}
	import flash.display.Sprite;
	


class mover extends Sprite {
	public var vx:Number = 10;
	public var vy:Number = 5;
	public function mover()
	{
		makeCirc();
	}
	
	private function makeCirc():void
	{
		this.graphics.beginFill(0xFFFFFF);
		this.graphics.drawCircle(0,0,4);
		this.graphics.endFill();
	}
}