/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2jiN
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import Box2D.Dynamics.b2World;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
 
	[SWF(backgroundColor="0x414647")]
	public class Main extends Sprite
	{
		private var world:b2World;
		private var scale:Number = 10;
 
		public function Main()
		{
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100, -100);
			worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
 
			var gravity:b2Vec2 = new b2Vec2(0, 50);
			world = new b2World(worldAABB, gravity, true);
 
			var draw:b2DebugDraw = new b2DebugDraw();
			draw.m_sprite = this;
			draw.m_drawScale = scale;
			draw.m_drawFlags = b2DebugDraw.e_shapeBit;
			world.SetDebugDraw(draw);
 
			Shape.world = world;
			Shape.scale = scale;
			Shape.create( { shape:Shape.RECT, x:-10, y:0, width:10, height:465 } );
			Shape.create( { shape:Shape.RECT, x:0, y:465, width:465, height:10 } );
			Shape.create( { shape:Shape.RECT, x:465, y:0, width:10, height:465 } );

			for (var i:int = 0; i < 7; i++)
			{
				var tx:int = (i % 2) ? 50 : 0;
				var angle:int = (i % 2) ? -45 : 45;
				Shape.create( { shape:Shape.RECT, angle:angle, x:tx, y:50 * i + 90, width:70, height:10 } );
			}

			for (i = 0; i < 10; i++)
			{
				Shape.create( { shape:Shape.RECT, x:i * 35 + 90, y:415, width:10, height:40, density:1, restitution:0.1 } );
			}

			Shape.create( { shape:Shape.CIRCLE, x:40, y:0, radius:7, density:10, restitution:0.3 } );
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void 
		{
			world.Step(1 / stage.frameRate, 10);
		}
	}
}
 
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
 
class Shape
{
	public static const CIRCLE:int = 0;
	public static const RECT:int = 1;
 
	public static var world:b2World;
	public static var scale:Number;
 
	public static function create(params:Object):b2Body
	{
		var def:b2BodyDef = new b2BodyDef();
		if (params.angle) def.angle = params.angle * Math.PI / 180;
		var shape:b2ShapeDef;
		if (params.shape == Shape.RECT)
		{
			def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
			shape = new b2PolygonDef();
			b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
		}
		else if (params.shape == Shape.CIRCLE)
		{
			def.position.Set(params.x / scale, params.y / scale);
			shape = new b2CircleDef();
			b2CircleDef(shape).radius = params.radius / scale;
		}
 
		shape.density = params.density;
		shape.restitution = params.restitution;
 
		var body:b2Body = world.CreateBody(def);
		body.CreateShape(shape);
 
		if (shape.density > 0) body.SetMassFromShapes();
 
		return body;
	}
}