/**
 * Copyright naokey0221 ( http://wonderfl.net/user/naokey0221 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2jHg
 */

// forked from ProjectNya's forked from: flash on 2010-5-21
// forked from bushi's flash on 2010-5-21

////////////////////////////////////////////////////////////////////////////////
// [AS3.0] ドットの光 (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1090
////////////////////////////////////////////////////////////////////////////////

package {
	import flash.display.Sprite;
 	import flash.geom.Rectangle;

	[SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
	
	public class Main extends Sprite {
		private var light:DotLight;
	
		public function Main() {
			Wonderfl.capture_delay(8);
			init();
		}
	
		private function init():void{
			light = new DotLight(new Rectangle(0, 0, 465, 465));
			addChild(light);
			light.start();
		}

	}
}


import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.events.Event;
import flash.display.Bitmap;
import flash.display.PixelSnapping;
import flash.display.BlendMode;

class DotLight extends Sprite {
	private var rect:Rectangle;
	private var canvas:BitmapData;
	private var sparkle:BitmapData;
	private static var scale:uint = 4;
	private var matrix:Matrix;
	private var light:EmitLight;
	
	public function DotLight(r:Rectangle){
		rect = r;
		init();
	}
	
	public function init():void{
		canvas = new BitmapData(rect.width, rect.height, false, 0xFF000000);
		var cBitmap:Bitmap = new Bitmap(canvas);
		addChild(cBitmap);
		sparkle = new BitmapData(rect.width/scale, rect.height/scale, false, 0xFF000000);
		var sBitmap:Bitmap = new Bitmap(sparkle, PixelSnapping.NEVER, true);
		sBitmap.scaleX = sBitmap.scaleY = scale;
		sBitmap.blendMode = BlendMode.ADD;
		addChild(sBitmap);
		matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
		light = new EmitLight(canvas);
	}
	public function start():void{
		addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
	}
	public function stop():void{
		removeEventListener(Event.ENTER_FRAME, draw);
	}
	private function draw(e:Event):void{
		light.create(10);
		canvas.lock();
		canvas.fillRect(canvas.rect, 0x00000000);
		light.emit();
		canvas.unlock();
		sparkle.lock();
		sparkle.draw(canvas, matrix);
		sparkle.unlock();
	}
}

class EmitLight{
	private var canvas:BitmapData;
	private var rect:Rectangle;
	private var dots:Array;
	private static var gravity:Number = 0.02;
	
	public function EmitLight(c:BitmapData){
		canvas = c;
		rect = canvas.rect;
		init();
	}
	public function init():void{
		dots = new Array();
	}	
	public function create(max:uint):void {
		for(var n:uint = 0; n < max; n++){
			var px:Number = Math.random() * rect.width;
			var py:Number = 0;
			var power:Number = Math.random() + 0.5;
			var dot:Dot = new Dot(px, py, power);
			dots.push(dot);
		}
	}
	public function emit():void {
		for(var n:uint = 0; n < dots.length; n++){
			var dot:Dot = dots[n];
			dot.vy += gravity * dot.power;
			dot.vy *= 0.99;
			dot.y += dot.vy;
			canvas.setPixel(dot.x, dot.y, dot.rgb);
			if(dot.y > rect.bottom){
				dots.splice(n, 1);
				dot = null;
			}
		}
	}
}

class Dot{
	public var x:Number = 0;
	public var y:Number = 0;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var power:Number = 1;
	public var rgb:uint = 0xFFFFFF;
	
	public function Dot(_x:Number, _y:Number, p:Number){
		x = _x;
		y = _y;
		power = p;
	}
}
