/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2iar
 */

// forked from coppieee's Snake Game - CHECKMATE受付終了してたｗ
/**
 * よし、いいアイディア出た！
 * CHECKMATEでもするか！
 * あれ？受付終わってね？
 * 
 * ・・・え？
 * いや、それでも作るぜ！
 * せっかくいいアイディア出たんだし。
 * 
 * というわけでSnake Game!
 * 画面クリックしないとキーボード反応しない。
 * 矢印キーで移動。
 * ゲームオーバの判定だけ。クリア判定は無いよ。
 * （フィールド埋め尽くすともれなく無限ループに入りますょ。）
 * 
 * リスタート出来るように改良した。
 * 点数表示した。
 * by coppieee
 */
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
  import flash.display.*;
  import flash.events.*;
  import flash.geom.*;
  import flash.text.*;
  import flash.ui.*;
  
  [SWF(frameRate = "7" )]
  public class Professional extends Sprite 
  {
    public static const FIELD_WIDTH:int = 32;
    public static const FIELD_HEIGHT:int = 16;
    public static const FIELD_SCALE:int = 4;
    private var _canvasContainer:Bitmap;
    private var _canvas:BitmapData;
    private var _field:Field;
    private var _snake:Snake;
    
    private var _information:TextField;
    
    public function Professional() 
    {
      Wonderfl.capture_delay( 15 );
      stage.scaleMode = StageScaleMode.NO_SCALE;
      stage.addEventListener(MouseEvent.CLICK, onClick);
      
      _canvas = new BitmapData(465, 465,false,0x000000);
      _canvasContainer = new Bitmap(_canvas);
      _canvasContainer.scaleX = FIELD_SCALE;
      _canvasContainer.scaleY = FIELD_SCALE;
      addChild(_canvasContainer);
      
      
      _information = new TextField();
      _information.multiline = true;
      _information.selectable = false;
      _information.textColor = 0xFFFFFF;
      _information.autoSize = TextFieldAutoSize.CENTER;
      _information.x = 456 / 2;
      _information.y = 456 / 2;
      _information.defaultTextFormat = new TextFormat(null, 20);
      _information.text = "click here to start.";
      
      addChild(_information);
      
    }
    private function onClick(e:MouseEvent):void
    {
      stage.removeEventListener(MouseEvent.CLICK, onClick);
      _information.text = "";
      initialize();
    }
    private function dispose():void
    {
      removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
      removeEventListener(Event.ENTER_FRAME, onEnterFrame);
      removeChild(_canvasContainer);
      _field = null;
      _snake = null;
    }
    private function initialize():void
    {
      addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
      addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
      
      
      _field = new Field(FIELD_WIDTH, FIELD_HEIGHT, [0xFF000000, 0xFF00FF00,0xFFFFFF00]);
      _snake = new Snake(_field);
      _field.changeFood();
    }
    
    private function onKeyDown(e:KeyboardEvent):void 
    {
      if (e.keyCode == Keyboard.LEFT)
      {
        _snake.nextAngle = Angle.LEFT;
      }else if(e.keyCode == Keyboard.RIGHT)
      {
        _snake.nextAngle = Angle.RIGHT;
      }else if (e.keyCode == Keyboard.UP)
      {
        _snake.jump();
      }
    }
    
    private function onKeyUp(e:KeyboardEvent):void 
    {
      if (e.keyCode == Keyboard.LEFT && _snake.nextAngle == Angle.LEFT)
      {
        _snake.nextAngle = null;
      }else if(e.keyCode == Keyboard.RIGHT && _snake.nextAngle == Angle.RIGHT)
      {
        _snake.nextAngle = null;
      }
    }
    
    private function onEnterFrame(e:Event):void
    {
      stage.focus = this;
      _snake.update();
      /*
      if (_snake.broken)
      {
        removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        gotoGameOver();
        return;
      }
      */
      var pattern:BitmapData = _field.buildBitmapData();
      for (var i:int = 0; i < 465/FIELD_WIDTH/FIELD_SCALE+1;i++ )
      {
        for (var j:int = 0; j < 465/FIELD_HEIGHT/FIELD_SCALE; j++ )
        {
          _canvas.copyPixels(pattern, pattern.rect, new Point((i - (j % 2)/2)*FIELD_WIDTH ,j * FIELD_HEIGHT));
        }
      }
    }
    
    private function gotoGameOver():void
    {
      _information.text = "Game Over\n\nclick here to restart.";
      stage.addEventListener(MouseEvent.CLICK, onClick);
    }
  }
}
class Field
{
  public function get width():int { return _width;}
  private var _width:int;
  public function get height():int { return _height;}
  private var _height:int;
  
  private var _pattern:/*Array*/Array;
  private var _colors:/*uint*/Array;
  
  public function changeFood():void
  {
    for (var i: int = 0; i < 25; i++) {
      var p:Position = new Position(0, 0);
      while (true)
      {
        p.row = Math.random() * height;
        p.column = Math.random() * width;
        if (at(p) == 0)
        {
          setAt(p, 1);
          break;
        }
      }
    }
  }
  
  /*
	private var walls: Vector.<Position>;
		walls = new Vector.<Position>();
		walls.push(new Position(0, 0));
  */
  
  public function Field(width:int, height:int,colors:/*uint*/Array)
  {
    _width = width;
    _height = height;
    _pattern = [];
    for (var r:int = 0; r < height; r++ )
    {
      _pattern[r] = [];
      for (var c:int = 0; c < width; c++ )
      {
        _pattern[r][c] = 0;
      }
    }
    _colors = colors;
  }
  public function at(position:Position):int
  {
    var fp:Position = toFieldPosition(position);
    return _pattern[fp.row][fp.column];
  }
  public function setAt(position:Position, value:int):int
  {
    var fp:Position = toFieldPosition(position);
    _pattern[fp.row][fp.column] = value;
    return value;
  }
  public function toFieldPosition(p:Position):Position
  {
    var row:int = p.row;
    var column:int = p.column;;
    var d:int = row % (height*2);
    if (d < 0)
    {
      d += height * 2;
    }
    if(d > height-1)
    {
      column += width / 2;
    }
    row %= height;
    if (row < 0)
    {
      row += height;
    }
    column %= width;
    if (column < 0)
    {
      column += width;
    }
    return new Position(row, column);
  }
  
  public function buildBitmapData():flash.display.BitmapData
  {
    return BitmapPatternBuilder.build(_pattern, _colors);
  }
}
class Snake
{
  private var _field:Field;
  private var head: Position;
  private var jumpFrames: int;
  
  public function get nextAngle():Angle { return _nextAngle; }
  public function set nextAngle(value:Angle):void 
  {
    _nextAngle = value;
  }
  private var _nextAngle:Angle;
  
  public function Snake(field:Field)
  {
    _field = field;
    head = new Position(0, 0);
    _nextAngle = null;
    jumpFrames = 0;
  }
  public function update():void
  {
    _field.setAt(head, 0);
    
    var next: Position = new Position(head.row, head.column);
    if (jumpFrames > 0) {
      next.row += 1;
    } else {
      jumpFrames--;
      next.row -= 1;
    }
    var atNext:int = _field.at(head);
    if (atNext != 0) {
      next = new Position(head.row, head.column);
      jumpFrames = 0;
    }
    
    next.column += _nextAngle.column;
    atNext = _field.at(head);
    if (atNext != 0) {
      head = next;
    }
    head = _field.toFieldPosition(head);
    _field.setAt(head, 2);
  }
  public function jump(): void {
    jumpFrames = 5;
  }
}
class Position
{
  public function get row():int { return _row; }
  public function set row(value:int):void { _row = value; }
  private var _row:int;
  public function get column():int { return _column; }
  public function set column(value:int):void { _column = value; }
  private var _column:int;
  public function Position(row:int, column:int)
  {
    this.row = row;
    this.column = column;
  }
  public function equals(other:Position):Boolean
  {
    return (this == other) || 
      (this.row == other.row && this.column == other.column);
  }
}
class Angle
{
  public static const LEFT:Angle = new Angle( 0, -1);
  public static const RIGHT:Angle = new Angle(0, 1);
  public static const UP:Angle = new Angle( -1, 0);
  public static const DOWN:Angle = new Angle(1, 0);
  
  public function get row():int { return _row; }
  private var _row:int;
  public function get column():int { return _column; }
  private var _column:int;
  public function Angle(row:int, column:int)
  {
    _row = row;
    _column = column;
  }
  public function add(p:Position):Position
  {
    return new Position(p.row + this.row, p.column + this.column);
  }
}
/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
  
class BitmapPatternBuilder{
  /**
   * creates BitmapData filled with dot pattern.
   * First parameter is 2d array that contains color index for each pixels;
   * Second parameter contains color reference table.
   *
   * @parameter pattern:Array 2d array that contains color index for each pixel.
   * @parameter colors:Array 1d array that contains color table.
   * @returns BitmapData
   */
  public static function build(pattern:Array, colors:Array):BitmapData{
    var bitmapW:int = pattern[0].length;
    var bitmapH:int = pattern.length;
    var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
    for(var yy:int=0; yy<bitmapH; yy++){
      for(var xx:int=0; xx<bitmapW; xx++){
        var color:int = colors[pattern[yy][xx]];
        bmd.setPixel32(xx, yy, color);
      }
    }
    return bmd;
  }
  
  /**
   * short cut function for Graphics.beginBitmapFill with pattern.
   */
  public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
    var bmd:BitmapData = build(pattern, colors);
    graphics.beginBitmapFill(bmd);
    bmd.dispose();    
  }
}