/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2iNz
 */

package
{    
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.net.*;
    
    [SWF(frameRate=60, width=640, height=1136)]
    public class Main extends Sprite
    {
        public function Main()
        {
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
            init();
        }
    
        public function init() :void
        {
            Buffer.initContext(stage);
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
import flash.net.*;

class Buffer
{
    public static var CANVAS :Stage;
    public static var CHILDREN :Array;
    
    public static function initContext($canvas:Stage) :void
    {
        CANVAS = $canvas;
        CHILDREN = [];
    }

    public static function initChildren() :void
    {
        for (var $:int=0; $<CHILDREN.length; $++)
            {CANVAS.addChild(CHILDREN[$])}
    }
}

class Background extends Sprite
{
    private var loader :Loader = new Loader();
    
    public function Background()
    {
        loader.load(new URLRequest('http://assets.wonderfl.net/images/related_images/4/42/428c/428c117934ede900d4a6e257212938e78adf18ae'),
                    new LoaderContext(true));
                     
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadedBackground);
    }
    
    public function loadedBackground($e:*) :void
    {
        var $bitmapData :BitmapData = new BitmapData(640, 1136);
        var $bitmap :Bitmap = new Bitmap($bitmapData);
        
        $bitmapData.draw(loader);
        addChild($bitmap);
    }
}

class Login extends Sprite
{
    public function Login()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
    }

    public function init() :void
    {
        graphics.clear();    
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 2, $y:Number = 1, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        init(); 
    }
        
    public function init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font, null, 0);
        setTextFormat(textFormat);
    }   
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; init() }
    public function set content($:String) :void
    { _content = $; init() }
}