/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2i8p
 */

// forked from kotobuki's Gainer Basic Example: External Button
// forked from kotobuki's Gainer Basic Example: Button
// din 0に接続したボタンを押す、離す、長押しすると画面上の
// 矩形が変化します。ボタンを押した間隔も左上に表示します。
// 
// 基本的なセットアップについては以下のURLを参照してください
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;
    import flash.utils.getTimer;
    import flash.text.*

    public class GainerBasic_Button extends Sprite {

        private var gio:Gainer;
        private var button:Button;

        private var squareButton:Sprite;

        private var lastPress:Number = 0;
        private var textField:TextField;

        public function GainerBasic_Button() {
            gio = new Gainer();

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            this.addChild(squareButton);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;

            textField = new TextField();
            addChild(textField);

            button = new Button(gio.digitalInput(0));

            button.addEventListener(ButtonEvent.PRESS, buttonPressed);
            button.addEventListener(ButtonEvent.RELEASE, buttonReleased);
            button.addEventListener(ButtonEvent.LONG_PRESS, buttonLongPressed);
        }

        private function buttonLongPressed(e:ButtonEvent):void {
            squareButton.scaleX = 2.0;
            squareButton.scaleY = 2.0;
        }

        private function buttonPressed(e:ButtonEvent):void {
            var now:Number = getTimer();
            squareButton.scaleX = 1.5;
            squareButton.scaleY = 1.5;
            textField.text = "Interval = " + (now - lastPress) + " ms";
            lastPress = now;
        }

        private function buttonReleased(e:ButtonEvent):void {
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
