/**
 * Copyright sw_lucchini ( http://wonderfl.net/user/sw_lucchini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2haB
 */

package 
{
	import flash.display.BitmapData;
	import flash.events.Event;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=60)]
	public class Main extends BasicView
	{
		public function Main()
		{
			//表示するテキスト
			var str:String = "ちょめちょめ";
			//表示するテキストの書体
			var font:String = "";
			//表示するテキストのサイズ
			var size:int = 200;
			//表示するテキストの色
			var fontColor:uint = 0x1A2630;
			//表示するテキストの背景色
			var bgColor:uint = 0x0068B4;
			var matList:Array = [];
			
			//strを一文字ずつBitmapDataに変換して配列で返してくれる
			var word:TextBitmapData = new TextBitmapData(str, font, size, fontColor);
			word.start();
			var len:int = word.data.length;
			
			for (var i:int = 0; i < len; i++) {
				var mat:CompositeMaterial = new CompositeMaterial();
				mat.addMaterial(new ColorMaterial(bgColor));
				mat.addMaterial(new BitmapMaterial(word.data[i], true));
				matList.push(mat);
			}
			
			var materials:MaterialsList = new MaterialsList({
				top: matList[0],
				bottom: matList[1],
				left: matList[2],
				right: matList[3],
				front: matList[4],
				back: matList[5]
			});
			
			var cube:Cube = new Cube(materials,300,300,300);
			scene.addChild(cube);
			
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, function():void
			{
				cube.rotationX += ( mouseX - stage.stageWidth / 2 ) / 200;
				cube.rotationY += ( mouseY - stage.stageHeight / 2 ) / 200;
			});
		}
	}
}

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class TextBitmapData extends Sprite
{
	private var _str:String;
	private var _format:TextFormat;
	private var _wordData:Array;
	
	public function TextBitmapData(str:String, font:String = "", size:int = 60, color:uint = 0x0)
	{
		_str = str;
		_format = new TextFormat(font, size, color);
		_wordData = [];
	}
	
	public function start():void
	{
		var len:int = _str.length;
		
		for (var i:int = 0; i < len; i++) {
			var tf:TextField = new TextField();
			tf.defaultTextFormat = _format;
			tf.text = _str.charAt(i);
			tf.autoSize = TextFieldAutoSize.LEFT;
			var bd:BitmapData = new BitmapData(tf.width, tf.height, true, 0xF);
			bd.draw(tf);
			_wordData.push(bd);
		}
	}
	
	public function get data():Array { return _wordData }
}