/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2h5R
 */

// forked from WLAD's Multiple Bounds Collins
/// @mxmlc  -o MultipleBounds.swf -swf-version 15 -publisher wad1m.com
package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	[SWF( width = "465", height = "465" )]
	public class MultipleBounds extends Sprite
	{
		public function MultipleBounds()
		{
			stage.align = "tl";
			stage.scaleMode = "noScale";
			var w:int = stage.stageWidth;
			var h:int = stage.stageHeight;
			stage.frameRate = 40;
			stage.color = 0xFEE285;
			graphics.beginFill( 0xFEE285 );
			graphics.drawRect(0, 0, w, h);
			
			var particle:Particle;
			var rect:Rectangle;
			var i:int;
			var j:int;
			
			var canvas:Shape = addChild( new Shape() ) as Shape;
			
			var particles:Vector.<Particle> = new Vector.<Particle>();
			
			j = 150;
			while ( --j >= 0 ) { 
				particle = new Particle( Math.random() * w, Math.random() * h );
				addChild( particle );
				particles.push( particle );
			}
			
			var rect1:Rectangle = new Rectangle( 20, 20, 250, 250 );
			var rect2:Rectangle = new Rectangle( w * 0.25, h * 0.25, w * 0.5, h * 0.5 );
			var rect3:Rectangle = new Rectangle( w * 0.7, h * 0.7, w * 0.1, h * 0.1 );
			var stageBounds:Rectangle = new Rectangle(0, 0, w, h);
			
			var rects:Vector.<Rectangle> = new <Rectangle>[ rect1, rect2, rect3 ];
			
			function bounceOff( particle:Particle, bounds:Rectangle ):void
			{
				if ( particle.x < bounds.x ) 
					particle.velocity.x = Math.abs( particle.velocity.x );
					
				if ( particle.x + particle.width > bounds.right ) 
					particle.velocity.x = -Math.abs( particle.velocity.x );
					
				if ( particle.y < bounds.y ) 
					particle.velocity.y = Math.abs( particle.velocity.y );
					
				if ( particle.y + particle.height > bounds.bottom ) 
					particle.velocity.y = -Math.abs( particle.velocity.y );
			}
			
			function randomBounds( index:int, s:int ):void
			{
				// move rect with mouse 
				rects[ index ].width = Math.random() * s*2 + s;
				rects[ index ].height = Math.random() * s*2 + s;
				rects[ index ].x = stage.mouseX - rects[ index ].width / 2;
				rects[ index ].y = stage.mouseY - rects[ index ].height / 2;
			};
			
			stage.addEventListener('rightMouseDown', function(_:*):void {randomBounds( 2, 40 );});
			stage.addEventListener('click', function(_:*):void {randomBounds( 0, 100 );});
			stage.addEventListener('enterFrame', function(_:*):void
			{
				//////////////////////// LOGIC ///////////////////////////
				
				for ( j = 0; j < particles.length; ++ j )
				{
					particle = particles[ j ];
					
					particle.time();
					
					particle.inSpace = false;
					
					for ( i = 0; i < rects.length; ++i )
					{
						if ( rects[ i ].containsRect( particle.area ) ) 
						{
							particle.inSpace = true;
							
							particle.space = i;
						}
					}
					
					if ( ! particle.inSpace && particle.space != -1 ) 
					{
						bounceOff( particle, rects[ particle.space ] );
					}
					
					else 
					{
						bounceOff( particle, stageBounds );
					}
				}
				
				//////////////////////// GRAPHICS ///////////////////////////
				
				canvas.graphics.clear();
				
				canvas.graphics.lineStyle( 3, 0x968034 );
				
				for ( i = 0; i < rects.length; ++i )
				{
					rect = rects[ i ];
					canvas.graphics.drawRect( rect.x, rect.y, rect.width, rect.height );
				}
			});
			
			
		}
		
	}
}
import flash.display.Shape;
import flash.geom.Point;
import flash.geom.Rectangle;

class Particle extends Shape
{
	public var inSpace:Boolean = false;
	
	public var space:int = -1;
	
	public var velocity:Point;
	
	public function get position():Point { return new Point( x, y ); }
	
	private var _area:Rectangle;
	public function get area():Rectangle 
	{ 
		_area.x = x;
		_area.y = y;
		return _area;
	}
	
	public function Particle( x:Number, y:Number )
	{
		velocity = new Point( Math.random() * 8-4, Math.random() * 8-4 );
		
		if ( Math.abs( velocity.x ) < 2 ) velocity.x += 2 * Math.abs( velocity.x ) / velocity.x ;
		if ( Math.abs( velocity.y ) < 2 ) velocity.y += 2 * Math.abs( velocity.y ) / velocity.y ;
		
		this.x = x;
		this.y = y;
		
		graphics.beginFill( 
			( ( 0xFF * Math.random() ) << 16 ) |
			( ( 0xFF * Math.random() ) << 8 ) |
			( 0xFF * Math.random() )
		);
		
		graphics.drawRect( 0, 0, 12, 12 );
		graphics.endFill();
		
		_area = new Rectangle(0, 0, 12, 12);
		
		cacheAsBitmap = true;
	}
	
	public function time():void
	{
		x += velocity.x;
		y += velocity.y;
	}
}