/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2gAG
 */

// forked from Akiyah's QuickBox2D でぽにょぽにょさせてみた
package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;

    public class FlashTest extends MovieClip {
        private const frequencyHz:Number = 3;
        private const distance:Number = 1;
        private const dotNum:int = 4 + 1;
        public function FlashTest() {
            var sim:QuickBox2D = new QuickBox2D(this, { debug:true });
            var center:Point = new Point(distance, distance);
            var dots:Array = [];
            var i:int;
            var j:int;
            var dot:QuickObject;
            for (j = 0; j < dotNum; j++) {
                var line:Array = [];
                dots.push(line);
                for (i = 0; i < dotNum; i++) {
                    dot = sim.addCircle({x:center.x + i*distance,
                                         y:center.y + j*distance,
                                         radius:distance/2 * Math.sqrt(2),
                                         groupIndex:-1});
                    line.push(dot);
                }
            }
            for (j = 0; j < dotNum; j++) {
                for (i = 1; i < dotNum; i++) {
                    sim.addJoint({a:dots[j][i-1].body, b:dots[j][i].body, frequencyHz:frequencyHz});
                    sim.addJoint({a:dots[i-1][j].body, b:dots[i][j].body, frequencyHz:frequencyHz});
                }
                for (i = 2; i < dotNum; i++) {
                    sim.addJoint({a:dots[j][i-2].body, b:dots[j][i].body, frequencyHz:frequencyHz});
                    sim.addJoint({a:dots[i-2][j].body, b:dots[i][j].body, frequencyHz:frequencyHz});
                }
            }

            for (j = 1; j < dotNum; j++) {
                for (i = 1; i < dotNum; i++) {
                    sim.addJoint({a:dots[j-1][i-1].body, b:dots[j][i].body, frequencyHz:frequencyHz});
                    sim.addJoint({a:dots[j-1][i].body, b:dots[j][i-1].body, frequencyHz:frequencyHz});
                }
            }
            for (j = 2; j < dotNum; j++) {
                for (i = 2; i < dotNum; i++) {
                    sim.addJoint({a:dots[j-2][i-2].body, b:dots[j][i].body, frequencyHz:frequencyHz});
                    sim.addJoint({a:dots[j-2][i].body, b:dots[j][i-2].body, frequencyHz:frequencyHz});
                }
            }

            sim.createStageWalls();
            sim.start();
            sim.mouseDrag();
        }
    }
}
