/**
 * Copyright TheCoolMuseum ( http://wonderfl.net/user/TheCoolMuseum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2g0A
 */

// forked from TheCoolMuseum's 画像のパターンディザ2値化(カラー)
// forked from TheCoolMuseum's 画像の誤差拡散2値化(カラー)
// forked from TheCoolMuseum's 画像の誤差拡散2値化
// forked from TheCoolMuseum's 画像のWAVファイル化 誤差拡散2値化付
// forked from TheCoolMuseum's forked from: 画像のWAVファイル化
// forked from TheCoolMuseum's 画像のWAVファイル化
// forked from TheCoolMuseum's ローカルファイルの読み込み・保存
// 画像を誤差拡散法で２値化します

package {
	import flash.utils.IDataInput;
	import flash.display.InterpolationMethod;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.ByteArray;
    import flash.utils.Endian;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.net.FileReference;
    import flash.net.FileFilter;
    
    public class FlashTest extends Sprite {
        private var fileLoader:FileReference;
        private var fileSaver:FileReference;
        private var imageLoader:Loader;
        private var image:Bitmap = new Bitmap();
        
        private var uIx:Array = [0,2,1,3,0,2,1,3,0,2,1,3,0,2,1,3];
        private var vIx:Array = [0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3];
        
        public function makeBtn(name:String):TextField{
           var btn:TextField = new TextField();
            btn.text = name;
            btn.autoSize = TextFieldAutoSize.LEFT;
            btn.background = true;
            btn.border = true;
            btn.selectable = false;
            return btn;
        } 
        public function FlashTest() {
        	    image.y=20;
        	    addChild(image);
            var loadBtn:TextField = makeBtn("LOAD");
            addChild(loadBtn);
            loadBtn.addEventListener(MouseEvent.CLICK, onClickLoadBtn);
            
        }
        private function onClickLoadBtn(e:Event):void{
            load();
        }
        private function load():void{
            var fileFilter:FileFilter = new FileFilter("Images (.png .jpg .gif)", "*.png;*.jpg;*.gif");

           	fileLoader = new FileReference();
        	fileLoader.addEventListener(Event.SELECT, onSelectLoadFile);
        	fileLoader.addEventListener(Event.COMPLETE, onCompleteLoadFile);
        	
        	fileLoader.browse([fileFilter]);
        }
        private function onSelectLoadFile(e:Event):void{
            fileLoader.load();
        }
        private function onCompleteLoadFile(e:Event):void{
            imageLoader = new Loader();
            imageLoader.loadBytes(fileLoader.data);
            imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteLoadImage);
        }
        private function onCompleteLoadImage(e:Event):void{
            var width:int = imageLoader.width;
            var height:int = imageLoader.height;
            var bitmapData:BitmapData = new BitmapData(width, height);
            bitmapData.draw(imageLoader);
            //addChild(new Bitmap(bitmapData));
            image.bitmapData = patternDither(bitmapData);
            
        }
        
        private var bayer:Array = [8,136,40,168,200,72,232,104,56,184,24,152,248,120,216,88];
        private function patternDither(img:BitmapData):BitmapData{
        		var width:int = img.width;
        		var height:int = img.height;
        		var array:ByteArray = img.getPixels(img.rect);
        		var l:int=array.length;
        		for(var y:int=0; y<height; y++){
        			var pos:int = y*width*4;
        			for(var x:int=0; x<width; x++){
        				var m:int = bayer[(y%4)*4 + (x%4)];
        				var c:int = (array[pos+1]+array[pos+1]+array[pos+1])/3;
                     c = c<m ? 0 : 255;


                     array[pos] = 0xff;
                     array[pos+1] = c;
                     array[pos+2] = c;
                     array[pos+3] = c;
                     pos+=4;
        			}
        		}
        		array.position=0;
            img.setPixels(img.rect, array);
        
        		return img;
        }
        private function clip8bit(n:int):int{
        		return Math.min(255,Math.max(0,n));
        }
    }
}