/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2fl9
 */

// forked from narutohyper's Create Mesh [Alternativa3D 7.5 TIPS]
// forked from narutohyper's Alternativa3D 7.5 Template
package
{
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.Vertex;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import flash.display.Sprite;
    import flash.events.Event;

    
    /**
     * Alternativa3D 7.6
     *
     * Meshを作成
     *
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="100", width="800", height="600")]
    public class Main extends Sprite
    {
        public function Main():void    {
        
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        
        private function init(e:Event=null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
        
            //AlternativaTemplate作成
            var scene:AlternativaTemplate = new AlternativaTemplate(this);

            
            //まとめてcontrolするために、core.Object3DContainerを作成し、各Objectを入れ子にする
            var animeObject:Object3DContainer = new Object3DContainer;
            scene.container.addChild(animeObject);
            
            
            //material作成

            var material:FillMaterial = new FillMaterial(0xCCCCFF,1,0,1);
            
            
            // Meshを作成
            
            var vertex:Vector.<Vertex> = new Vector.<Vertex>;
            var RADIAN:Number = Math.PI / 180;
            var sr:Number = -90;
            var pitch:Number = 120;
            var angle:Number;
            var i:uint;
            var length:Number=200;
            //三角形なPlaneを作成
            var meshTriangle:Mesh = new Mesh();
            for (i = 0; i < 3; i++) {
                angle=(sr+(pitch*i)) * RADIAN;
                vertex[i] = meshTriangle.addVertex(Math.cos(angle) * length, Math.sin(angle) * length, 0, 0, 0, 'v'+i);
            }
            meshTriangle.addTriFace(vertex[0], vertex[1], vertex[2], null, 'faceFront');
            meshTriangle.addTriFace(vertex[0], vertex[2], vertex[1], null, 'faceBack');
            meshTriangle.calculateNormals();
            meshTriangle.setMaterialToAllFaces(material);
            animeObject.addChild(meshTriangle);
            meshTriangle.x=-400;
            meshTriangle.y=-400;
            

            //四角形なPlaneを作成
            vertex = new Vector.<Vertex>;
            var meshSquare:Mesh = new Mesh();
            length=200*Math.sqrt(2);
            sr = -135;
            pitch = 90;
            for (i = 0; i < 4; i++) {
                angle=(sr+(pitch*i)) * RADIAN;
                vertex[i] = meshSquare.addVertex(Math.cos(angle) * length, Math.sin(angle) * length, 0, 0, 0, 'v'+i);
            }
            meshSquare.addQuadFace(vertex[0], vertex[1], vertex[2],vertex[3], null, 'faceFront');
            meshSquare.addQuadFace(vertex[0], vertex[3], vertex[2],vertex[1], null, 'faceBack');
            meshSquare.calculateNormals();
            meshSquare.setMaterialToAllFaces(material);
            animeObject.addChild(meshSquare);
            meshSquare.x = -400;
            meshSquare.y = 400;


            //多角形なPlaneを作成
            vertex = new Vector.<Vertex>;
            var meshHexagon:Mesh = new Mesh();
            sr = -90;
            pitch = 60;
            length=200;
            for (i = 0; i < 6; i++) {
                angle=(sr+(pitch*i)) * RADIAN;
                vertex[i] = meshHexagon.addVertex(Math.cos(angle) * 200, Math.sin(angle) * 200, 0, 0, 0, 'v'+i);
            }
            meshHexagon.addFace(vertex, null, 'faceFront');
            vertex.reverse();
            meshHexagon.addFace(vertex, null, 'faceBack');
            meshHexagon.calculateNormals();
            meshHexagon.setMaterialToAllFaces(material);
            animeObject.addChild(meshHexagon);
            meshHexagon.x = 400;
            meshHexagon.y = -400;


            //星型
            //凸凹型ポリゴンも、生成する
            vertex = new Vector.<Vertex>;
            var meshStar:Mesh = new Mesh();
            sr = -90;
            pitch = 36;
            for (i = 0; i < 10; i++) {
                if(i && i%2) {
                    length=200;
                } else {
                    length=100;
                }
                angle=(sr+(pitch*i)) * RADIAN;
                vertex[i] = meshStar.addVertex(Math.cos(angle) * length, Math.sin(angle) * length, 0, 0, 0, 'v'+i);
            }
            meshStar.addFace(vertex, null, 'faceFront');
            
            //凸状態から描画しないと生成できないので、反転後先頭のVertexを末尾持ってくる
            vertex.reverse();
            var v:Vertex = vertex.shift()
            vertex.push(v);
            meshStar.addFace(vertex, null, 'faceBack');
            meshStar.calculateNormals();
            meshStar.setMaterialToAllFaces(material);
            animeObject.addChild(meshStar);
            meshStar.x = 400;
            meshStar.y = 400;
            
            //円というか、36角形
            vertex = new Vector.<Vertex>;
            var meshCircle:Mesh = new Mesh();
            sr = -90;
            pitch = 10;
            for (i = 0; i < 36; i++) {
                length=200                
                angle=(sr+(pitch*i)) * RADIAN;
                vertex[i] = meshCircle.addVertex(Math.cos(angle) * length, Math.sin(angle) * length, 0, 0, 0, 'v'+i);
            }
            meshCircle.addFace(vertex, null, 'faceFront');
            
            vertex.reverse();
            v = vertex.shift()
            vertex.push(v);
            meshCircle.addFace(vertex, null, 'faceBack');
            meshCircle.calculateNormals();
            meshCircle.setMaterialToAllFaces(material);
            animeObject.addChild(meshCircle);
            meshCircle.x = 0;
            meshCircle.y = 0;
            
            //カメラの調整
            //カメラはControllerに関連付けている為、x,y,zで直接位置を指定できないので
            //SimpleController.setObjectPosXYZを使用
            scene.cameraController.setObjectPosXYZ(0, -1500, 500);
            scene.cameraController.lookAtXYZ(0, 0, 0);
            //ObjectControllerの作成
            //MouseDragで、Objectを回転させる為のController
            var objectController:SimpleObjectController = new SimpleObjectController(stage,animeObject,100);
            objectController.unbindAll();
            
            scene.onPreRender = function():void {
                objectController.update();
            }
            
            //描画開始
            scene.startRendering();
            
            

        }
        


    }
    
}



/**
 * BasicTemplate for Alternativa3D 7.5
 * Alternativa3D 7.5を扱いやすくするためのテンプレートです
 * @author narutohyper & clockmaker
 *
 */
import alternativ7.engine3d.containers.BSPContainer;
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.containers.DistanceSortContainer;
import alternativ7.engine3d.containers.KDContainer;
import alternativ7.engine3d.containers.LODContainer;
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.core.View;
import flash.display.DisplayObject;

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;

import flash.events.Event;

class AlternativaTemplate extends Sprite
{
    /**
     * 子オブジェクトを最適な方法でソートするコンテナ
     * (ConflictContainer)
     */
    public static const CONFLICT:String = 'conflict';
    /**
     * 子オブジェクトをBSP(バイナリ空間分割法)によってソートするコンテナ
     * (BSPContainer)
     */
    public static const BSP:String = 'bsp';
    
    /**
     * 子オブジェクトをカメラからのZ値でソートするコンテナ
     * (DistanceSortContainer)
     */
    public static const ZSORT:String = 'zsort';
    /**
     * KDツリー(http://ja.wikipedia.org/wiki/Kd%E6%9C%A8)によってソートするコンテナ
     * (KDContainer)
     */
    public static const KD:String = 'kd';
    /**
     * detalizationと子オブジェクトの距離でソートするコンテナ（詳細は調査中）
     * (LODContainer)
     */
    public static const LOD:String = 'lod';
    
    /**
     * 3dオブジェクト格納するコンテナインスタンス。
     */
    public var container:Object3DContainer;

    /**
     * ビューインスタンスです。
     */
    public var view:View;
    
    /**
     * カメラインスタンスです。
     */
    public var camera:Camera3D;
    
    /**
     * カメラコントローラーです。
     */
    public var cameraController:SimpleObjectController;
    
    private var _mc:DisplayObjectContainer;
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;
    private var _containerType:String;
    
    /**
     * 新しい Alternativa3DTemplate インスタンスを作成します。
     * @param    mc
     * @param    containerType
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function AlternativaTemplate(mc:DisplayObjectContainer,containerType:String=CONFLICT,viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true)
    {
        
        _mc = mc;
        _mc.addChild(this);

        _containerType = containerType;
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }


    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理をオーバーライドして記述します。
     */
    protected function atInit():void {}


    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    protected function atPreRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void
    {
        _onPreRender = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理をオーバーライドして記述します。
     */
    protected function atPostRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理を記述します。
     */
    private var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void
    {
        _onPostRender = value;
    }
    
    
    /**
     * レンダリングを開始します。
     */
    public function startRendering():void
    {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    /**
    * レンダリングを停止します。
    */
    public function stopRendering():void
    {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    /**
     * シングルレンダリング(レンダリングを一回だけ)を実行します。
     */
    public function singleRender():void
    {
        onRenderTick();
    }

    /**
     * @private
     */
    private function init(e:Event = null):void
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;
        
        //Root objectの作成
        if (_containerType == CONFLICT) {
            container = new ConflictContainer();
        } else if (_containerType == BSP) {
            container = new BSPContainer();
        } else if (_containerType == ZSORT) {
            container = new DistanceSortContainer();
        } else if (_containerType == KD) {
            container = new KDContainer();
        } else if (_containerType == LOD) {
            container = new LODContainer();
        }
        //Viewの作成
        view = new View(stage.stageWidth, stage.stageHeight);
        _mc.addChild(view);

        //cameraの作成
        camera = new Camera3D();
        camera.view = view;
        camera.x = 0;
        camera.y = -500;
        camera.z = 0;
        container.addChild(camera);
        
        // Camera controller
        cameraController = new SimpleObjectController(stage, camera, 10);
        cameraController.mouseSensitivity = 0;
        cameraController.unbindAll();
        cameraController.lookAtXYZ(0, 0, 0);
        
        onResize();
        stage.addEventListener(Event.RESIZE, onResize);
        
        atInit();
    }
    
    /**
     * @private
     */    
    private function onResize(e:Event = null):void 
    {
        if (_scaleToStage)
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        } 
        else
        {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }
    
    /**
     * @private
     */    
    private function onRenderTick(e:Event = null):void 
    {
        atPreRender();
        _onPreRender();
        cameraController.update();
        camera.render();
        atPostRender();
        _onPostRender();
    }
            
    
}

