/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2fcW
 */

// forked from shohei909's 線分の交差判定
// forked from shohei909's Area of a Triangle(三角形の面積)
package {
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import com.bit101.components.*;
    import flash.events.Event;
    import flash.display.*;
    public class FlashTest extends Sprite {
        public var dots:Array = [];
        public var r:Rectangle = new Rectangle( 10, 10, 445, 420 );
        public var canvas:Sprite = new Sprite();
        public var target:Object;
        
        public function FlashTest() {
            addChild( new Bitmap( new BitmapData(465,465,false,0x111111) ) )
            addChild( canvas );
            
            var dot:Dot = new Dot( 0xFF0000 );
            canvas.addChild( dot )
            dots.push( dot );
            for( var i:int = 0; i < 4; i++ ){
                dot = new Dot();
                dot.move( int( r.x + r.width* Math.random() ), int( r.y + r.height*Math.random() ) );
                dot.addEventListener( "mouseDown", start );
                dot.addEventListener( "mouseUp", stop );
                stage.addEventListener( "mouseMove", move );
                dot.buttonMode = true;
                canvas.addChild( dot );
                dots.push( dot );
            }
            update();
        }
        
        private function update():void{
            var g:Graphics = canvas.graphics;
            g.clear();
            g.lineStyle( 3, 0x66CC66, 1 );
            var d:Dot;
            for( var i:int = 1; i < 5; i ){
                d = dots[i++];
                g.moveTo( d.x, d.y );
                d = dots[i++];
                g.lineTo( d.x, d.y );
            }
            var p:Point = GeomUtil.intersection( 
                                            dots[1].x, dots[1].y,
                                            dots[2].x, dots[2].y,
                                            dots[3].x, dots[3].y,
                                            dots[4].x, dots[4].y );
            if(p) dots[0].move( p.x, p.y );
            if( GeomUtil.segmentHitTest(
                                            dots[1].x, dots[1].y,
                                            dots[2].x, dots[2].y,
                                            dots[3].x, dots[3].y,
                                            dots[4].x, dots[4].y ) ){ dots[0].alpha = 1 }
            else{ dots[0].alpha = 0.3 }
        }
        
        private function start(e:Event):void{ 
            target = e.target;        
        }
        private function move(e:Event):void{ 
            if( target ){
                target.move( mouseX, mouseY );
                update();
            }          
        }
        
        private function stop(e:Event):void{
            target = null;
        }
    }
}
import flash.text.AntiAliasType;

import flash.events.Event;
import flash.geom.Point;
import flash.display.Graphics;
import flash.display.Sprite;
import com.bit101.components.*;

class Dot extends Sprite{
    private var lbl:Label;
    function Dot( color:uint = 0x00FF00){
        var g:Graphics = graphics;
        g.beginFill( color, 1 );
        g.drawRect( -5, -5, 10, 10 );
        Style.LABEL_TEXT = 0xBB6666;
        lbl = new Label( this, 0, 0, "" )
        lbl.textField.antiAliasType = AntiAliasType.ADVANCED;
        move(x,y);
    }
    public function move(x:Number,y:Number):void{
        this.x = x; this.y = y; lbl.text = "(" + x.toFixed(1) + "," + y.toFixed(1) + ")";
    }
}

class GeomUtil{
    /** 三角形の面積 */
    static public function triangleSum( 
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number, 
                                            cx:Number, cy:Number ):Number{
        var s:Number = 0.5 * ((cy-ay)*(bx-ax)-(cx-ax)*(by-ay)) 
        return s>0?s:-s;
    }
    /** 線分の交差判定 */
    static public function segmentHitTest( 
                                            sx1:Number, sy1:Number,
                                            ex1:Number, ey1:Number, 
                                            sx2:Number, sy2:Number, 
                                            ex2:Number, ey2:Number ):Boolean{
        var cx:Number, cy:Number, dx:Number, dy:Number;
        var r:Number = ( cx = sx1 - ex1 ) * ( dy = sy2 - ey2 ) - ( cy = sy1 - ey1 ) * ( dx = sx2 - ex2 );
        if( r == 0 ){ return false; }
        var ax:Number = sx1 - sx2;
        var ay:Number = sy1 - sy2;
        var s:Number = (dy * ax - dx * ay ) / r
        var t:Number = (cy * ax - cx * ay ) / r
        if( 0 <= t && t < 1 && 0 <= s  && s < 1 ){ return true; }
        return false;
    }
    /** 二つの直線の交点 */
    static public function intersection( 
                                            sx1:Number, sy1:Number,
                                            ex1:Number, ey1:Number, 
                                            sx2:Number, sy2:Number, 
                                            ex2:Number, ey2:Number ):Point{
        var cx:Number, cy:Number, dx:Number, dy:Number;
        var r:Number = ( cx = sx1 - ex1 ) * ( dy = sy2 - ey2 ) - ( cy = sy1 - ey1 ) * ( dx = sx2 - ex2 );
        if( r == 0 ){ return null; }
        var ax:Number = sx1 - sx2;
        var ay:Number = sy1 - sy2;
        var s:Number = (dx * ay - dy * ax) / r;
        return new Point( sx1 + s * cx, sy1 + s * cy ) ;
    }
}