/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2fQd
 */

// forked from yuitest's forked from: ビックバンです
// forked from 3f5's ビックバンです
package {
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    [SWF(frameRate="60", width="465", height="465")]
    public class Test extends Sprite {
        public var list:Vector.<Blood> = new Vector.<Blood>();
        public var bitmap:BitmapData;
        public var rect:Rectangle = new Rectangle();
        public var debug:TextField = new TextField;
        public function Test() {
            bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function (event:MouseEvent):void {
                var x:int = stage.mouseX;
                var y:int = stage.mouseY;
                for (var i:int = 0; i < 100; i++) {
                    list.push(new Blood(x, y, 10,0, list));
                }
            });
            addChild(new Bitmap(bitmap));
            addChild(debug);
            //addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, update);
        }
        public function update(event:Event):void {
            var blood:Blood, length:int = list.length, i:int, height:int = stage.stageHeight;
            bitmap.lock();
            bitmap.fillRect(bitmap.rect, 0xffffff);
            for (i = 0; i < length; i++) {
                blood = list[i];
                blood.update();
                if (blood.ended || blood.y > height) {
                    list.splice(i, 1);
                    blood = null;
                    length--;
                    continue;
                }
                rect.x = blood.x;
                rect.y = blood.y;
                rect.width = blood.size;
                rect.height = blood.size;
                bitmap.fillRect(rect, 0xFF0000);

            }
            bitmap.unlock();
            //debug.text = String(length) + ' particles';
        }
    }
}

class Blood
{
    public var aY:Number;
    public var aX:Number;
    public var size:Number;
    public var ended:Boolean;
    public var gravity:Number;
    public var list:Vector.<Blood>;
    public var x:Number;
    public var y:Number;
    public function Blood(_x:Number, _y:Number, _size:Number,g:Number, l:Vector.<Blood>) {
        x = _x;
        y = _y;
        ended = false;
        size = _size;
        gravity = g;
        aX = rand(rand(-5, 0), rand(0, 5));
        aY = rand(rand(-5, 0), rand(0, 5));
        list = l;
    }
    private function rand(min:Number, max:Number):Number {
        return Math.floor(Math.random() * (max - min + 1) + min);
    }
    public function makeChild (num:int):void {
        for (var i:int = 0; i < 5; i++) {
            list.push(new Blood(x, y, num,gravity,list));
        }
    }
    public function update():void {
        if (rand(1,15) === 1 && !ended && size > 1) {
            ended = true;
            makeChild(size - 3);
        }
        if (!ended && size > 0) {
            aX *= 0.99;
            gravity += 0.002;
            aY = aY * 0.99 + gravity;
            x += aX;
            y += aY; 
        }
    }
}
    
