/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2f9V
 */

//うさんくさい感じのFacebook投稿機能
//
//自分のサイトを経由してFacebookにメッセージを投稿する機能を作成してみました
//遷移先の自分のサイトに置いてあるJavascriptが呼び出されてFacebookに投稿されます
//このソースからサイトに送られるURLパラメータをFacebookに投稿します
//メッセージが同じだと一度しか投稿できない？？？
//
//Javascript作成に以下のサイトを参考にさせていただきました
//JavaScriptでお手軽にFacebookのアプリを作る
//http://d.hatena.ne.jp/kagigotonet/20110124/1295839650
//Facebook API Graph:自動的に投稿する。
//http://blog.livedoor.jp/mogiken1/archives/cat_130700.html?p=2#
//GET送信によるパラメータの受け渡し
//http://phpjavascriptroom.com/?t=js&p=location4
//
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.utils.escapeMultiByte;
    public class ButtonTest extends Sprite {
        
        private var button : SimpleButton;//ボタン 
        private var label : TextField;    //ラベル
        
        public function ButtonTest() {
            label = new TextField;
            label.text = "Facebook Update";
            addChild(label);
            
            button = new CustomButton("FBUpdate");
            button.y = 20;

            button.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            button.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            addChild(button);
        }
   
        //マウスダウンイベントの処理
        private function onMouseDown(evt:MouseEvent):void {
            label.text = "FBUpdate!!!";
            var searchParam01:String = "test test test";
            var searchParam02:String = "test test test";
            navigateToURL(new URLRequest("http://oretaikan.atukan.com/Platform/Facebook/FacebookAPIPractice.html?TestData01=" + escapeMultiByte(searchParam01) + "TestData02=" + escapeMultiByte(searchParam02)), "_blank");
        }

        //マウスアップイベントの処理
        private function onMouseUp(evt:MouseEvent):void {
            label.text = "Facebook Update";
        }        
    }
}

import flash.display.*;
import flash.system.*;
import flash.text.*;

//カスタムボタン
class CustomButton extends SimpleButton { 
        //コンストラクタ    
        public function CustomButton(label:String="") {
            //状態
            upState = makeSprite(label,0x00FFFF);
            overState = upState;
            downState = makeSprite(label,0x00FF00);
            hitTestState = upState;
        }

        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;

            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);

            return sp;
        }    
}
