/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2epI
 */

/* ------------------------------------------------------------------------------------------------
 * [階段シリーズ]
 * http://wonderfl.net/c/zQW4 hiyoko vs. unko (HVU)
 * http://wonderfl.net/c/2epI A
 * http://wonderfl.net/c/z1Fp Penrose Stairs Complex
 * http://wonderfl.net/c/lVRx Penrose Stairs Fractal
 * http://wonderfl.net/c/atBv Complementary Penrose Stairs Fractal
 * ------------------------------------------------------------------------------------------------
 */
package {
    import com.bit101.components.InputText;
    import com.bit101.components.NumericStepper;
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    
    [SWF(width="465",height="465",frameRate="30", backgroundColor="0x000000")]
    public class Main extends Sprite {
        private var _isoContainer:Sprite;
        private var _pixelContainer:Sprite;
        
        private var _boxes:Vector.<IsoBox>;
        private var _pixels:Vector.<Pixel>;
        
        private var _step:int;
        private var _riser:Number;
        
        private var _stepLabel:TextField;
        private var _rizerLabel:TextField;
        private var _diagonalDist:NumericStepper;
        private var _perimeter:NumericStepper;
        
        private var _IOArea:InputText;
        
        private static const BOX_SIZE:int = 24;
        private static const PIXEL_SIZE:int = 32;
        private static const PIXEl_COLS:int = 5;
        private static const PIXEL_ROWS:int = 7;
        private static const NUM_PIXELS:int = PIXEl_COLS * PIXEL_ROWS;
        
        private static const DEFAULT_DATA:String = "[1,0,0,0,0,2,0,0,0,0,3,0,0,10,0,4,0,0,9,0,5,6,7,8,0,6,0,0,7,0,7,0,0,6,0,2,10]";
        
        public function Main() {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            addChild(_isoContainer = new Sprite());
            _isoContainer.x = 170;
            _isoContainer.y = 650;
            
            addChild(_pixelContainer = new Sprite());
            _pixelContainer.x = 300;
            _pixelContainer.y = 215;
            _pixelContainer.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            
            _boxes = new Vector.<IsoBox>(NUM_PIXELS, true);
            _pixels = new Vector.<Pixel>(NUM_PIXELS, true);
            for (var i:int = 0; i < NUM_PIXELS; i++) {
                var box:IsoBox = new IsoBox(BOX_SIZE, 500);
                box.wx = (i % PIXEl_COLS) * BOX_SIZE;
                box.wz = -int(i / PIXEl_COLS) * BOX_SIZE;
                box.visible = false;
                _isoContainer.addChild(box);
                _boxes[i] = box;
                
                var pixel:Pixel = new Pixel(i, PIXEL_SIZE);
                pixel.x = (i % PIXEl_COLS) * PIXEL_SIZE;
                pixel.y = int(i / PIXEl_COLS) * PIXEL_SIZE;
                _pixelContainer.addChild(pixel);
                _pixels[i] = pixel;
            }
            
            _step = _riser = 0;
            
            var builder:TextBuilder = new TextBuilder().fontColor(0xFFFFFF);
            addChild(builder.pos(300, 20).build("step :"));
            addChild(_stepLabel = builder.pos(40, 0, true).build(String(_step)));
            addChild(builder.pos(380, 20).build("(W,S or ↑,↓)"));
            addChild(builder.pos(300, 40).build("riser :"));
            addChild(_rizerLabel = builder.pos(40, 0, true).build(String(_riser)));
            addChild(builder.pos(300, 80).build("diagonalDist :"));
            _diagonalDist = new NumericStepper(this, 370, 80);
            _diagonalDist.minimum = 1;
            addChild(builder.pos(300, 100).build("perimeter :"));
            _perimeter = new NumericStepper(this, 370, 100);
            _perimeter.minimum = 2;
            new PushButton(this, 350, 120, "calculate riser", calculate);
            calculate(null);
            
            _IOArea = new InputText(this, 5, 445, DEFAULT_DATA);
            _IOArea.width = 455;
            new PushButton(this, 5, 420, "import", importData);
            new PushButton(this, 110, 420, "export", exportData);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            importData(null);
        }
        
        private function mouseDownHandler(event:MouseEvent):void {
            var pixel:Pixel = event.target as Pixel;
            setPixel(pixel, _step, !pixel.visible);
        }
        
        private function setPixel(pixel:Pixel, step:int, visible:Boolean):void {
            pixel.visible = visible;
            pixel.step = step;
            var box:IsoBox = _boxes[pixel.index];
            box.visible = visible;
            box.height = 500 + pixel.step * _riser * BOX_SIZE;
        }
        
        private function calculate(event:MouseEvent):void {
            _riser = _diagonalDist.value / _perimeter.value;
            _rizerLabel.text = String(_riser);
            for (var i:int = 0; i < NUM_PIXELS; i++) {
                _boxes[i].height = 500 + _pixels[i].step * _riser * BOX_SIZE;
            }
        }
        
        private function importData(event:MouseEvent):void {
            var data:Array = _IOArea.text.replace(/\[|\]/g, "").split(/\D/);
            
            _diagonalDist.value = data[NUM_PIXELS];
            _perimeter.value = data[NUM_PIXELS + 1];
            calculate(null);
            
            for (var i:int = 0; i < NUM_PIXELS; i++) {
                if (data[i] == 0) {
                    setPixel(_pixels[i], 0, false);
                }else {
                    setPixel(_pixels[i], data[i], true);
                }
            }
        }
        
        private function exportData(event:MouseEvent):void {
            var i:int, pixel:Pixel;
            var data:Array = [];
            
            var minStep:int = int.MAX_VALUE;
            for (i = 0; i < NUM_PIXELS; i++) {
                pixel = _pixels[i];
                if (pixel.visible && (minStep > pixel.step)) {
                    minStep = pixel.step;
                }
            }
            for (i = 0; i < NUM_PIXELS; i++) {
                pixel = _pixels[i];
                if (pixel.visible) {
                    data[i] = pixel.step - minStep + 1;
                }else {
                    data[i] = 0;
                }
            }
            data[NUM_PIXELS] = _diagonalDist.value;
            data[NUM_PIXELS + 1] = _perimeter.value;
            
            _IOArea.text = "[" + data + "]";
        }
        
        private function keyDownHandler(event:KeyboardEvent):void {
            switch(event.keyCode) {
                case 38:
                case 87:
                {
                    _step++;
                    break;
                }
                case 40:
                case 83:
                {
                    _step--;
                    break;
                }
            }
            _stepLabel.text = String(_step);
        }
    }
}
/* ------------------------------------------------------------------------------------------------
 * Pixel
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.display.Sprite;
    import flash.filters.GlowFilter;
    import flash.text.TextField;
    
    //public 
    class Pixel extends Sprite {
        private var _index:int;
        private var _size:int;
        private var _step:int;
        private var _stepLabel:TextField;
        private var _visible:Boolean;
        
        public function Pixel(index:int, size:int) {
            _index = index;
            _size = size;
            _step = 0;
            _stepLabel = new TextBuilder().align(TextBuilder.CENTER).autoSize()
                .filters([new GlowFilter(0x000000, 1, 2, 2, 2)]).fontColor(0xFFFFFF).fontSize(_size / 2)
                .pos(0, 0).size(_size, _size).build(String(_step));
            addChild(_stepLabel);
            this.visible = false;
            buttonMode = true;
        }
        
        public function get index():int { return _index; }
        public function get size():int { return _size; }
        
        public function get step():int { return _step; }
        public function set step(value:int):void {
            _step = value;
            _stepLabel.text = String(_step);
        }
        
        override public function get visible():Boolean { return _visible; }
        override public function set visible(value:Boolean):void {
            _visible = value;
            
            graphics.clear();
            graphics.lineStyle(0, 0x808080);
            graphics.beginFill((_visible) ? 0xFFFFFF : 0x000000);
            graphics.drawRect(0, 0, _size, _size);
            graphics.endFill();
        }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * IsoObject
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    
    //public 
    class IsoObject extends Sprite {
        private var _world:Vector3D;
        private var _screen:Point;
        
        public function IsoObject() {
            _world = new Vector3D(0, 0, 0);
            _screen = new Point(0, 0);
        }
        
        public function update():void {
            x = _screen.x;
            y = _screen.y;
        }
        
        public function get wx():Number { return _world.x; }
        public function set wx(value:Number):void { _world.x = value; IsoUtils.isoToScreen(_world, _screen); update(); }
        public function get wy():Number { return _world.y; }
        public function set wy(value:Number):void { _world.y = value; IsoUtils.isoToScreen(_world, _screen); update(); }
        public function get wz():Number { return _world.z; }
        public function set wz(value:Number):void { _world.z = value; IsoUtils.isoToScreen(_world, _screen); update(); }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * IsoBox
 * ------------------------------------------------------------------------------------------------
 */
//package {
    
    //public 
    class IsoBox extends IsoObject {
        private var _size:Number;
        private var _height:Number;
        
        public function IsoBox(size:Number, height:Number) {
            super();
            _size = size;
            _height = height;
            draw();
        }
        
        private function draw():void {
            var halfSize:Number = _size / 2;
            graphics.clear();
            graphics.moveTo(0, halfSize - _height);
            
            drawTopFace();
            drawLeftFace();
            drawRightFace();
            
            function drawTopFace():void {
                graphics.lineStyle(0, 0xC0C0C0);
                graphics.beginFill(0xFFFFFF);
                graphics.lineTo( -_size, -_height);
                graphics.lineTo(0, -halfSize - _height);
                graphics.lineTo(_size, -_height);
                graphics.lineTo(0, halfSize - _height);
                graphics.endFill();
            }
            
            function drawLeftFace():void {
                graphics.lineStyle();
                graphics.beginFill(0xC0C0C0);
                graphics.lineTo(0, halfSize);
                graphics.lineTo( -_size, 0);
                graphics.lineTo( -_size, -_height);
                graphics.lineTo(0, halfSize - _height);
                graphics.endFill();
            }
            
            function drawRightFace():void {
                graphics.lineStyle();
                graphics.beginFill(0x808080);
                graphics.lineTo(0, halfSize);
                graphics.lineTo(_size, 0);
                graphics.lineTo(_size, -_height);
                graphics.lineTo(0, halfSize - _height);
                graphics.endFill();
            }
        }
        
        override public function get height():Number { return _height; }
        override public function set height(value:Number):void { _height = value; draw(); }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * IsoUtils
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.geom.Point;
    import flash.geom.Vector3D;
    
    //public 
    class IsoUtils {
        public static const TRUE_SCALE:Number = Math.cos( -30 * Math.PI / 180) * Math.SQRT2;
        
        public static function isoToScreen(iso:Vector3D, out:Point = null):Point {
            out ||= new Point(0, 0);
            out.x = iso.x + iso.z;
            out.y = (iso.x - iso.z) / 2 + iso.y;
            return out;
        }
        
        public static function screenToIso(screen:Point, out:Vector3D = null):Vector3D {
            out ||= new Vector3D(0, 0, 0);
            out.x = (screen.x / 2 + screen.y) - out.y;
            out.z = (screen.x / 2 - screen.y) + out.y;
            return out;
        }
        
        public static function compareDepth(a:Vector3D, b:Vector3D):Number {
            return (a.x - a.y - a.z) - (b.x - b.y - b.z);
        }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * TextBuilder
 * ------------------------------------------------------------------------------------------------
 */
//package  {
    import flash.geom.Point;
    import flash.text.AntiAliasType;
    import flash.text.GridFitType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    /** 複雑な設定の flash.text.TextField クラスの生成を単純化します。 */
    //public 
    class TextBuilder {
        public static const LEFT:String = "left";
        public static const RIGHT:String = "right";
        public static const CENTER:String = "center";
        
        private var _align:String;
        private var _autoSize:Boolean;
        private var _bold:Boolean;
        private var _filters:Array;
        private var _fontName:String;
        private var _sharpness:Number;
        private var _thickness:Number;
        private var _fontColor:uint;
        private var _fontSize:int;
        private var _position:Point;
        private var _size:Point;
        
        public function TextBuilder() {
            _align = TextBuilder.LEFT;
            _autoSize = _bold = false;
            _filters = [];
            _fontName = null;
            _sharpness = _thickness = 0;
            _fontColor = 0x000000;
            _fontSize = 12;
            _position = new Point(0, 0);
            _size = new Point(100, 100);
        }
        
        public function align(value:String):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSize = enabled;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function filters(value:Array):TextBuilder {
            _filters = value;
            return this;
        }
        
        public function font(name:String, sharpness:Number = 0, thickness:Number = 0):TextBuilder {
            _fontName = name;
            _sharpness = sharpness;
            _thickness = thickness;
            return this;
        }
        
        public function fontColor(value:uint):TextBuilder {
            _fontColor = value;
            return this;
        }
        
        public function fontSize(value:int):TextBuilder {
            _fontSize = value;
            return this;
        }
        
        public function pos(x:Number, y:Number, relative:Boolean = false):TextBuilder {
            _position.x = ((relative) ? _position.x : 0) + x;
            _position.y = ((relative) ? _position.y : 0) + y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _size.x = width;
            _size.y = height;
            return this;
        }
        
        public function build(text:String):TextField {
            var tf:TextField = new TextField();
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_fontName) {
                tf.embedFonts = true;
                tf.antiAliasType = AntiAliasType.ADVANCED;
                tf.gridFitType = (_align == TextBuilder.LEFT) ? GridFitType.PIXEL : GridFitType.SUBPIXEL;
                tf.sharpness = _sharpness;
                tf.thickness = _thickness;
            }
            
            tf.x = _position.x;
            tf.width = _size.x;
            tf.height = _size.y;
            if (_autoSize) {
                switch(_align) {
                    case TextBuilder.LEFT: { tf.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.RIGHT: { tf.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.CENTER: { tf.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            tf.defaultTextFormat = format;
            tf.text = text;
            tf.y = _position.y + ((_autoSize) ? Math.max(0, int((_size.y - (tf.textHeight + 4)) / 2)) : 0);
            tf.filters = _filters.concat();
            tf.mouseEnabled = tf.selectable = false;
            
            return tf;
        }
        
        public function clone():TextBuilder {
            return new TextBuilder().align(_align).autoSize(_autoSize).bold(_bold).filters(_filters)
            .font(_fontName, _sharpness, _thickness).fontColor(_fontColor).fontSize(_fontSize)
            .pos(_position.x, _position.y).size(_size.x, _size.y);
        }
    }
//}