/**
 * Copyright mezumona ( http://wonderfl.net/user/mezumona )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2eBg
 */

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.text.*;
    import flash.ui.Keyboard;

    public class ShiftKeyTester extends Sprite {
        public function ShiftKeyTester()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            var tf:TextField = new TextField();
            tf.width = stage.stageWidth;
            tf.height = stage.stageHeight;
            addChild(tf);
            _tf = tf;

            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyHandler);
            stage.addEventListener(KeyboardEvent.KEY_UP, keyHandler);
            stage.addEventListener(Event.RESIZE, function (event:Event):void
            {
                tf.width = stage.width;
                tf.height = stage.height;
            });

        }

        private var _tf:TextField;
        private function keyHandler(event:KeyboardEvent):void
        {
            if (event.keyCode == Keyboard.SHIFT) {
                _tf.appendText(event.type + ": shiftKey = " + event.shiftKey);
                if (event.type == KeyboardEvent.KEY_DOWN ? !event.shiftKey : event.shiftKey) {
                    _tf.appendText("!!");
                }
                _tf.appendText("\n");
                _tf.scrollV = _tf.maxScrollV;
            }

        }

    }
}