/**
 * Copyright k2syndrome_g ( http://wonderfl.net/user/k2syndrome_g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2cvM
 */

package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import org.si.sion.SiONDriver;
    import org.si.sound.DrumMachine;
    import org.si.sion.utils.SiONPresetVoice;
    import org.si.sion.SiONVoice;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sion.effector.*;
    import org.si.sion.sequencer.SiMMLTrack;
    [SWF(backgroundColor=0x000000)]
    public class FlashTest extends Sprite {
        private var _matrix:Array;
        private var _beatPointer:Shape;
        private var _notes:Array;
        private var _beatCount:int;
        private var _sionDriver:SiONDriver;
        private var _drumMachine:DrumMachine;
        private var _epianoVoice:SiONVoice;
        public function FlashTest() {
            var ix:int;
            var iy:int;
            var matrixButton:MatrixButton;
            //
            _matrix=new Array();
            for(iy=0;iy<8;iy++){
                _matrix[iy]=new Array();
                for(ix=0;ix<16;ix++){
                    matrixButton=new MatrixButton();
                    matrixButton.x=ix*24+40;
                    matrixButton.y=iy*24+100;
                    addChild(matrixButton);
                    _matrix[iy].push(matrixButton);
                }
            }
            _beatPointer=new Shape();
            with(_beatPointer){
                with(graphics){
                    beginFill(0xFF000000);
                    drawRect(0,0,24,24*8);
                    endFill();
                }
                alpha=0.8;
                x=40;
                y=100;
            }
            addChild(_beatPointer);
            _notes=new Array(70,67,65,60,58,55,53,48);
            _sionDriver=new SiONDriver(2048);
            _drumMachine=new DrumMachine(2,5,5);
            var presetVoice:SiONPresetVoice=new SiONPresetVoice();
            _epianoVoice=presetVoice["valsound.piano11"];
            //
            _sionDriver.setBeatCallbackInterval(1);
            _sionDriver.addEventListener(SiONTrackEvent.BEAT,_onBeat);
            _sionDriver.setTimerInterruption(1,_onTimerInterruption);
            _sionDriver.bpm=132;
            _beatCount=0;
            _sionDriver.effector.initialize();
            _sionDriver.effector.slot1=[new SiEffectStereoChorus(),new SiEffectStereoDelay()];
            //
            _sionDriver.play(null,false);
            _drumMachine.play();
        }
        private function _onBeat(event:SiONTrackEvent):void{
            _beatPointer.x=(event.eventTriggerID&15)*24+40;
        }
        private function _onTimerInterruption():void{
            var i:int;
            var track:SiMMLTrack;
            var beatIndex:int=_beatCount&15;
            for(i=0;i<8;i++){
                if(_matrix[i][beatIndex].selected){
                    track=_sionDriver.noteOn(_notes[i],_epianoVoice,1);
                    track.effectSend1=128;
                }
            }
            _beatCount++;
        }
    }
}
import flash.events.MouseEvent;
import flash.display.Shape;
import flash.display.SimpleButton;

class MatrixButton extends SimpleButton{
    private var _lightOn:Shape;
    private var _lightOff:Shape;
    private var _selected:Boolean;
    public function get selected():Boolean{
        return _selected;
    }
    public function MatrixButton(){
        _lightOff=_drawRect(0x303050,0x202040);
        _lightOn=_drawRect(0x303050,0x6060a0);
        upState=_lightOff;
        overState=_drawRect(0xffffff,0x6060a0);
        hitTestState=_lightOff;
        _selected=false;
        addEventListener(MouseEvent.CLICK,_onButtonClick);
    }
    private function _onButtonClick(mouseEvent:MouseEvent):void{
        _selected=!_selected;
        if(_selected){
            upState=_lightOn;
        }else{
            upState=_lightOff;
        }
    }
    private function _drawRect(border:uint,face:uint):Shape{
        var shape:Shape=new Shape();
        shape.graphics.lineStyle(1,border);
        shape.graphics.beginFill(face);
        shape.graphics.drawRect(1,1,22,22);
        shape.graphics.endFill();
        return shape;
    }
}