/**
 * Copyright heart_thai ( http://wonderfl.net/user/heart_thai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2bxy
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    
    public class FlashTest extends Sprite {
    	
    		private var cam:BlackWhiteCamera;
    		
    		private var layers:Vector.<LayerLevel>;
    		private var i:String;
    		
    		private var colors:Array = [ 0xFFFFFFFF , 0xFFCCCCCC , 0xFF999999, 0xFF555555 , 0xFF333333  ];
    		
        public function FlashTest() {
        		Wonderfl.capture_delay(10); 
        	
            // write as3 code here..
            cam = new BlackWhiteCamera;
            addChild(cam);
            cam.scaleX = cam.scaleY = 0.3;
            
            layers = new Vector.<LayerLevel>();
            
            for(var n:String in colors){
           	 	var layer:LayerLevel = new LayerLevel(cam.bmd, colors[n] );
            		addChild(layer);
           	 	layer.y = 200+(-20*Number(n));
           	 	layer.x = 100;
           	 	
           	 	layer.z = -10*Number(n);
           	 	layer.rotationX = -70;
           	 	
           	 	layers.push(layer); 
            }
            
            cam.addEventListener(Event.CHANGE , update );
        }
        
        
        private function update(e:Event):void{
        		for(i in layers){
        			layers[i].update();
        			layers[i].rotationX = mouseY;
        			layers[i].rotationY = mouseX;
        		}
        }
        
        
       
    }
}







//==============================================================
//==================Black And White Camera======================
//==============================================================
import flash.media.Camera;
import flash.media.Video;
import flash.display.Sprite;
import flash.filters.ColorMatrixFilter;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.geom.Point;
class BlackWhiteCamera extends Sprite{
	private const GRAY_SCALE:ColorMatrixFilter = new ColorMatrixFilter([
			0.3, 0.59, 0.11, 0, 0,
			0.3, 0.59, 0.11, 0, 0,
			0.3, 0.59, 0.11, 0, 0,
			0, 0, 0, 1, 0
		]);
	private const POINT:Point = new Point;
	private var bmp:Bitmap;
	public var bmd:BitmapData;
	private var vid:Video;
	public function BlackWhiteCamera(){
		vid = new Video;
		vid.attachCamera(Camera.getCamera());
		bmd = new BitmapData(vid.width,vid.height);
		bmp = new Bitmap(bmd);
		addChild(bmp);
		this.addEventListener(Event.ENTER_FRAME , update );
	}
	private function update(e:Event):void{
		bmd.draw(vid); 
		bmd.applyFilter(bmd,bmd.rect,POINT,GRAY_SCALE);
		dispatchEvent(new Event(Event.CHANGE));
		//bmd.threshold(bmd , bmd.rect , POINT , "<" , 0xFF333333 , 0xFF000000 ,0xFFFFFFFF ); 
		//bmd.threshold(bmd , bmd.rect , POINT , "<" , 0xFF555555 , 0xFF555555 ,0xFFFFFFFF ); 
	}
}
//==============================================================
//==============================================================


//==============================================================
//==================Black And White Camera======================
//==============================================================
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Point;

class LayerLevel extends Bitmap{
	
	private var src:BitmapData;
	public var bmp:BitmapData;
	private var color:uint;
	
	private const POINT:Point = new Point;
	
	public function LayerLevel( source:BitmapData  , colorSelect:uint ){
		bmp = source.clone();
		super(bmp);
		
		src = source;
		color = colorSelect;
	}
	
	public function update():void{
		bmp.draw(src);
		bmp.threshold(bmp , bmp.rect , POINT , "<=" , color , color ); 
		bmp.threshold(bmp , bmp.rect , POINT , ">" , color , 0x000000 ); 
	}
}
//==============================================================
//==============================================================






