/**
 * Copyright YAZUMA ( http://wonderfl.net/user/YAZUMA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2bck
 */

//http://www40.atwiki.jp/spellbound/pages/97.html
//Fuel 入力　→　ボタンではなくエンターキーにも反応するように
package {
    import flash.ui.Mouse;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
 　 import fl.controls.*;
    import flash.utils.Timer;
    import mx.collections.ArrayCollection;
    import com.bit101.components.Window;
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    import com.bit101.components.Meter;
 
    [SWF(backgroundColor=0xBEBEBE,width=500,height=500,frameRate=60)]
    
    public class sp extends Sprite {
        public var location:Number = 30;    //月までの現在位置　km
        public var Location:Array = [location];
        public var Location2:Array = [location];
        public var speed:Number = 1;    //現在速度　km/s
        public var weight:Number = 500;    //重さ　kg
        public var fuel:Number = 300;        //燃料　kg
        public var using_fuel:Number = 0;
        public var Newton:Number = 9.8;    //地球の重力
        public var MoonN:Number = Newton / 6; //月の重力
        public var Power:Number = 30 * Newton;
        public var s1:Sprite = new Sprite;
        public var s2:Sprite = new Sprite;
        public var s3:Sprite = new Sprite;
        public var timer:Timer = new Timer(50, 100);
        private var input:InputText;
        private var window:Window = new Window(null, 250, 300, "Fuel Input for next 1second.");
        private var meter:Meter = new Meter(null, 10, 390, "Speed (km/s)");
        private var fuel_meter:Meter = new Meter(null, 10, 280, "Fuel Meter (kg)");
        private var line:LineChart = new LineChart(460, 250, Location, 0xf0F0F5);
        private var line2:LineChart = new LineChart(300, 200, Location2, 0x222222);
        private var line_appear_check:Boolean = false;
        private var tf2:TextField = new TextField;        
        private var test_tf:TextField = new TextField();
        
        public function sp():void{
           initition();
        }
        private function initition():void{
            window.width = 200;
            window.height = 150;
            window.color = 0xADFF2F;
            
            var tf1:TextField = new TextField();
            tf1.width = 180;
            tf1.x = 15;
            tf1.y = 5;
            tf1.text = " 噴射する燃料を入力してください";
            tf1.textColor = 0xCC0000;
            
            tf2.x = 30;
            tf2.y = 25;
            tf2.width = 150;
            tf2.text = fuel + " kgまで使用可能です";
            
            window.content.addChild(tf1);
            window.content.addChild(tf2);
            input = new InputText(window.content, 50, 55, "0");
            input.addEventListener(MouseEvent.CLICK, click);
            var button:PushButton = new PushButton(window.content, 50, 90, "OK");
            button.addEventListener(MouseEvent.CLICK, clickButton);
            input.restrict = "0-9-.-"; // 数字以外入力不可
            s1.addChild(window);
            
            meter.minimum =   0;
            meter.maximum = 2;
            meter.value = 1;
            s2.addChild(meter);
            
            fuel_meter.minimum = 0;
            fuel_meter.maximum = fuel;
            fuel_meter.value = fuel;
            s2.addChild(fuel_meter);
            addChild(s2);
            
            line.x = 20;
            line.y = 10;
            line.addEventListener(MouseEvent.CLICK, change_line);
            addChild(line);
            line2.x = 40;
            line2.y = 30;
            s3.graphics.beginFill(0xaaaaaa);
            s3.graphics.drawRect(20, 20, 340, 225);
            s3.graphics.endFill();
            s3.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            s3.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            s3.addChild(line2);
            
            test_tf.background = true;
            test_tf.backgroundColor = 0xBEBEBE;
            test_tf.x = 300;
            test_tf.y = 460;
            test_tf.text = "";
            test_tf.width = 200;
            test_tf.text = "Status : " + speed+"km/s  \n            "+location+"km ";
            addChild(test_tf);
            
            timer.addEventListener(TimerEvent.TIMER, now_location);
            addChild(s1);
        }
        private function Slide(event:MouseEvent):void{
            line2.x = mouseX/2;
            line2.y = mouseY/2;
        }
        private function change_line(event:MouseEvent):void{
            if(line_appear_check == false){
                addChild(s3);
                line_appear_check = true;                
            }else{
                removeChild(s3);
                line_appear_check = false;               
            }
        }
        private function onMouseDown(event:MouseEvent):void{
            s3.startDrag();
        } 
        private function onMouseUp(event:MouseEvent):void{
            s3.stopDrag();
        }
        private function click(event:MouseEvent):void
        {
            event.currentTarget.text = "";
            trace(event.currentTarget.text); // 入力欄の内容
        }
        private function clickButton(event:MouseEvent):void{
             removeChild(s1);
             if(Number(input.text) > fuel || input.text == "Input"){
                 addChild(s1);
             }else{
                 fuel -= Number(input.text);
                 tf2.text = fuel + " kgまで使用可能です";
                 using_fuel = Number(input.text);
                 input.text = "0";
                 timer.start();
             }
        }
        public function now_location(e:TimerEvent):void{
            //F = Ma
            var now_location:Number;
            var now_speed:Number;
            var now_weight:Number;
            var now_fuel:Number;
            var a:Number;    //Acceletion
            var f:Number;    //"F" = ma
            var m:Number;    // F = ”m”a
            //現在の速度、位置、燃料の算出・およびグラフ化を行う。
            f = ((0 - using_fuel) / 0.1) * Power + MoonN * weight;
            m = weight; 
            a = (f / m);
            now_speed = speed + a / 1000;
            now_fuel = fuel;
            now_location = location - now_speed;
            test_tf.text = "Status : " + now_speed+"km/s  \n            "+now_location+"km ";
            speed = now_speed;
            location = now_location;
            weight -= using_fuel;
            //メーター管理
            if(now_speed > meter.maximum)meter.maximum = int(now_speed + 1);
            meter.value = now_speed;
            fuel_meter.value = fuel;
            Location.push(location);
            Location2.push(location);
            if(Location2.length > 11)Location2.shift();
            line.Change_Data(Location);
            line2.Change_Data(Location2);
            if(speed  <= 0.0001 && location < 0.01){
                timer.stop();
                test_tf.text = "Complete!";
            }
            if(location < 0)test_tf.text = "Missing!";
            //次の1秒の動作へ移行
            timer.stop();
            addChild(s1);
        }
    }
}
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
class LineChart extends Sprite {
  private var max_tf : TextField = new TextField();
  private var min_tf : TextField = new TextField();
  private var time_tf : TextField = new TextField();
  private var now_location_tf : TextField = new TextField();
  private var data : Array = [];
  private var Chart_width:Number;
  private var Chart_height:Number;
  private var max:Number = 0;
  private var min:Number = 0;
  private var s1:Sprite = new Sprite;
  private var s2:Sprite = new Sprite;
  function LineChart(_width:Number, _height:Number, _data:Array, _Color:int){
    this.data = _data;
    Chart_width = _width;
    Chart_height = _height;
    min_tf.y = _height - (_height / 15);
    time_tf.x = Chart_width - 10;
    time_tf.y = Chart_height;
    now_location_tf.x = 10;
    now_location_tf.y = Chart_height - Chart_height / 10;
    now_location_tf.width = 200;
    now_location_tf.textColor = 0xFF8C00;
    addChild(max_tf);
    addChild(min_tf);
    addChild(time_tf);
    addChild(now_location_tf);
    max_tf.width = 300;
    graphics.lineStyle(0,0x777777);
    graphics.beginFill(_Color);
    graphics.drawRect(0,0,_width,_height);
    graphics.endFill();
    Draw();
  }
  private function MaxMin():void{
      for(var i:int = 0;i < data.length;i++){
          if(max < data[i])max = data[i];
          if(min > data[i])min = data[i];
      }
      max_tf.text = "" + int(max);
      min_tf.text = "" + int(min);
      max_tf.x = 0 - (max_tf.length * 9);
      min_tf.x = 0 - (min_tf.length * 9);
  }
  private function Draw():void{
      MaxMin();
      for(var i:int = 0; i < data.length - 1; i++){
          var x:Number = Chart_width / (data.length - 1) * i;
          var next_x:Number = Chart_width / (data.length - 1) * (i+1);
          var y:Number = Chart_height / (max - min) * data[i];
          var next_y:Number = Chart_height / (max - min) * data[i+1];
          s1.graphics.lineStyle(2, 0x32CD32);        
          s1.graphics.moveTo(x, Chart_height - y);
          s1.graphics.lineTo(next_x, Chart_height - next_y);
          addChild(s1);
          time_tf.text = "" + (data.length-1);
          now_location_tf.text = "location:" + data[i+1];
      }
  }
  public function Change_Data(_data:Array):void{
      data = _data;
      s1.graphics.clear();
      s2.graphics.clear();
      max = 0;
      min = 0;
      Draw();
  }

}
