/**
 * Copyright kjkmr ( http://wonderfl.net/user/kjkmr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2bZn
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import caurina.transitions.Tweener;
    
    public class Main extends Sprite {
        
        private var _container:Sprite = new Sprite();
        
        private var _from:BezierPath = new BezierPath(<path fill="none" stroke="#000000" d="M176.292,398.161c0-9.716,0.357-19.418,0.586-29.109c0.229-9.692,0.331-19.374-0.178-29.051c-1.383,0.093-2.808,0.528-4.25,1.014s-2.899,1.022-4.349,1.316c-4.998,1.015-10.606,1.712-16.236,1.923c-5.629,0.212-11.279-0.062-16.36-0.988c-11.594-2.115-18.367-9.885-19.966-18.834c-1.6-8.95,1.975-19.08,11.078-25.92c5.018-3.771,10.225-5.568,15.683-6.422c5.458-0.854,11.169-0.766,17.196-0.764c4.267,0.001,7.886-0.16,11.141,0.574s6.146,2.363,8.956,5.944c2.629,3.349,4.752,7.493,6.128,11.822s2.003,8.843,1.64,12.934c2.709-7.381,7.281-14.136,13.036-19.489c5.755-5.354,12.694-9.308,20.139-11.085c7.173-1.712,14.217-1.897,21.075-0.83c6.857,1.067,13.529,3.388,19.958,6.688c3.695,1.897,7.896,3.594,11.179,5.974c3.281,2.381,5.643,5.445,5.659,10.076c0.062,18.02-14.316,24.699-31.509,26.413s-37.198-1.538-48.391-3.379c-0.031-0.327-3.94,1.973-3.935,1.693c-2.805,6.032,0.088,9.428,0.151,16.935c0.063,7.506,0.826,15.154,0.82,21.751c-0.003,3.852-0.303,7.692-0.296,11.481s0.32,7.527,1.542,11.172"/>);
        private var _to:BezierPath = new BezierPath(<path fill="none" stroke="#000000" d="M188.324,400.087c-0.073-41.951-0.824-83.696-2.438-125.559c-7.783-0.426-17.133,7.253-23.861,10.497c-7.873,3.797-17.965,8.819-27.031,7.805c-15.467-1.729-24.332-33.294-27.273-45.413c-3.588-14.785,8.756-37.561,24.372-40.848c0.211,1.092,0.48,1.495,0.231,2.768c-10.091-6.033-17.466-23.676-22.812-33.491c-5.764-10.583-18.172-32.821-9.924-45.094c5.585-8.311,18.78-7.048,27.262-8.344c4.256-0.651,15.688-4.25,19.863-1.51c8.04-12.021,11.047-24.974,21.201-36.111c6.964-7.639,15.68-16.915,27.167-15.407c8.352,1.096,13.101,11.518,17.978,17.88c4.139,5.4,20.728,23.333,15.585,31.9c-0.689-10.746,25.26-17.366,32.738-18.536c19.253-3.012,44.501,2.573,50.229,23.55c6.092,22.313,4.264,64.883-26.637,67.638c-3.35,0.299-11.462,0.491-9.632-5.535c2.81-9.248,34.339,14.391,36.698,16.236c15.071,11.789,38.446,36.807,21.668,56.506c-9.763,11.461-38.082,26.517-53.532,17.935c-2.376-1.32-4.147-1.99-2.555-4.209c11.77,4.685,14.909,33.047,10.429,42.996c-3.555,7.895-13.639,8.708-21.31,9.044c-13.537,0.593-22.417-6.477-32.581-14.515c-8.529-6.746-20.6-12.772-21.771-24.303c-0.187-1.835-0.566-3.722-0.59-5.55c-5.118,29.655-2.299,61.414-2.299,91.38c0,10.231,0,17.971,0,28.202"/>);
        
        private var _motion:PathMotion = new PathMotion( _container.graphics, _from, _to );
        
        public function Main() {
            
            stage.align = "LT";
            stage.scaleMode = "noScale";
            addChild( _container );
            
            Tweener.addTween( _motion, { position:1, time:1, delay:1, transition:"easeInOutCubic", onComplete:_reverse } );
        }
        
        private function _reverse():void {
            _motion.reverse();
            Tweener.addTween( _motion, { position:1, time:1, delay:0, transition:"easeInOutCubic", onComplete:_reverse } );
        }
        
    }
}

    
    /*--------------------------------------------------
    * ３次ベジェ曲線のアンカーポイントのデータ
    * jp.kimulabo.display.bezier.Anchor
    --------------------------------------------------*/
    
    class Anchor {
        
        /*--------------------------------------------------
        * インスタンス変数
        --------------------------------------------------*/
        public var x:Number;        // x座標
        public var y:Number;        // y座標
        public var prevX:Number;    // 前のコントロールポイントのx座標
        public var prevY:Number;    // 前のコントロールポイントのy座標
        public var nextX:Number;    // 次のコントロールポイントのx座標
        public var nextY:Number;    // 次のコントロールポイントのy座標
        
        /*--------------------------------------------------
        * コンストラクタ
        --------------------------------------------------*/
        public function Anchor( i_x:Number = 0, i_y:Number = 0, i_prevX:Number = NaN, i_prevY:Number = NaN, i_nextX:Number = NaN, i_nextY:Number = NaN ) {
            x = i_x;
            y = i_y;
            prevX = i_prevX || x;
            prevY = i_prevY || y;
            nextX = i_nextX || x;
            nextY = i_nextY || y;
        }
        
        /*--------------------------------------------------
        * toString()
        --------------------------------------------------*/
        public function toString():String {
            return "Anchor{ x:"+x+", y:"+y+", prevX:"+prevX+", prevY:"+prevY+", nextX:"+nextX+", nextY:"+nextY+" }";
        }
        
        /*--------------------------------------------------
        * clone()
        --------------------------------------------------*/
        public function clone():Anchor {
            return new Anchor( x, y, prevX, prevY, nextX, nextY );
        }
    }





    
    import flash.display.Graphics;
    import flash.geom.Point;
    
    /*--------------------------------------------------
    * ３次ベジェ曲線のパスのデータ
    * jp.kimulabo.display.bezier.BezierPath
    --------------------------------------------------*/
    
    class BezierPath {
        
        /*--------------------------------------------------
        * 定数
        --------------------------------------------------*/
        public static const DIVISION:uint = 8;
        public static const DATA_REG:RegExp = /[MmLlCcHhVvSs][0-9,.-]+/;
        
        /*--------------------------------------------------
        * インスタンス変数
        --------------------------------------------------*/
        public var anchors:Array = [];
        public var random:Number = 2;
        
        /*--------------------------------------------------
        * コンストラクタ
        --------------------------------------------------*/
        public function BezierPath( ... args ) {
            if ( args[0] is XML ) parseSVG( args[0] );
            else push.apply( this, args );
        }
        
        /*--------------------------------------------------
        * アンカーポイントを最後に追加
        --------------------------------------------------*/
        public function push( ... args ):void {
            var i:uint, l:uint = args.length;
            for ( i=0; i<l; i++ ) {
                if ( args[i] is Anchor ) {
                    anchors.push( args[i] );
                } else if ( args[i] is Array ) {
                    push.apply( this, args[i] );
                } else {
                    throw("Invalid Argument ( "+ args[i] + " )");
                }
            }
        }
        
        /*--------------------------------------------------
        * 最後のアンカーポイントを削除
        --------------------------------------------------*/
        public function pop():Anchor {
            var a:Anchor = anchors.pop();
            return a;
        }
        
        /*--------------------------------------------------
        * 特定のアンカーポイントの前にアンカーポイントを追加
        --------------------------------------------------*/
        public function before( i_anchor:Anchor, ... args ):void {
            var i:uint, index:int = -1, l:uint = anchors.length;
            for ( i=0; i<l; i++ ) {
                if ( anchors[i] == i_anchor ) {
                    index = i;
                    break;
                }
            }
            
            if ( index < 0 ) return;
            
            var b:Array = anchors.splice( 0, index );
            l = args.length;
            for ( i=0; i<l; i++ ) {
                if ( args[i] is Anchor ) b.push( args[i] );
                else if ( args[i] is Array ) b = b.concat( args[i] );
                else throw("Invalid Argument ( "+args[i]+" )");
            }
            anchors = b.concat( anchors );
            
        }
        
        /*--------------------------------------------------
        * アンカーポイントの数
        --------------------------------------------------*/
        public function get length():uint { return anchors.length; }
        public function set length( i_value:uint ):void {
            while ( anchors.length < i_value ) anchors.push( anchors[ anchors.length - 1].clone() );
        }
        
        /*--------------------------------------------------
        * 特定のアンカーポイントの後にアンカーポイントを追加
        --------------------------------------------------*/
        public function after( i_anchor:Anchor, ... args ):void {
            var i:uint, index:int = -1, l:uint = anchors.length;
            for ( i=0; i<l; i++ ) {
                if ( anchors[i] == i_anchor ) {
                    index = i;
                    break;
                }
            }
            
            if ( index < 0 ) return;
            var b:Array = anchors.splice( 0, index + 1 );
            l = args.length;
            for ( i=0; i<l; i++ ) {
                if ( args[i] is Anchor ) b.push( args[i] );
                else if ( args[i] is Array ) b = b.concat( args[i] );
                else throw("Invalid Argument ( "+args[i]+" )");
            }
            anchors = b.concat( anchors );
        }
        
        /*--------------------------------------------------
        * 複製
        --------------------------------------------------*/
        public function clone():BezierPath {
            var i:uint, l:uint = anchors.length;
            var a:Array = [];
            for ( i=0; i<l; i++ ) a.push( anchors[i].clone() );
            return new BezierPath( a );
        }
        
        /*--------------------------------------------------
        * SVGをパース
        --------------------------------------------------*/
        public function parseSVG( i_xml:XML ):void {
            var d:String = i_xml.@d;
            var pt:Point = new Point();
            var px:Number, py:Number, nx:Number, ny:Number;
            var s:int, m:String, t:String, tt:String, n:Array;
            var prev:Anchor;
            s = d.search( DATA_REG );
            if ( s < 0 ) return;
            anchors = [];
            while( s >= 0 ) {
                m = d.match( DATA_REG )[0];
                t = m.substr(0,1);
                tt = m.substr(1);
                while( tt.match(/([0-9])-/) ) tt = tt.replace(/([0-9])-/,"$1,-");
                n = tt.split(",");
                switch( t ) {
                    /* 移動 */
                    case "m":
                        pt.x += parseFloat(n[0]);
                        pt.y += parseFloat(n[1]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    case "M":
                        pt.x = parseFloat(n[0]);
                        pt.y = parseFloat(n[1]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    
                    /* 水平線 */
                    case "h":
                        pt.x += parseFloat(n[0]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    case "H":
                        pt.x = parseFloat(n[0]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    
                    /* 垂直線 */
                    case "v":
                        pt.y += parseFloat(n[0]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    case "V":
                        pt.y = parseFloat(n[0]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    
                    /* 直線 */
                    case "l":
                        pt.x += parseFloat(n[0]);
                        pt.y += parseFloat(n[1]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    case "L":
                        pt.x = parseFloat(n[0]);
                        pt.y = parseFloat(n[1]);
                        push( new Anchor( pt.x, pt.y ) );
                        break;
                    
                    /* 三次ベジェ */
                    case "c":
                        nx = pt.x + parseFloat(n[0]);
                        ny = pt.y + parseFloat(n[1]);
                        px = pt.x + parseFloat(n[2]);
                        py = pt.y + parseFloat(n[3]);
                        pt.x += parseFloat(n[4]);
                        pt.y += parseFloat(n[5]);
                        if ( anchors.length ) {
                            prev = anchors[anchors.length - 1];
                            prev.nextX = nx;
                            prev.nextY = ny;
                        }
                        push( new Anchor( pt.x, pt.y, px, py ) );
                        break;
                    case "C":
                        nx = parseFloat(n[0]);
                        ny = parseFloat(n[1]);
                        px = parseFloat(n[2]);
                        py = parseFloat(n[3]);
                        pt.x += parseFloat(n[4]);
                        pt.y += parseFloat(n[5]);
                        if ( anchors.length ) {
                            prev = anchors[anchors.length - 1];
                            prev.nextX = nx;
                            prev.nextY = ny;
                        }
                        push( new Anchor( pt.x, pt.y, px, py ) );
                        break;
                        
                    /* 省略型滑三次ベジェ  */
                    case "s":
                        px = pt.x + parseFloat(n[0]);
                        py = pt.y + parseFloat(n[1]);
                        pt.x += parseFloat(n[2]);
                        pt.y += parseFloat(n[3]);
                        if ( anchors.length ) {
                            prev = anchors[anchors.length - 1];
                            prev.nextX = isNaN(prev.prevX) ? prev.x : prev.x + ( prev.x - prev.prevX );
                            prev.nextY = isNaN(prev.prevY) ? prev.y : prev.y + ( prev.y - prev.prevY );
                        }
                        push( new Anchor( pt.x, pt.y, px, py ) );
                        break;
                    case "S":
                        nx = parseFloat(n[0]);
                        ny = parseFloat(n[1]);
                        px = parseFloat(n[2]);
                        py = parseFloat(n[3]);
                        pt.x += parseFloat(n[4]);
                        pt.y += parseFloat(n[5]);
                        if ( anchors.length ) {
                            prev = anchors[anchors.length - 1];
                            prev.nextX = isNaN(prev.prevX) ? prev.x : prev.x + ( prev.x - prev.prevX );
                            prev.nextY = isNaN(prev.prevY) ? prev.y : prev.y + ( prev.y - prev.prevY );
                        }
                        push( new Anchor( pt.x, pt.y, px, py ) );
                        break;
                    default:
                        trace(t);
                        break;
                }
                //
                d = d.substr( m.length );
                s = d.search( DATA_REG );
            }

        }
        
        /*--------------------------------------------------
        * Graphics描画
        * 分割して３次ベジェを２次ベジェに変換して描画
        --------------------------------------------------*/
        public function redraw( i_graphics:Graphics ):void {
            i_graphics.clear();
            draw( i_graphics );
        }
        
        public function draw( i_graphics:Graphics ):void {
            //初期化
            if ( !anchors.length ) return;
            
            var i:uint;
            var l:uint = anchors.length - 1;
            var t:Number;
            var offset:Number = 1 / DIVISION;
            var pt1:Point;
            var pt2:Point;
            var pt3:Point;
            var sa:Anchor, ea:Anchor;
            var s:Boolean, e:Boolean;
            var b:BezierSegment;
            
            i_graphics.lineStyle( 1, 0 );
            i_graphics.moveTo( anchors[0].x,  anchors[0].y );
            for ( i=0; i<l; i++ ) {
                sa = anchors[i];
                ea = anchors[i+1];
                if ( sa.x == ea.x && sa.y == ea.y ) continue;
                //コントロールポイントの有無
                s = ( !isNaN( sa.nextX ) && !isNaN( sa.nextY ) ) as Boolean;
                e = ( !isNaN( ea.prevX ) && !isNaN( ea.prevY ) ) as Boolean;
                if ( s && e ) {
                    //３次ベジェを分割して近似２次ベジェに変換
                    b = new BezierSegment(
                        new Point( sa.x, sa.y ),
                        new Point( sa.nextX || 0, sa.nextY || 0 ), 
                        new Point( ea.prevX || 0, ea.prevY || 0 ), 
                        new Point( ea.x, ea.y )
                    );
                    t = 0;
                    while ( t < 1.0 - offset ) {
                        pt1 = b.getValue(t);
                        t += offset;
                        pt2 = b.getValue(t);
                        t += offset;
                        pt3 = b.getValue(t);
                        
                        pt2 = new Point(
                            pt2.x * 2 - ( pt1.x + pt3.x ) * 0.5,
                            pt2.y * 2 - ( pt1.y + pt3.y ) * 0.5
                        );
                        if ( random != 0 ) {
                            pt2.x += Math.random() * random - random * 0.5;
                            pt2.y += Math.random() * random - random * 0.5;
                            pt3.x += Math.random() * random - random * 0.5;
                            pt3.y += Math.random() * random - random * 0.5;
                        }
                        i_graphics.curveTo( pt2.x, pt2.y, pt3.x, pt3.y );
                    }
                } else {
                    //直線
                    i_graphics.lineTo( ea.x, ea.y );
                }
            }
        }
        
    }



    
    import flash.display.Graphics;
    import flash.geom.Point;
    
    /*--------------------------------------------------
    * ３次ベジェ曲線のパスのデータのシェイプトゥイーン
    * jp.kimulabo.display.bezier.PathMotion
    --------------------------------------------------*/
    
    class PathMotion {
        
        /*--------------------------------------------------
        * 定数
        --------------------------------------------------*/
        
        /*--------------------------------------------------
        * インスタンス変数
        --------------------------------------------------*/
        private var _graphics:Graphics;
        private var _path:BezierPath;
        private var _from:BezierPath;
        private var _to:BezierPath;
        private var _position:Number = 0;
        
        /*--------------------------------------------------
        * コンストラクタ
        --------------------------------------------------*/
        public function PathMotion( i_graphics:Graphics, i_from:BezierPath = null, i_to:BezierPath = null ) {
            _graphics = i_graphics;
            from = i_from;
            to = i_to;
        }
        
        /*--------------------------------------------------
        * getter & setter for from / to
        --------------------------------------------------*/
        public function get from():BezierPath { return _from; }
        public function set from( i_value:BezierPath ):void {
            _from = i_value;
            if ( _from ) _path = _from.clone();
            adjustLength();
            position = _position;
        }
        
        public function get to():BezierPath { return _to; }
        public function set to( i_value:BezierPath ):void {
            _to = i_value;
            adjustLength();
            position = _position;
        }
        
        public function adjustLength():void {
            if ( !_from || !_to || !_path ) return;
            _from.length = _to.length;
            _to.length = _from.length;
            _path.length = _from.length;
        }
        
        /*--------------------------------------------------
        * reverse();
        --------------------------------------------------*/
        public function reverse():void {
            var f:BezierPath = _from;
            _from = _to;
            _to = f;
            position = 1-_position;
        }
        
        /*--------------------------------------------------
        * getter & setter for position
        --------------------------------------------------*/
        public function get position():Number { return _position; }
        public function set position( i_value:Number ):void {
            if ( !_from || !_to ) return;
            _position = i_value;
            var i:uint, l:uint = _path.length;
            var a:Anchor, from:Anchor, to:Anchor;
            
            for ( i=0; i<l; i++ ) {
                a = _path.anchors[i];
                from = _from.anchors[i];
                to = _to.anchors[i];
                a.x = from.x + ( to.x - from.x ) * _position;
                a.y = from.y + ( to.y - from.y ) * _position;
                a.prevX = from.prevX + ( to.prevX - from.prevX ) * _position;
                a.prevY = from.prevY + ( to.prevY - from.prevY ) * _position;
                a.nextX = from.nextX + ( to.nextX - from.nextX ) * _position;
                a.nextY = from.nextY + ( to.nextY - from.nextY ) * _position;
            }
            _path.redraw( _graphics );
        }
        
        
    }


    /*--------------------------------------------------
    * BezierSegment
    *
    * wonderflに fl.motion.BezierSegment がないから、@nanlow さんのを拝借してちょっと修正
    * http://wonderfl.net/c/dHyt
    *
    --------------------------------------------------*/

    class BezierSegment {
        private var _anchor0:Point;
        private var _anchor1:Point;
        private var _controll0:Point;
        private var _controll1:Point;
        public function BezierSegment(anchor0:Point, controll0:Point, controll1:Point, anchor1:Point) {
            _anchor0 = anchor0;
            _anchor1 = anchor1;
            _controll0 = controll0;
            _controll1 = controll1;
        }
        public function getValue(per:Number):Point {
            if (per < 0 || 1 < per) {
                throw new Error(' 0≦per≦1でお願いしますm(_ _;)m');
            }
            var p:Number = 1 - per;
            return new Point(p * p * p * _anchor0.x + 3 * p * p * per * _controll0.x + 3 * p * per * per * _controll1.x + per * per * per * _anchor1.x,p * p * p * _anchor0.y + 3 * p * p * per * _controll0.y + 3 * p * per * per * _controll1.y + per * per * per * _anchor1.y);
        }
    }
