/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2b9S
 */

// forked from tkinjo's forked from: Yahoo Pipes Flickr Module
// forked from tkinjo's Yahoo Pipes Flickr Module
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.utils.*;
    import org.libspark.betweenas3.*;
    import flash.geom.*;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        //private const BASE_URL:String = "http://pipes.yahoo.com/pipes/pipe.run?_id=08f23301b0f331eea4b1f44693fba4f8&_render=rss";
        private const BASE_URL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=08f23301b0f331eea4b1f44693fba4f8&_render=rss";
        private const URL_PARAM:Array = new Array();
        private const FIND:uint = 10;
        private const IMAGES_OF:String = "graphics";
        private const IMAGE_WIDTH:Number = 75;
        
        private const THUMBNAIL_LIST_OFFSET:Number = 75;
        private const THUMBNAIL_LIST_PADDING:Number = 2;
        private const REFLECTION_OFFSET:Number = 2;
        
        private var numHorizontalImage:uint;
        
        private var URL:String = BASE_URL + "&find=" + FIND + "&images_of=" + escapeMultiByte( IMAGES_OF );
        
        private var FLASH_SPEED:Number = 0.2;
        private var FLASH_VALUE:Number = 0.5;
        
        private var thumbnailList:Sprite = new Sprite();
        
        private var viewer:Sprite = new Sprite();
        
        private var i:uint = 0;
        
        public function Main()
        {
            numHorizontalImage = stage.stageWidth / 75;
            addChild( thumbnailList );
            addChild( viewer );
            
            var urlRequest:URLRequest = new URLRequest( URL );
            var urlLoader:URLLoader = new URLLoader();
            
            try {
                urlLoader.load( urlRequest );
            }
            catch (error:SecurityError)
            {
                trace("A SecurityError has occurred.");
                return;
            }
            
            urlLoader.addEventListener( Event.COMPLETE, completeHandler );
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            if ( thumbnailList.width > stage.stageWidth )
                thumbnailList.x += ( - stage.mouseX / stage.stageWidth * ( thumbnailList.width + THUMBNAIL_LIST_OFFSET * 2 - stage.stageWidth ) + THUMBNAIL_LIST_OFFSET - thumbnailList.x ) * 0.1;
                
            else 
                thumbnailList.x = 0;
        }
        
        private function completeHandler( event:Event ):void {
            
            var urlLoader:URLLoader = event.currentTarget as URLLoader;
            
            try {
                var rss:XML = new XML(urlLoader.data);
                trace( rss );
            }
            catch (error:SecurityError)
            {
                trace("error.");
                return;
            }
            
            var i:uint = 0;
            var media:Namespace = rss.namespace( "media" );
            
            for each( var item:XML in rss.channel.item ){
                
                var thumbnailUrl:String = item.media::group.media::thumbnail.@url;
                var contentUrl:String = item.media::group.media::content.@url;
                
                var thumbnailButton:ThumbnailButton = new ThumbnailButton( thumbnailUrl, contentUrl );
                thumbnailButton.x = i * ( IMAGE_WIDTH + THUMBNAIL_LIST_PADDING );
                thumbnailList.addChild( thumbnailButton );
                
                thumbnailButton.thumbnailLoader.addEventListener(MouseEvent.CLICK, thumbnailClickHandler );
                
                i++;
            }
        }
        
        private function thumbnailClickHandler( event:MouseEvent ):void {
            
            var thumbnailLoader:Loader = event.currentTarget as Loader;
            var thumbnail:Sprite = thumbnailLoader.parent as Sprite;
            var thumbnailButton:ThumbnailButton = thumbnail.parent as ThumbnailButton;
            
            if ( thumbnailButton.contentLoader )
                view( thumbnailButton.contentLoader );
            
            else {
                
                thumbnailButton.addEventListener(Event.COMPLETE, contentLoadedHandler );
                thumbnailButton.loadContent();
            }
        }
        
        private function contentLoadedHandler( event:Event ):void {
            
            var thumbnailButton:ThumbnailButton = event.currentTarget as ThumbnailButton;
            view( thumbnailButton.contentLoader );
        }
        
        private function view( content:Loader ):void {
            
            for ( var i:uint = 0; i < viewer.numChildren; i++ )
                viewer.removeChildAt( i );
            
            viewer.addChild( content );
            BetweenAS3.tween( content, { alpha:1 }, { alpha:0 } ).play();
            
            if ( content.scaleX != 1 )
                return;
            
            content.scaleX = stage.stageWidth / content.width;
            content.scaleY = ( stage.stageHeight - IMAGE_WIDTH * 3 / 2 ) / content.height;
            
            if ( content.scaleX < content.scaleY )
                content.scaleY = content.scaleX;
                
            else 
                content.scaleX = content.scaleY;
            
            content.x = ( stage.stageWidth - content.width ) / 2;
            content.y = ( stage.stageHeight - IMAGE_WIDTH * 3 / 2 - content.height ) / 2 + IMAGE_WIDTH * 3 / 2;
        }
    }
}

import flash.display.*;
import flash.geom.*;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.BetweenAS3;
import flash.events.*;
import flash.net.*;
import flash.system.*;

class ThumbnailButton extends Sprite {
    
    /**
     * ...
     * @eventType flash.events.Event.COMPLETE
     */
    [Event(name = "complete", type = "flash.events.Event")] 
    
    
    private var thumbnailUrl:String;
    private var contentUrl:String;
    
    private var _thumbnail:Sprite;
    public function get thumbnail():Sprite { return _thumbnail; }
    
    private var _thumbnailLoader:Loader;
    public function get thumbnailLoader():Loader { return _thumbnailLoader; }
    
    private var _reflectedThumbnailLoader:Loader;
    public function get reflectedThumbnailLoader():Loader { return _reflectedThumbnailLoader; }
    
    private var _contentLoader:Loader;
    public function get contentLoader():Loader { return _contentLoader; }
    
    private var _brightness:Number = 0;
    
    public function get brightness():Number {
        
        return _brightness;
    }
    
    public function set brightness( value:Number ):void {
        
        _brightness = value;
        transform.colorTransform = new ColorTransform( 1, 1, 1, 1, 255 * brightness, 255 * brightness, 255 * brightness );
    }
    
    
    
    
    private var tween:ITween;
    public var turnOnSpeed:Number = 0.2;
    public var turnOffSpeed:Number = 0.5;
    public var maxFlashValue:Number = 0.5;
    public var reflectionOffset:Number = 2;
    
    
    public function ThumbnailButton( thumbnailUrl:String, contentUrl:String ):void {
        
        this.thumbnailUrl = thumbnailUrl;
        this.contentUrl = contentUrl;
        
        var urlRequest:URLRequest = new URLRequest( thumbnailUrl );
        
        _thumbnailLoader = new Loader();
        thumbnailLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, thumbnailLoadCompleteHandler );
        thumbnailLoader.load( urlRequest, new LoaderContext( true ) );
        
        _reflectedThumbnailLoader = new Loader();
        reflectedThumbnailLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, thumbnailLoadCompleteHandler );
        reflectedThumbnailLoader.load( urlRequest, new LoaderContext( true ) );
    }
    
    private function thumbnailLoadCompleteHandler( event:Event ):void {
        
        if ( !( thumbnailLoader.width && reflectedThumbnailLoader.width ) )
            return;
        
        // image
        _thumbnail = new Sprite();
        thumbnail.addChild( thumbnailLoader );
        thumbnail.buttonMode = true;
        addChild( thumbnail );
        
        // reflection
        var reftectionMask:Sprite = createReflectionMask( thumbnail.width, thumbnail.height / 2 );
        reflectedThumbnailLoader.scaleY = -1;
        reflectedThumbnailLoader.y = thumbnail.height * 2 + reflectionOffset;
        reflectedThumbnailLoader.cacheAsBitmap = true;
        reflectedThumbnailLoader.mask = reftectionMask;
        reftectionMask.y = reflectedThumbnailLoader.y - thumbnail.height;
        reftectionMask.alpha = 0.5;
        addChild( reflectedThumbnailLoader );
        addChild( reftectionMask );
        
        BetweenAS3.tween( this, { alpha:1 }, { alpha:0 } ).play();
        
        thumbnail.addEventListener(MouseEvent.MOUSE_OVER, thumbnailMouseOverHandler);
        thumbnail.addEventListener(MouseEvent.MOUSE_OUT, thumbnailMouseOutHandler);
    }
    
    private function thumbnailMouseOverHandler( event:MouseEvent ):void {
        
        if ( tween )
            tween.stop();
        tween = BetweenAS3.tween( this, { brightness:maxFlashValue }, null, turnOnSpeed );
        tween.play();
    }
    
    private function thumbnailMouseOutHandler( event:MouseEvent ):void {
        
        if ( tween )
            tween.stop();
        tween = BetweenAS3.tween( this, { brightness:0 }, null, turnOffSpeed );
        tween.play();
    }
    
    public function loadContent():void {
        
        if ( contentLoader )
            return;
        
        var urlRequest:URLRequest = new URLRequest( contentUrl );
        
        _contentLoader = new Loader();
        contentLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, contentLoadCompleteHandler );
        contentLoader.load( urlRequest, new LoaderContext( true ) );
    }
    
    private function contentLoadCompleteHandler( event:Event ):void {
        
        dispatchEvent( event );
    }
}

class ImageListLoader {
    
}

function createReflectionMask( width:Number, height:Number ):Sprite {
    
    var reflectionMask:Sprite = new Sprite();
    
    var reflectionMatrix:Matrix = new Matrix();
    reflectionMatrix.createGradientBox( width, height, Math.PI / 2, 0, 0 );
    
    reflectionMask.graphics.beginGradientFill( GradientType.LINEAR, [ 0, 0 ], [ 1, 0 ], [ 0, 255 ], reflectionMatrix );
    reflectionMask.graphics.drawRect( 0, 0, width, height );
    reflectionMask.graphics.endFill();
    
    reflectionMask.cacheAsBitmap = true;
    
    return reflectionMask;
}
/*
function createReflectionImage( image:DisplayObject ):Sprite {
    
    var reflectionImageContainer:Sprite = new Sprite();
    
    var imageBitmapData:BitmapData = new BitmapData( image.width, image.height, true, 0 );
    
    var reflectionMatrix:Matrix = new Matrix();
    reflectionMatrix.scale( 1, -1 );
    reflectionMatrix.translate( 0, image.height );
    imageBitmapData.draw( image, reflectionMatrix );
    
    var reflectionImage:Bitmap = new Bitmap( imageBitmapData );
    reflectionImage.cacheAsBitmap = true;
    
    var reflectionMask:Sprite = createReflectionMask( image.width, image.height / 2 );
    reflectionImageContainer.addChild( reflectionMask );
    
    reflectionImage.mask = reflectionMask;
    reflectionImageContainer.addChild( reflectionImage );
    
    return reflectionImageContainer;
}//*/