/**
 * Copyright mhayashi ( http://wonderfl.net/user/mhayashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2abR
 */

// forked from mhayashi's forked from: forked from: forked from: forked from: flash on 2010-2-21
// forked from mhayashi's forked from: forked from: forked from: flash on 2010-2-21
// forked from mhayashi's forked from: forked from: flash on 2010-2-21
// forked from mhayashi's forked from: flash on 2010-2-21
// forked from mhayashi's flash on 2010-2-21
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.Matrix;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.filters.BlurFilter;
	
	[SWF(width=465, height=465, backgroundColor=0, framerate=30)]
    public class BitmapDataSample extends Sprite {

		private var bmpdata:BitmapData;
		private var sprite:Sprite;
		private var matrix:Matrix;
		private var colortrans:ColorTransform;
		private var filter:BlurFilter;
		
        public function BitmapDataSample() {
			bmpdata = new BitmapData( 465, 465, false, 0 );
			addChild( new Bitmap(bmpdata) );

			sprite = newFig( 0, 0, 40, 0xFFFFFF );

			matrix = new Matrix();
			colortrans = new ColorTransform;
			filter = new BlurFilter(2,2,1);
			
			addEventListener( Event.ENTER_FRAME, enterFrame );
			stage.addEventListener( MouseEvent.CLICK, reset );
        }

		// ENTER_FRAME のイベントリスナー
		private function enterFrame(e:Event):void {
			matrix.identity();

			var s:Number = Math.random()*2;
			matrix.scale(s, s);

			matrix.rotate(Math.PI * Math.random());

			matrix.translate(mouseX, mouseY);

			bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
			
			// マウスの座標を色の変換に使っているので、ポインタの位置によって色が変わる
			// かつ、グラデーションがかかる
			colortrans.greenMultiplier = mouseX / 465;
			colortrans.blueMultiplier = mouseY / 465;
			colortrans.alphaMultiplier = Math.random();
			
			bmpdata.draw(sprite, matrix, colortrans);
		}

		// マウスクリックのイベントリスナー
		private function reset(e:MouseEvent):void {
			bmpdata.fillRect( bmpdata.rect, 0xFF000000 );
		}
		
		private function newFig( cx:Number, cy:Number, size:Number, color:uint ):Sprite {
			var shape:Sprite = new Sprite();
			shape.graphics.lineStyle( 0, 0x000000, 0.3 );
			shape.graphics.beginFill( color );

			shape.graphics.drawCircle( cx, cy, size*0.5 );
			shape.graphics.drawCircle( cx, cy, size*0.4 );

			var w:Number = size * 0.6;
			var h:Number = size * 0.15;
			shape.graphics.drawRect(
				cx - w/2,		// 横の位置（円の中心）
				cy - h/2,		// 縦の位置（円の中心）
				w,
				h );
			shape.graphics.endFill();
			return shape;
		}
    }
}
