/**
 * Copyright kimo0517 ( http://wonderfl.net/user/kimo0517 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2ZK1
 */

/*
 * @Author: kimo0517
 * LinearLine and intersection points calculation. 
 * # drag on screen to add a new linear line. 
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(width=468, height=468, backgroundColor=0xFFFFFF)]
    public class LinearLineIntersection extends Sprite 
    {
        private var canvas:Bitmap;
        private var tmpSprite:Sprite;
        private var lines:Vector.<LinearLine>;
        private var startX:Number;
        private var startY:Number;
        private var endX:Number;
        private var endY:Number;
        private var currentLine:LinearLine;
        private var isMouseDown:Boolean;
        
        public function LinearLineIntersection():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            canvas = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF));
            canvas.smoothing = true;
            addChild(canvas);
            
            tmpSprite = new Sprite;
            addChild(tmpSprite);
            
            currentLine = new LinearLine;
            lines = new Vector.<LinearLine>();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _mouseDown);
            
            var tf:TextField = new TextField;
            tf.autoSize = "left";
            tf.mouseEnabled = false;
            tf.text = "Drag on screen to draw lines";
            tf.x = 5;
            tf.y = 5;
            addChild(tf);
        }
        
        
        private function _mouseDown(e:MouseEvent):void {
            startX = stage.mouseX;
            startY = stage.mouseY;
            stage.addEventListener(Event.ENTER_FRAME, _update);
            stage.addEventListener(MouseEvent.MOUSE_UP, _mouseUp);
            isMouseDown = true;
        }
        
        private function _mouseUp(e:MouseEvent):void {
            if (!(((stage.mouseX - startX) * (stage.mouseX - startX) + (stage.mouseY - startY) * (stage.mouseY - startY)) < 10)) {
                _update(null);
                lines.push(currentLine);
                currentLine = new LinearLine;
                canvas.bitmapData.draw(tmpSprite, null, null, null, null, true);
                tmpSprite.graphics.clear();
            }
            stage.removeEventListener(Event.ENTER_FRAME, _update);
            stage.removeEventListener(MouseEvent.MOUSE_UP, _mouseUp);
        }
        
        private function _update(e:Event):void {
            var i:int;
            var pt:Point;
            var pt2:Point;
            var pt3:Point;
            var pt4:Point;
            tmpSprite.graphics.clear();
            
            if (((stage.mouseX - startX) * (stage.mouseX - startX) + (stage.mouseY - startY) * (stage.mouseY - startY)) < 10) {
                return;
            }
            
            currentLine.initBy2Points(startX, startY, mouseX, mouseY);
            
            
            pt = new Point(currentLine.getX(0), 0);
            pt2 = new Point(currentLine.getX(stage.stageHeight), stage.stageHeight);
            
            pt3 = new Point(0, currentLine.getY(0));
            pt4 = new Point(stage.stageWidth, currentLine.getY(stage.stageWidth));
            
            var tmpArray:Vector.<Point> = new Vector.<Point>();
            if (pt.x >= 0 && pt.x <= stage.stageWidth) {
                tmpArray.push(pt);
            }
            if (pt2.x >= 0 && pt2.x <= stage.stageWidth) {
                tmpArray.push(pt2);
            }
            if (pt3.y >= 0 && pt3.y <= stage.stageHeight) {
                tmpArray.push(pt3);
            }
            if (pt4.y >= 0 && pt4.y <= stage.stageHeight) {
                tmpArray.push(pt4);
            }
            
            if (tmpArray.length < 2) {
                return;
            }
            
            if (e != null) {
                tmpSprite.graphics.lineStyle(1, 0x000000, 0.8);
                tmpSprite.graphics.moveTo(tmpArray[0].x, tmpArray[0].y);
                tmpSprite.graphics.lineTo(tmpArray[1].x, tmpArray[1].y);
                
                tmpSprite.graphics.lineStyle(5, 0xFF0000, 1);
                tmpSprite.graphics.moveTo(startX, startY);
                tmpSprite.graphics.lineTo(stage.mouseX, stage.mouseY);
            } else {
                tmpSprite.graphics.lineStyle(1, 0x000000, 1);
                tmpSprite.graphics.moveTo(tmpArray[0].x, tmpArray[0].y);
                tmpSprite.graphics.lineTo(tmpArray[1].x, tmpArray[1].y);
            }
            
            tmpSprite.graphics.lineStyle(0, 0x000000, 0);
            tmpSprite.graphics.beginFill(0x0000FF, 1);
            for (i = 0; i < lines.length; i++) {
                pt = currentLine.intersect(lines[i]);
                if (pt != null) {
                    tmpSprite.graphics.drawCircle(pt.x, pt.y, 3);
                }
            }
            tmpSprite.graphics.endFill();
        }
    }
    
    
}


import flash.geom.Point;

class LinearLine {
    private var _m:Number=0;
    private var _c:Number=0;
    private var _isVertical:Boolean;
    private var _verticalX:Number;
    
    public function initBy2Points(x1:Number, y1:Number, x2:Number, y2:Number):void {
        if (Math.abs(x2-x1) < 0.01) {
            _isVertical = true;
            _verticalX = (x1+x2)/2.0;
        } else {
            _isVertical = false;
            _m = (y2-y1)/(x2-x1);
            _c = (y1*(x2-x1)-x1*(y2-y1))/(x2-x1);
        }

    }
    
    public function get m():Number {
        return _m;
    }
    
    public function get c():Number {
        return _c;
    }
    
    public function get isVertical():Boolean {
        return _isVertical;
    }

    public function get verticalX():Number {
        return _verticalX;
    }

    public function getY(_x:Number):Number {
        if (!_isVertical) {
            return _m*_x + _c;
        } else {
            return Number.POSITIVE_INFINITY; //no solution
        }

    }
    
    public function getX(_y:Number):Number {
        if (!_isVertical) {
            return (_y-_c)/_m;
        } else {
            return _verticalX;
        }

    }

    public function intersect(_l:LinearLine):Point {
        if (isVertical && _l.isVertical) {
            return null;
        } else if (isVertical) {
            return new Point(_verticalX, _l.getY(_verticalX));
        } else if (_l.isVertical) {
            return new Point(_l.verticalX, _m*_l.verticalX + _c);
        } else {
            if (_m==m2) {
                return null;    //no solution
            }
            var c2:Number = _l.c;
            var m2:Number = _l.m;
            var x0:Number = (c2-_c)/(_m-m2);
            var y0:Number = _m*x0+_c;
            return new Point(x0,y0);
        }
    }
}