/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2YpQ
 */

package {
    import flash.text.*;
    import flash.display.*;
    public class FlashTest extends Sprite {
        /* this text by http://www.kayac.com/vision */
        private static var str:String = "つくるという行為は、自分を深く理解することにつながる。そう考える。\n"
            +"人はつくることを通して、\n"
            +"自分が「何を美しいと感じ、何を醜いと感じるか」「何が好きで、何が嫌いか」\n"
            +"という価値基準を知る。\n"
            +"あらゆることを、自分だけのモノサシで見られるようになっていく。\n"
            +"そしてその自分だけのモノサシを通して、\n"
            +"人の受け売りではない、自分なりの幸せになる方法論が見えてくる。\n"
            +"だから、つくることは、１人ひとりが幸せになれる社会につながっていく。";
            
        private var _limitWidth:int = 400;
        private var _limitHeight:int = 1000;
        private var _offsetX:int = 10;
        private var _offsetY:int = 10;
        
        public function FlashTest() {
            var baseSize:int = 32;
            var size:int = FitTextHeight.execute(str,_limitWidth,_limitHeight,baseSize);
            
            addChild(createBasicTextField(size));
            //addChild(createKeringField(size));
            addChild(createGuideLine(size));
            
            //addChild(createTestChar(size));
            addChild(createCharField(size));
            
        }
        
        private function createTestChar(size:int):DisplayObject {
            var char:Char = new Char("人",size);
            char.x = _offsetX;
            char.y = _offsetY;//*2 + _limitHeight;
            return char;
        }
        private function createCharField(size:int):DisplayObject {
            var field:Sprite = new Sprite();
            field.x = _offsetX;
            field.y = _offsetY;
            var color:uint = 0x0000FF;
            var l:int = str.length;
            
            var limLetters:int = _limitWidth/(size);
            var lineHeight:int = size*1.5;
            
            var lines:int = 0;
            var letters:int = 0;
            for(var i:int=0; i<l; i++) {
                var charstr:String = str.substr(i,1);
                var isBreak :Boolean = Char.isBreak(charstr);
                if( isBreak || limLetters <= letters ) {
                    letters = 0;
                    lines += 1;
                }
                if(isBreak) continue;
                var char:Char = new Char(charstr,size,color);
                char.x = letters*size;
                char.y = lines*lineHeight;//*2 + _limitHeight;
                field.addChild(char);
                letters++;
            }
            return field;
        }
        
        private function createGuideLine(size:int):DisplayObject {
            var guide:Sprite = new Sprite();
            
            guide.graphics.lineStyle(1,0x003366,0.3);
            guide.graphics.beginFill(0x000033,0.05);
            guide.graphics.drawRect(_offsetX,_offsetY,_limitWidth,_limitHeight);
            guide.graphics.endFill();
            
            return guide;
        }

        
        private function createBasicTextField(size:int):DisplayObject {
            var textField:TextField = new TextField();
            textField.multiline = true;
            textField.wordWrap = true;
            textField.selectable = false;
            textField.x = _offsetX;
            textField.y = _offsetY;
            textField.width = _limitWidth;
            textField.height = _limitHeight;
            //textField.autoSize = TextFieldAutoSize.LEFT;
            textField.defaultTextFormat = new MainTextFormat(size,true);
            textField.text = str;
            return textField; 
        }
        
        private function createKeringField(size:int):DisplayObject {
            var textField:TextField = new TextField();
            textField.multiline = true;
            textField.wordWrap = true;
            textField.selectable = false;
            textField.x = _offsetX;
            textField.y = _offsetY;
            textField.width = _limitWidth;
            textField.height = _limitHeight;
            //textField.autoSize = TextFieldAutoSize.LEFT;
            textField.defaultTextFormat = new MainTextFormat(size);
            textField.text = str;
            return textField; 
        }
    }
}
import flash.geom.Rectangle;

import flash.text.*;
import flash.display.*;

internal class MainTextFormat extends TextFormat {
    private static var _instance:TextFormat;
    public static function get instance():TextFormat {
        if (_instance) return _instance;
        
        return _instance = new MainTextFormat();
    }
    public function MainTextFormat(size:Object = null, bold:Object = null, url:String = null, target:String = null, align:String = null, leftMargin:Object = null, rightMargin:Object = null, indent:Object = null, leading:Object = null) {
        super("Meiryo", size, 0x990000, bold, null, null, url, target, align, leftMargin, rightMargin, indent, leading);
    }
}

internal class FitTextHeight {
    private static var _testField:TextField;
    protected static function getTestField():TextField {
        if (_testField) return _testField;
    
        _testField = new TextField();
        _testField.multiline = true;
        _testField.wordWrap = true;
        _testField.autoSize = 'left';
        return _testField;
    }
    private static var _testFormat:TextFormat;
    protected static function getTestFormat():TextFormat {
        if (_testFormat) return _testFormat;
        _testFormat = new MainTextFormat();
        return _testFormat;
    }
    
    public function FitTextHeight() {
    }
    
    public static function execute(text:String, widLimit:int, heiLimit:int,fontSize:int):int {
        getTestField().width = widLimit;
        var tf :TextFormat = getTestFormat();
        tf.size = fontSize;
        return _fitTextHeight(text, heiLimit, tf);
    }
    
    /**
     * @private
     */
    protected static function _fitTextHeight(text:String, heiLimit:int, format:TextFormat) :int {
        getTestField().defaultTextFormat = format;
        getTestField().text = text;
        
        if (getTestField().height > heiLimit) {
            format.size = Number(format.size) -2;
            return _fitTextHeight(text, heiLimit, format);
        }
        else return format.size as int;
    }
}

internal class Char extends Sprite{
    private var _boxSizeX:int = 0;
    private var _boxSizeY:int = 0;
    //*
    override public function get x():Number {
        return super.x - _boxSizeX;
    }
    override public function set x(value:Number):void {
        super.x = value + _boxSizeX;
    }
    override public function get y():Number {
        return super.y - _boxSizeY;
    }
    override public function set y(value:Number):void {
        super.y = value + _boxSizeY;
    }
    //*/

    public static function isBreak(charStr:String):Boolean{ 
        return charStr == "\r" || charStr == "\n" || charStr == "\r\n";
    }
    private var _fontSize:int;
    public function get fontSize():int {
        return _fontSize;
    }
    private var _char:String;
    private var _wordbreak:Boolean;
    public function get text():String {
        return _char;
    }
    
    public function get wordbreak():Boolean {
        return _wordbreak;
    }
    
    public function Char(charStr:String, fontSize:int, color:uint=-1) {
        _wordbreak = isBreak(charStr);
        
        if(!_wordbreak){
            _char     = charStr;
            _fontSize = fontSize;
            
            var charField:TextField = new TextField();
            var tf:TextFormat = new MainTextFormat(fontSize);
            //tf.align = TextFormatAlign.CENTER;
            if(color>=0) tf.color = color;
            charField.defaultTextFormat = tf;
            charField.selectable = false;
            charField.autoSize = 'left';
            charField.text = _char;
            _boxSizeX = (charField.textWidth / 2) >> 0;
            charField.x = -_boxSizeX;
            _boxSizeY = (charField.height / 2) >> 0;
            charField.y = -_boxSizeY;
            addChild(charField);
            
            charField.border = true;
            
            var r:Rectangle = getBounds(parent);
            graphics.beginFill(0,0.2);
            graphics.drawRect(r.x,r.y,r.width,r.height);
            graphics.endFill();
        }
    }
}
