/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Y0e
 */

 package { 
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.Shapes.*;
    import Box2D.Common.Math.b2Vec2; 
    import Box2D.Dynamics.*;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
 
  public class Main extends Sprite {
    /**
     * 床の上に箱を落とすFlash
     */
 private var world:b2World;
 private var worldScale:Number=30; 
 private var boxBody:b2Body; 
    
  public function Main() {
      var gravity:b2Vec2=new b2Vec2(0,9.81);
      var sleep:Boolean=true; 
      var bodyDef:b2BodyDef=new b2BodyDef();
      var circleShape:b2CircleShape; 
      
      
       stage.addEventListener(MouseEvent.CLICK, clickHandler);                
            ////////////////////////////////////////
            // 物理エンジンのセットアップ
            
            // 外枠を定義する
           // 重力を下方向に10m/s^2とする
                
            // Set the world boundaries:
      var worldAABB:b2AABB = new b2AABB();
      worldAABB.lowerBound.Set(-100, -100);
      worldAABB.upperBound.Set(100, 100);

            
            // 外枠と重力を指定して、物理エンジン全体をセットアップする
      
       world = new b2World(worldAABB, gravity,  sleep);
       bodyDef.position.Set(320/worldScale,30/worldScale); 
       
             
      // Create a body for the floor:
      var floorBodyDef:b2BodyDef = new b2BodyDef();
      floorBodyDef.position.Set(2.5, 4.5); 
      var floorBody:b2Body = world.CreateBody(floorBodyDef);
      
      // Create a shape for the floor:
      var floorShapeDef: b2PolygonDef = new b2PolygonDef();
      floorShapeDef.SetAsBox(2, 0.1);
      floorBody.CreateShape(floorShapeDef);
      
      // Create a body for the box:
      var boxBodyDef:b2BodyDef = new b2BodyDef();
      boxBodyDef.position.Set(3, 2);
 
      boxBody = world.CreateBody(boxBodyDef);
      
      // Create a shape for the box:
      var boxShapeDef: b2PolygonDef= new b2PolygonDef();
      boxShapeDef.SetAsOrientedBox(0.3, 0.2, new b2Vec2(0, 0), 0.8);
     // boxShapeDef.restitution = 0.4;
      
      // Make sure that the box has mass, so that it will be dynamic:
      boxShapeDef.density = 2;
      boxBody.CreateShape(boxShapeDef);
      boxBody.SetMassFromShapes();
      
      // Use Box2D's internal rendering engine to display the simulation for now.
      var debugDraw: b2DebugDraw = new b2DebugDraw();
      debugDraw.m_sprite = this; // = an empty container on the display list
      debugDraw.m_drawScale = 100; // 100 pixels per meter
      debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit; // draw shapes
      world.SetDebugDraw(debugDraw);

      
      addEventListener(Event.ENTER_FRAME, enterFrameHandler);
      
    }
     
      private function clickHandler(event:Event):void { 
      boxBody.ApplyImpulse(new b2Vec2(0,-3), boxBody.GetWorldCenter());
    } 
 
     private function enterFrameHandler(e:Event):void {
     var timeStep:Number = 1/30;
     var velIterations:int = 10;
     world.Step(timeStep, velIterations);    
    }
  }  
}
