/**
 * Copyright taxponation ( http://wonderfl.net/user/taxponation )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Y0J
 */

// forked from checkmate's Saqoosha challenge for amateurs
package{
	
	/*画面上ををクリックすることで新規色セットに変更することができます。
	 * 「←」「→」キーでGradation ModeのON/OFF(Default:OFF)が切り替えられます。
	 * Gradation Mode ON : 各パーティクルは移動毎に色を変え、しだいに上から下へのグラデーションになります。
	 * Gradation Mode OFF: 各パーティクルは最初の色を維持して、描画を行います。
	 * 「r」キーで現在の描画色からランダムに選択して画面全体を塗りつぶします。
	 */

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.ITween;
	
	[SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=120)]
	
    public class GradationTest1 extends Sprite {
		
		private const WIDTH:int = 465;
		private const HEIGHT:int = 465;		
		private const XNUM:int = 9;
		private const YNUM:int = 9;
		private var parArr:Array = new Array(YNUM);
		private var parPointArr:Array = new Array(YNUM);
		private var grad:Gradation = new Gradation(0xff0000, 0xff6600, 0xffff00, 0x00ff00, 0x0000ff, 0x000099, 0xff00ff, 0x660000);
		private var timer:Timer;
		private var canvas:Bitmap;
		private var canvasData:BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
		private var colRadius:Number = 5;
		private var _t:ITween;
		
		private var gradMode:Boolean = false;
						
		public function GradationTest1():void{
			
			canvas = new Bitmap(canvasData);				
			addChild(canvas);		
			
			/* Initialize particle array & particle point array*/
			for(var i:int = 0; i < YNUM ; i++){
				parArr[i] = new Array(XNUM);	
				parPointArr[i] = new Array(XNUM);		
			}
			
			for(i = 0; i < YNUM ; i++){
				for(var j:int = 0; j < XNUM ; j++){
					parArr[i][j] = new Circle(colRadius, grad.getColor((i/YNUM)));
					addChild(parArr[i][j]);
					trace(i,j);
				}
			}
			
			/* Initialize Timer */
			timer = new Timer(100);
			timer.addEventListener(TimerEvent.TIMER, onTimerHandler);
			timer.start();
			
			/* register events */
			addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUpHandler);
			stage.addEventListener(MouseEvent.CLICK, onClickHandler);										
		}
		
		private function onEnterFrameHandler(evt:Event):void{
			
			var tmpMat:Matrix = new Matrix();
			for(var i:int = 0; i < YNUM ; i++){
				for(var j:int = 0; j < XNUM ; j++){
					tmpMat.identity();
					
					parArr[i][j].x = parArr[i][j].x + Math.cos(parArr[i][j].dir)*parArr[i][j].v;
					parArr[i][j].x = (parArr[i][j].x >= 0) ? parArr[i][j].x : 0;
					parArr[i][j].x = (parArr[i][j].x <= WIDTH) ? parArr[i][j].x : WIDTH;
					
					parArr[i][j].y = parArr[i][j].y + Math.sin(parArr[i][j].dir)*parArr[i][j].v; 
					parArr[i][j].y = (parArr[i][j].y >= 0) ? parArr[i][j].y : 0;
					parArr[i][j].y = (parArr[i][j].y <= HEIGHT) ? parArr[i][j].y : HEIGHT;					
					
					parArr[i][j].dir = (parArr[i][j].dir +  (Math.random()*2-1)*Math.PI) % (Math.PI*2);
					parArr[i][j].v = parArr[i][j].v + (Math.random()*2-1);
					
					parArr[i][j].r = Math.abs(parArr[i][j].r + (Math.random()*2-1)*0.2);
					
					if(parArr[i][j].v < 0) parArr[i][j].v = 0;
					if(gradMode)parArr[i][j].col = grad.getColor((parArr[i][j].y/HEIGHT));
					
					parArr[i][j].Draw();
					tmpMat.translate(parArr[i][j].x, parArr[i][j].y);
					canvasData.draw(parArr[i][j], tmpMat, null, "normal");
				}
			}
		}
		
		private function onKeyUpHandler(evt:KeyboardEvent):void{
			if(evt.keyCode == 37 || evt.keyCode == 39){
				gradMode = !gradMode;
				
				/* display navigation */
				var spb:Sprite = new Sprite();
				spb.graphics.beginFill(0x999999);
				spb.graphics.drawRect(WIDTH/2.0-80, HEIGHT/2.0-10, 160, 20);
				spb.graphics.endFill();
				spb.alpha = 0.0;
				addChild(spb);
				
				var format:TextFormat = new TextFormat();
				format.color = 0x000000;
				format.size = 15;
				var tf:TextField  = new TextField();
				tf.defaultTextFormat = format;
				tf.alpha = 0.0;
				addChild(tf);
				
				if(gradMode){	
					tf.text = "Gradation mode : ON";
				}
				else{
					tf.text = "Gradation mode : OFF";	
				}				
				tf.width = tf.textWidth+10;
				tf.x = WIDTH/2.0-tf.textWidth/2.0;
				tf.y = HEIGHT/2.0-tf.textHeight/2.0;
				var spt:ITween = BetweenAS3.tween(spb, {alpha:1.0}, null, 1.0, Cubic.easeInOut);
				var tft:ITween = BetweenAS3.tween(tf, {alpha:1.0}, null, 1.0, Cubic.easeInOut);
				var pt:ITween = BetweenAS3.parallel(spt, tft);
				BetweenAS3.serial(pt, BetweenAS3.reverse(pt)).play();
			}
			else if(evt.keyCode == 82){
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill(grad.getColor(Math.random()));
				sp.graphics.drawRect(0,0,WIDTH, HEIGHT);
				sp.graphics.endFill();
				canvasData.draw(sp);
			}
		}
		
		private function onClickHandler(evt:MouseEvent):void{
			/* reflesh gradation color */
			refleshCol();
			
			_t = BetweenAS3.tween(parArr[0][0], {x:0, y:0}, null, 1.0, Circ.easeInOut);
			for(var i:int = 0; i < YNUM ; i++){
				for(var j:int = 0; j < XNUM ; j++){
					parPointArr[i][j] = new Point(Math.random()*WIDTH, Math.random()*HEIGHT);
					_t = BetweenAS3.parallel(
							 BetweenAS3.tween(parArr[i][j], {x:parPointArr[i][j].x, y:parPointArr[i][j].y}, null, 1.0, Circ.easeOut)
							 ,_t
						);
					parArr[i][j].col = grad.getColor((parArr[i][j].y/HEIGHT));
					parArr[i][j].Draw();
				}
			}
			_t.play();
			_t.addEventListener(TweenEvent.COMPLETE, onTweenCompHandler);
			stage.removeEventListener(MouseEvent.CLICK, onClickHandler);
		}
		
		private function onTweenCompHandler(evt:TweenEvent):void{
			stage.addEventListener(MouseEvent.CLICK, onClickHandler);
			for(var i:int = 0; i < YNUM ; i++){
				for(var j:int = 0; j < XNUM ; j++){
					parArr[i][j].x = parPointArr[i][j].x;
					parArr[i][j].y = parPointArr[i][j].y;
					parArr[i][j].v = Math.random();
				}
			}
		}
		
		private function onTimerHandler(evt:TimerEvent):void{
			var index_x:int = int(Math.random()*XNUM);
			var index_y:int = int(Math.random()*YNUM);
				
			BetweenAS3.tween(parArr[index_y][index_x], {x:(465/(XNUM-1))*index_x, y:(465/(YNUM-1))*index_y}, null, 1.0, Circ.easeInOut).play();
		}
		
		private function refleshCol():void{
			var new_grad:Gradation = new Gradation(getRndCol(), getRndCol(), getRndCol(), getRndCol(), getRndCol(), getRndCol(), getRndCol(), getRndCol());
			this.grad = new_grad;
		}
		
		private function getRndCol():uint{
			var code:uint = (uint)("0x"+Rnd()*65536+Rnd()*256+Rnd()).toString(16);						
			return code;
		}
		
		private function Rnd():Number{
    		return (Math.floor(Math.random()*256));
		}
	}
}
import flash.display.Sprite;
import flash.display.BlendMode;
import flash.display.GradientType;
import flash.filters.BlurFilter;
	
class Circle extends Sprite
{	
	private var _v:Number;
	private var _dir:Number;
	private var _r:Number;
	private var _col:uint;
	private var bfil:BlurFilter = new BlurFilter(10, 10, 1);
	
	public function Circle(r:Number, col:uint){
		this.x = Math.random() * 465;
		this.y = Math.random() * 465;
		this._r = r;
		this._col = col;
		this.blendMode = BlendMode.MULTIPLY;
		this.alpha = 1;
		this.filters = [bfil];
		
		_v = Math.random();
		_dir = Math.random() * Math.PI * _r;
		
		graphics.beginFill(_col);
		graphics.drawCircle(0, 0, _r);
		graphics.endFill();	
	}
	
	/* getter & setter */
	public function get v():Number{
      return _v;
    }
    public function set v(newV:Number) {
      _v = newV;
    }	public function get dir():Number{
      return _dir;
    }
    public function set dir(newDir:Number) {
      _dir = newDir;
    }	
	public function get r():Number{
      return _r;
    }
    public function set r(newR:Number) {
      _r = newR;
    }
    public function get col():uint{
      return _col;
    }
    public function set col(newCol:uint) {
      _col = newCol;
    }
    
	public function Draw():void{
		graphics.clear();
		graphics.beginFill(_col);
		graphics.drawCircle(0, 0, r);
		graphics.endFill();	
	}
}

import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}