/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Xj6
 */

package
{
    import com.bit101.components.HBox;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.Text;
    import com.bit101.components.VBox;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.system.Security;

    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="30")]
    public class WonderflApp extends Sprite
    {
        private var input:InputText;
        
        private var jdemcz:Label;
        private var tinyurlcom:Label;
        private var bitly:Label;
        private var googl:Label;
        private var isgd:Label;
        
        public function WonderflApp()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Security.loadPolicyFile("https://www.googleapis.com/crossdomain.xml");            
            
            var vbox:VBox = new VBox(this, 10, 10);
            var hbox:HBox = new HBox(vbox, 0, 0);
            hbox.height = 30;
            input = new InputText(hbox, 0, 0, "http://blog.yoz.sk");
            input.width = 300;
            new PushButton(hbox, 0, 0, "shorten", onShorten);
            
            jdemcz = new Label(vbox, 0, 0, "jdem.cz: ");
            
            tinyurlcom = new Label(vbox, 0, 0, "tinyurl.com: ");
            bitly = new Label(vbox, 0, 0, "bit.ly: ");
            googl = new Label(vbox, 0, 0, "goo.gl: ");
            isgd = new Label(vbox, 0, 0, "is.gd: ");
        }
        
        private function onShorten(event:Event):void
        {
            var url:String = input.text;
            
            URLShorten.jdemcz(url, onJdemcz);
            URLShorten.bitly(url, "yozo", "R_4bb620c2129850dbf876757f91af2e52", "2.0.1", onBitly);
            URLShorten.googl(url, onGoogl);
            URLShorten.tinyurlcom(url, onTinyurlcom);
            URLShorten.isgd(url, onIsgd);
            
            jdemcz.text = "jdem.cz: ...";
            bitly.text = "bit.ly: ...";
            googl.text = "goo.gl: ...";
            tinyurlcom.text = "tinyurl.com: ...";
            isgd.text = "is.gd: ...";
        }
        
        private function onJdemcz(url:String):void
        {
            jdemcz.text = "jdem.cz: " + url;
            jdemcz.buttonMode = true;
            jdemcz.mouseEnabled = true;
            jdemcz.addEventListener(MouseEvent.CLICK, 
                function(event:MouseEvent):void{goto(url)});
        }
        
        private function onTinyurlcom(url:String):void
        {
            tinyurlcom.text = "tinyurl.com: " + url;
            tinyurlcom.buttonMode = true;
            tinyurlcom.mouseEnabled = true;
            tinyurlcom.addEventListener(MouseEvent.CLICK, 
                function(event:MouseEvent):void{goto(url)});
        }
        
        private function onBitly(url:String):void
        {
            bitly.text = "bit.ly: " + url;
            bitly.buttonMode = true;
            bitly.mouseEnabled = true;
            bitly.addEventListener(MouseEvent.CLICK, 
                function(event:MouseEvent):void{goto(url)});
        }
        
        private function onGoogl(url:String):void
        {
            googl.text = "goo.gl: " + url;
            googl.buttonMode = true;
            googl.mouseEnabled = true;
            googl.addEventListener(MouseEvent.CLICK, 
                function(event:MouseEvent):void{goto(url)});
        }
        
        private function onIsgd(url:String):void
        {
            isgd.text = "is.gd: " + url;
            isgd.buttonMode = true;
            isgd.mouseEnabled = true;
            isgd.addEventListener(MouseEvent.CLICK, 
                function(event:MouseEvent):void{goto(url)});
        }
        
        private function goto(url:String):void
        {
            var request:URLRequest = new URLRequest(url);
            navigateToURL(request, "_blank");
        }
    }
}


    import com.adobe.serialization.json.JSON;
    
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.net.URLRequestMethod;
    import flash.net.URLVariables;
       
    class URLShorten extends Object
    {
        public function URLShorten()
        {
            super();
        }
        
        private static function prepare(request:URLRequest, 
            data:Object, callback:Function, completeHandler:Function=null)
            :URLLoaderDynamic
        {
            var loader:URLLoaderDynamic = new URLLoaderDynamic();
            var handler:Function = completeHandler || complete;
            
            request.data = data;
            loader.callback = callback;
            loader.load(request);
            loader.addEventListener(Event.COMPLETE, handler);
            return loader;
        }
        
        private static function complete(event:Event):void
        {
            var loader:URLLoaderDynamic = URLLoaderDynamic(event.target);
            var url:String = String(loader.data);
            
            loader.removeEventListener(Event.COMPLETE, complete);
            dispatch(url, loader)
        }
        
        private static function dispatch(url:String, loader:URLLoaderDynamic)
            :void
        {
            var callback:Function = loader.callback;
            var type:String = URLShortenEvent.COMPLETE;
            
            if(callback != null)
                callback(url);
            loader.dispatchEvent(new URLShortenEvent(type, false, false, url));
        }
        
        public static function jdemcz(longUrl:String, callback:Function=null)
            :URLLoaderDynamic
        {
            var apiUrl:String = "http://www.jdem.cz/get";
            var request:URLRequest = new URLRequest(apiUrl);
            var variables:URLVariables = new URLVariables();
            
            variables.url = longUrl;
            return prepare(request, variables, callback);
        }
        
        public static function tinyurlcom(longUrl:String, 
            callback:Function=null):URLLoaderDynamic
        {
            var apiUrl:String = "http://tinyurl.com/api-create.php";
            var request:URLRequest = new URLRequest(apiUrl);
            var variables:URLVariables = new URLVariables();
            
            variables.url = longUrl;
            return prepare(request, variables, callback);
        }
        
        public static function bitly(longUrl:String, login:String, 
            apiKey:String, version:String="2.0.1", callback:Function=null)
            :URLLoaderDynamic
        {
            var apiUrl:String = "http://api.bit.ly/shorten";
            var request:URLRequest = new URLRequest(apiUrl);
            var variables:URLVariables = new URLVariables();
            
            variables.version = version;
            variables.longUrl = longUrl;
            variables.login = login;
            variables.apiKey = apiKey;
            return prepare(request, variables, callback, bitlyComplete);
        }
        
        private static function bitlyComplete(event:Event):void
        {
            var loader:URLLoaderDynamic = URLLoaderDynamic(event.target);
            var result:String = String(loader.data);
            var data:Object = JSON.decode(result);
            var url:String;
            
            loader.removeEventListener(Event.COMPLETE, bitlyComplete);
            for each(var resultItem:Object in data.results)
                url = resultItem.shortUrl;
            dispatch(url, loader);
        }
        
        public static function trim(longUrl:String, 
            callback:Function=null):URLLoaderDynamic
        {
            var apiUrl:String = "http://api.tr.im/v1/trim_simple";
            var request:URLRequest = new URLRequest(apiUrl);
            var variables:URLVariables = new URLVariables();
            
            variables.url = longUrl;
            return prepare(request, variables, callback);
        }
        
        public static function isgd(longUrl:String, 
            callback:Function=null):URLLoaderDynamic
        {
            var apiUrl:String = "http://is.gd/api.php";
            var request:URLRequest = new URLRequest(apiUrl);
            var variables:URLVariables = new URLVariables();
            
            variables.longurl = longUrl;
            return prepare(request, variables, callback);
        }
        
        public static function googl(longUrl:String,
            callback:Function=null):URLLoaderDynamic
        {
            var apiUrl:String = 
                "https://www.googleapis.com/urlshortener/v1/url";
            var request:URLRequest = new URLRequest(apiUrl);
            var data:String = '{"longUrl": "' + longUrl + '"}';
            
            request.method = URLRequestMethod.POST;
            request.contentType = "application/json";
            return prepare(request, data, callback, googlComplete);
        }
        
        private static function googlComplete(event:Event):void
        {
            var loader:URLLoaderDynamic = URLLoaderDynamic(event.target);
            var result:String = String(loader.data);
            var data:Object = JSON.decode(result);
            var url:String = data.id;
            
            loader.removeEventListener(Event.COMPLETE, googlComplete);
            dispatch(url, loader);
        }
    }
    
    
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    
    dynamic class URLLoaderDynamic extends URLLoader
    {
        public function URLLoaderDynamic(request:URLRequest=null)
        {
            super(request);
        }
        
    }


    import flash.events.Event;

    class URLShortenEvent extends Event
    {
        public static const COMPLETE:String = "URLShortenEventCOMPLETE";
        
        private var _url:String;
        
        public function URLShortenEvent(type:String, bubbles:Boolean=false, 
            cancelable:Boolean=false, url:String="")
        {
            super(type, bubbles, cancelable);
            _url = url;
        }
        
        public function get url():String
        {
            return _url;
        }
    }