/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2X7w
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	
	[SWF(width=465,height=465,backgroundColor=0x000000)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const NUM:int = 50;
		private var balls:Vector.<Ball>;
		private var shape:Shape = new Shape();
		private var half:int;
		private var col:int;		
		public function Main():void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.LOW;
			
			addChild(shape);
			
			balls = new Vector.<Ball>(NUM, true);
			half = stage.stageHeight / 2;
			col = int(stage.stageWidth / NUM);
			
			for (var i:int = 0; i < NUM; i++) 
			{
				var b:Ball = new Ball(Math.random() * 5 + 5, 0x555555);
				b.x = Math.random() * half+half/2;
				b.y = Math.random() * half+half/2;
				b.force = Math.random() * 0.005 + 0.005;
				b.strength = Math.random()*200 - 100;
				addChild(b);
				balls[i] = b;
			}
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			shape.graphics.clear();			
			shape.graphics.lineStyle(0, 0xFFFFFF, .1);
			for (var i:int = 0; i < NUM; i++) 
			{
				var ballA:Ball = balls[i];
				ballA.angle += ballA.force;
				var dx:Number = mouseX - ballA.x;
				var dy:Number = mouseY - ballA.y;
				var dist:Number = Math.sqrt(dx * dx + dy * dy);
				if (i % 2 == 1) 
				{
					ballA.y += Math.sin(ballA.angle);
					ballA.x += Math.cos(ballA.angle*10);
				}
				else
				{
					ballA.y += Math.cos(ballA.angle);
					ballA.x += Math.sin(ballA.angle*5);
				}
				for (var j:int = i + 1; j < NUM ; j++)
				{
					var ballB:Ball = balls[j];
					shape.graphics.moveTo(ballA.x, ballA.y);
					//shape.graphics.lineTo(ballB.x, ballB.y);
					shape.graphics.curveTo((ballA.x + ballB.x) * 0.5, (ballA.y + ballB.y) * 0.5 + ballA.strength, ballB.x, ballB.y);
				}
			}
		}
	}
}

import flash.display.Sprite;

class Ball extends Sprite
{
	private var _radius:Number;
	private var _color:uint;
	private var _angle:Number = 0;
	private var _force:Number = 0;
	private var _strength:Number;
	public function Ball(radius:Number,color:uint):void
	{
		_radius = radius;
		_color = color;
		graphics.beginFill(color,.5);
		graphics.drawCircle(0, 0, radius);
		graphics.beginFill(color,.7);
		graphics.drawCircle(0, 0, radius * 0.75);
		graphics.endFill();
	}
	
	public function get angle():Number { return _angle; }
	public function set angle(value:Number):void 
	{
		_angle = value;
	}
	
	public function get force():Number { return _force; }
	public function set force(value:Number):void 
	{
		_force = value;
	}
	
	public function get strength():Number { return _strength; }
	
	public function set strength(value:Number):void 
	{
		_strength = value;
	}
}