/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2WYW
 */

package {

	import flash.display.*;
	import flash.text.*;
	import flash.geom.*;
	import flash.events.*;


	[SWF(frameRate=60, backgroundColor=0x000000, width=500, height=500)]

       public class Draw3D extends MovieClip {
		private var frame:Sprite;
		private var canvas:Shape;
		private var msk:Shape;
		private var txt:TextField;
		private var t:Number;


               public function Draw3D(){
                  // init
			stage.quality = "medium";
			frame = Sprite(addChild(new Sprite()));
			with (frame.graphics) beginFill(0xCCCCCC), drawRect(-200, -200, 400, 400), endFill();
			frame.x = stage.stageWidth / 2;
			frame.y = stage.stageHeight / 2;
			frame.z = 100;
			
			canvas = Shape(frame.addChild(new Shape()));
			msk = Shape(frame.addChild(new Shape()));
			with (msk.graphics) beginFill(0x00FF00), drawRect(-200, -200, 400, 400), endFill();
			canvas.mask = msk
			
			txt = TextField(addChild(new TextField()));
			txt.defaultTextFormat = new TextFormat("_sans", 12);
			txt.x = txt.y = 10;
			txt.textColor = 0xFFFFFF, txt.autoSize="left", txt.text = "Draw on the 3D plane...";
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
			
			
			
			t = 0;
			addEventListener(Event.ENTER_FRAME, onLoop);
			
			
			

               }
               // private methods

		private function onDown(evt:MouseEvent):void{
			canvas.graphics.lineStyle(4, 0x000000);
			var pnt:Point = frame.globalToLocal(new Point(mouseX, mouseY));
			canvas.graphics.moveTo(pnt.x, pnt.y);
			addEventListener(Event.ENTER_FRAME, onDraw);
		}
		private function onUp(evt:MouseEvent):void{
			removeEventListener(Event.ENTER_FRAME, onDraw);
		}
		private function onLoop(evt:Event):void {
		    frame.rotationY = 35 * Math.sin(t);
			frame.rotationX = 35 * Math.cos(t);
			t+=0.02;
		}
		private function onDraw(evt:Event):void {
		    var pnt:Point = frame.globalToLocal(new Point(mouseX, mouseY));
			canvas.graphics.lineTo(pnt.x, pnt.y);
		}
		

       }

}