/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2W0i
 */

// forked from sakef's らせん階段を上ります。
/*
     らせん階段を上ります。
      定数kの値でジャンプする高さを変更できます。
*/
package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    
    public class Main extends Sprite
    {
        private var container:Sprite;
        private var cube:Sprite;
        private var objects:Array;
        private var planes:Array;
        private var xx:Number
        private var ss:Number;
        private var planeN:int;
        
        // ジャンプする度合いを決める定数
        private const k:Number=15;
        
        public function Main()
        {
            container=addChild(new Sprite) as Sprite;
            container.x=465 / 2;
            container.y=465 / 2;
            container.scaleX=container.scaleY=container.scaleZ=0.15;
            container.rotationX=50;
            container.rotationY=40;
            planeN=xx=ss=0;
            
            cube=container.addChild(new Sprite) as Sprite;
            objects = [];
            objects.push(cube);
            planeN++;
            
            // Cubeを作る
            planes = [];
            planes.push(createPlane(0, 90, 50, 0, 0, cube, Math.random()*0xffffff));
            planes.push(createPlane(0, -90, -50, 0, 0, cube, Math.random()*0xffffff));
            planes.push(createPlane(-90, 0, 0, -50, 0, cube, Math.random()*0xffffff));
            planes.push(createPlane(90, 0, 0, 50, 0, cube, Math.random()*0xffffff));
            planes.push(createPlane(0, 0, 0, 0, -50, cube, Math.random()*0xffffff));
            planes.push(createPlane(0, 0, 0, 0, 50, cube, Math.random()*0xffffff));
            
            var h:int=-50;
            var s:Number=0;
            for(var i:int=0; i < 140; i++)
            {                
                objects.push(createPlane(90, 0, 1.1 * s * Math.cos(s * Math.PI / 180), -h, 1.1 * s * Math.sin(s * Math.PI / 180), container, 0x00ff00));
                h+=10;
                s+=20;
                planeN++;
            }
            
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // 平面を作成する関数
        private function createPlane(rotationX:Number, rotationY:Number ,x:Number, y:Number, z:Number, sp:Sprite, color:uint):Sprite
        {
            var shape:Sprite = sp.addChild(new Sprite) as Sprite;
            var g:Graphics = shape.graphics;
            g.beginFill(color, 0.6);
            g.drawRect(-50, -50, 100, 100);
            g.endFill();
            
            shape.rotationX = rotationX;
            shape.rotationY = rotationY;
            shape.x = x;
            shape.y = y;
            shape.z = z;
            
            return shape;
        }
        
        private function onFrame(e:Event):void
        {
            cube.z=1.1 * ss * Math.sin(ss * Math.PI / 180);
            cube.x=1.1 * ss * Math.cos(ss * Math.PI / 180);
            cube.y=-10 * (-1 * (2 * k - 1 + 2 * Math.sqrt(k * k - k)) * (xx - k + Math.sqrt(k * k - k) - Math.floor(xx)) * (xx - k + Math.sqrt(k * k - k) - Math.floor(xx)) + k + Math.floor(xx));
            
            xx+=0.05;
            ss+=1;
            
            // 色々ソート
            var array:Array=[];
            for(var i:int=0; i < 6; i++)
            {
                var shape:Sprite = planes[i];
                var mat:Matrix3D=shape.transform.getRelativeMatrix3D(this);
                array.push({sp:shape, z:mat.position.z});
            }
            array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i=0; i < 6; i++)
            {
                shape = array[i].sp as Sprite;
                cube.setChildIndex(shape, i);
            }
            array=[];
            for(i=0; i < planeN; i++)
            {
                shape = objects[i] as Sprite;
                mat=shape.transform.getRelativeMatrix3D(this);
                array.push({sp:shape, z:mat.position.z});
            }
            array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i=0; i < planeN; i++)
            {
                shape = array[i].sp as Sprite;
                container.setChildIndex(shape, i);
            }
        }
    }
}