/**
 * Copyright Hrundik ( http://wonderfl.net/user/Hrundik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2VkE
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Graphics;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        private var circle:Sprite;
        private var tf:TextField;
        
        private var targetX:int;
        private var targetY:int;
        
        public function FlashTest() {
            var rectBG:Graphics = graphics;
            rectBG.beginFill(0);
            rectBG.drawRect(0,0, stage.stageWidth, stage.stageHeight);
            rectBG.endFill();
            
            circle = new Sprite();
            var g:Graphics = circle.graphics;
            g.lineStyle(2, 0xFF0000);
            g.beginFill(0x00FF00);
            //g.drawCircle(100, 0, 25);
            g.drawCircle(0,0, 25);
            g.endFill();
            circle.x = 50;
            circle.y = 50;
            targetX = targetY = 50;
            addChild(circle);
            
            tf = new TextField();
            var textformat:TextFormat = new TextFormat();
            textformat.color = 0xCC0000;
            tf.defaultTextFormat = textformat;
            tf.text = "Hello World!";
            tf.x = 150;
            tf.y = 150;
            addChild(tf);
            
            var a:Array = [1, 2, 3];
            var va:Vector.<int> = Vector.<int>([1, 2, 3]);
            
            circle.addEventListener(MouseEvent.CLICK, onCircleClick);
            stage.addEventListener("click"/*MouseEvent.CLICK*/, onClick);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function moveCircle(x:int, y:uint):void
        {
            circle.x = x;
            circle.y = y;
        }

        
        private function onCircleClick(e:MouseEvent):void
        {
            var g:Graphics = circle.graphics;
            g.clear();
            g.beginFill(0xFF0000);
            g.drawCircle(0,0,25);
            g.endFill();
        }

        
        private function onClick(e:MouseEvent):void
        {
            targetX = e.stageX;
            targetY = e.stageY;
            //moveCircle(e.stageX, e.stageY);
            if (e.ctrlKey)
                swapChildren(circle, tf);
        }
        
        private function onEnterFrame(e:Event):void
        {
            if (Math.abs(targetX - circle.x) < 5)
                circle.x = targetX;
            if (Math.abs(targetY - circle.y) < 5)
                circle.y = targetY;
                
            if (circle.x > targetX)
                circle.x -= 5;
            else if (circle.x < targetX)
                circle.x += 5;
                
            
                
            if (circle.y > targetY)
                circle.y -= 5;
            else if (circle.y < targetY)
                circle.y += 5;
        }
    }
}