/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2VR8
 */

// forked from curvedstraightline's invertした円が気ままに動く
package {
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        private var CANVAS_WIDTH:int;
        private var CANVAS_HEIGHT:int;
        private var CANVAS_COLOR:uint=0x000000;
        private var canvas_data:BitmapData;
        private var canvas:Bitmap;
        
        private const CIRCLE_NUMBER:int=40;
        
        
        private var blend:BlendMode;
        
        public function FlashTest() 
        {
            // write as3 code here..
            //config =new Config();
            CANVAS_WIDTH=stage.stageWidth;
            CANVAS_HEIGHT=stage.stageHeight;
            createCanvas();
        }
        private function createCanvas():void
        {
            canvas_data=new BitmapData
            (
                CANVAS_WIDTH,
                CANVAS_HEIGHT,
                false,
                CANVAS_COLOR
            );
            canvas=new Bitmap(canvas_data);
            addChild(canvas);
            createCircle();
       }
       private function createCircle():void
       {
           for(var i:int=0;i<CIRCLE_NUMBER;++i)
           {
               var c:Circle=new Circle(CANVAS_WIDTH,CANVAS_HEIGHT);
               c.blendMode=BlendMode.DIFFERENCE;
               c.blendMode=BlendMode.ADD;
               
               stage.addChild(c);
           }
           //addEventListener(Event.EXIT_FRAME,loop);
       }
       
      
    }
}

import flash.display.Shape;
import flash.display.Sprite;
import gs.*;
class Circle extends Sprite
{
    private var X:int;
    private var Y:int;
    private var posX:int;
    private var posY:int;
    private var SIZE:int;
    private var COLOR:uint;
    private var TIME:int;
    private var blurX:int;
    private var blurY:int;
    
    private var c:Sprite;
    private const CIRCLE_MAX_SIZE:int=300;
    private const CIRCLE_MIN_SIZE:int=120;
    private var CANVAS_WIDTH:int;
    private var CANVAS_HEIGHT:int;
    
    public function Circle(canvasWidth:int,canvasHeight:int)
    {
        CANVAS_WIDTH=canvasWidth;
        CANVAS_HEIGHT=canvasHeight;
        
        X=Math.floor(Math.random()*CANVAS_WIDTH);
        Y=Math.floor(Math.random()*CANVAS_HEIGHT);
        COLOR=Math.floor(Math.random()*0xffffff);
        SIZE=Math.floor(Math.random()*(CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)+CIRCLE_MIN_SIZE);
        
        create();
    }
    
    private function setProperty():void
    {
        posX=Math.floor(Math.random()*CANVAS_WIDTH);
        posY=Math.floor(Math.random()*CANVAS_HEIGHT);
        SIZE=Math.floor(Math.random()*(CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)+CIRCLE_MIN_SIZE);
        TIME=Math.floor(Math.random()*10)+1;
        blurX=Math.floor(Math.random()*50)+10;
        blurY=Math.floor(Math.random()*50)+10;
    }

    
    private function create():void
    {
        c=new Sprite();
        c.graphics.beginFill(COLOR,1);
        c.graphics.drawCircle(X,Y,SIZE);
        c.graphics.endFill();
        this.addChild(c);
        
        motion01();
        
    }
    
    private function motion01():void
    {
        setProperty();
        TweenMax.to(c,TIME,
            {
                x:posX-(SIZE/2),
                y:posY-(SIZE/2),
                width:SIZE,
                height:SIZE,
                blurFilter:{blurX:blurX,blurY:blurY,quality:1},
                onComplete:motion02
            }
        );
    }
    
    private function motion02():void
    {
        setProperty();
        TweenMax.to(c,TIME,
            {
                x:posX-(SIZE/2),
                y:posY-(SIZE/2),
                width:SIZE,
                height:SIZE,
                blurFilter:{blurX:blurX,blurY:blurY,quality:1},
                onComplete:motion01
            }
        );
    }


}


