/**
 * Copyright takosuke ( http://wonderfl.net/user/takosuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2VPV
 */

// forked from matsu4512's 星屑ブロック崩し
package
{
    import __AS3__.vec.Vector;
    import com.adobe.serialization.json.JSON;
    import com.bit101.components.PushButton;
    import net.wonderfl.utils.SequentialLoader;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    //import flash.media.SoundChannel;
    //import flash.media.SoundTransform;
    //import flash.net.*;
    import flash.system.Security;
    import flash.text.*;
    import flash.utils.escapeMultiByte;
    import org.si.sion.*;
    [SWF(backgroundColor=0x00f0f, width=465, height=465, frameRate=60)]
    public class BreakBlock extends Sprite{
        //背景画像読み込み用    
        private var imageArray:Array=[];
        private var imageUrl:String="http://assets.wonderfl.net/images/related_images/1/16/162f/162fabe272eae4e0e084575ac63ac9545f4e2bd2";

        //状態　0:ゲーム中、1:Not Clear, 2:Clear
        public var status:int;
        public static const W:Number=465; // ゲームステージの幅
        public static const H:Number=465; // ゲームステージの高さ
        public static const ITEM_PROBABILITY:Number=0.3; //アイテムの出る確率
        public static const STAR_PROBABILITY:Number=0.7;
        public static const HEART_PROBABILITY:Number=0.3;
        public static const FAIL:String="fail"; //FAILイベント
        public static const CLEAR:String="clear"; //clearイベント
        public static const block_row:int=10; // ブロックの行数
        public static const block_column:int=15; // ブロックの列数
        public static const block_width:Number=31; // ブロックの幅
        public static const block_height:Number=15.5; //ブロックの高さ
        public static const bar_width:Number=62; //反射バーの幅
        public static const bar_height:Number=15.5; //反射バーの高さ
        public static const ball_size:Number=4; //ボールのサイズ
        private static const SPEED:Number=6; //メインの球のスピード
        private static const BLOCK_COLOR:uint=0x0000ff; //ブロックの色

        private var ball_bmp:Bitmap; // 表示用Bitmap
        private var block_bmp:Bitmap; //Blockを描くBitmap
        private var block_bmpData:BitmapData;
        private var ball_bmpData:BitmapData; // canvasの内容を記録するためのBitmapData
        private var counter:TextField; // カウントフィールド
        private var message:TextField; // メッセージフィールド
        private var scoreTxt:TextField; //スコアフィールド
        private var clickStart:TextField; //クリックスタート
        private var rankTxt:TextField;
        private var remainBall:int;
        private var block_count:int;
        public var ball_canvas:Sprite; // Ballなどを描画するSprite
        public var block_canvas:Sprite; //Blockを描くSprite
        public var BlockList:Vector.<Block>; // ブロック格納配列
        public var bar:Bar // ボード
        public var ballNum:int;
        
        public function BreakBlock(){
            status=0;
            ballNum=0;
            SequentialLoader.loadImages([imageUrl], imageArray, onLoaded);
        }

        private function onLoaded():void{
                var loader:Loader=imageArray.pop();
                var backData:BitmapData = new BitmapData(W, H);
                backData.draw(loader);
                var back:Bitmap=new Bitmap(backData);
            // BitmapDataの作成
            ball_bmpData=new BitmapData(W, H, true, 0x0);
            // BitmapDataの内容からBitmapを生成
            ball_bmp=new Bitmap(ball_bmpData);
            // Bitmapを表示
            addChild(ball_bmp);
            ball_canvas=new Sprite;

            // BitmapDataの作成
            block_bmpData=new BitmapData(W, H, true, 0x0);
            // BitmapDataの内容からBitmapを生成
            block_bmp=new Bitmap(block_bmpData);
            // Bitmapを表示
            addChild(block_bmp);
            block_canvas=new Sprite;


            // バーの作成
            bar=new Bar(this,W/2,H-50,0xffffff,bar_width,bar_height);
            ball_canvas.addChild(bar);

            // カウントフィールドの作成
            counter=createField();
            counter.x=W;
            addChild(counter);

            // メッセージフィールド作成
            message=createField();
            clickStart=createField();
            
            addEventListener(FAIL, notClear);
            addEventListener(CLEAR, clear);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            create();
        }

        private function create():void
        {
            // 要素の型がBlockのVectorを作成
            BlockList=new Vector.<Block>();

            // ブロック作成
            var color:uint=BLOCK_COLOR;
            var b:Block;
            var type:int; // アイテムタイプ
            var item_color:uint;
            var rand:Number; // 乱数格納
            for (var i:int=0; i < block_row; i++){
                color+=0xf;
                for (var j:int=0; j < block_column; j++){
                    b=new Block(this, j * block_width, i * block_height, color, block_width, block_height);
                    // ball_canvas上に表示(画面上に見えない)
                    block_canvas.addChild(b);
                    // 配列に追加
                    BlockList.push(b);
                }
            }

            block_bmpData.draw(block_canvas);
            ball_bmpData.draw(ball_canvas);

            //rankTxt.text="";
            //scoreTxt.text="Score:\n0";
            clickStart.text="Click Start!!";
            clickStart.x=W / 2 - clickStart.width / 2;
            clickStart.y=H / 2 - clickStart.height / 2;
            addChild(clickStart);

            stage.addEventListener(MouseEvent.CLICK, start);
        }

        private function start(event:MouseEvent):void{
            if (event.target != stage)
                return;
            //expFlg=0;
            status=0;
            var theta:Number=Math.random() * Math.PI;
            if (theta < Math.PI / 6)
                theta=Math.PI / 6;
            else if (theta > 5 * Math.PI / 6)
                theta=5 * Math.PI / 6;
            // ボールの作成
            var ball:Ball=new Ball(this,W/2,H-100,SPEED*Math.cos(theta),-SPEED*Math.sin(theta),0.0,0xFFFFFF,ball_size);
            ball_canvas.addChild(ball);

            stage.removeEventListener(MouseEvent.CLICK, start);
            removeChild(clickStart);
        }

        // テキストフィールド作成関数
        
        private function createField():TextField
        {
            var tf:TextField=new TextField;
            // フォント、サイズ、色を決める
            tf.defaultTextFormat=new TextFormat("Swis721 BdRndBT", 20, 0xFFFFFF);
            tf.autoSize=TextFieldAutoSize.LEFT;
            return tf;
        }

        private function displayMessage(str:String):void{
            ball_bmpData.lock();
            ball_bmpData.fillRect(ball_bmpData.rect, 0x0);
            ball_bmpData.unlock();
            message.text=str;
            // ゲームステージの中央に合わせる
            message.x=W / 2 - message.width / 2;
            message.y=H / 2 - message.height / 2;
            addChild(message);
        }

        //クリア出来なかった
        private function notClear(event:Event):void{
            remainBall=block_count;
            if (status != 0) return;
            //status=1;
            displayMessage("Game Over!!");
        }

        //クリア
        private function clear(event:Event):void{
            if (status != 0) return;
            //status=2;
            displayMessage("THANK YOU FOR PLAYING\nCONGRATULATION!!");
        }
        
        private function reset(event:MouseEvent):void{
            ballNum=0;
            removeChild(message);
            for (var i:int=0; i < BlockList.length; i++){
                BlockList[i].explosion();
            }
            create();
        }


        private function onEnterFrame(event:Event):void{
            block_count=BlockList.length;
            counter.text="Block数:\n" + block_count;

            block_bmpData.fillRect(block_bmpData.rect, 0x0);
            block_bmpData.draw(block_canvas);

            ball_bmpData.draw(ball_canvas);
            ball_bmpData.colorTransform(ball_bmpData.rect, new ColorTransform(1.5, 1.0, 1.5, 0.85));
        }
    }
}

import __AS3__.vec.Vector;
import flash.display.Shape;
import flash.events.Event;
import flash.filters.GlowFilter;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.display.Sprite;
import flash.geom.Point;

class Obj extends Shape{
    protected var field:BreakBlock;
    protected var color:uint;
    public function Obj(field:BreakBlock){
        this.field=field;
    }
    protected function enterFrame(event:Event):void{
        update();
    }
    //画面上から消す
    public function deleteObj():void{
        removeEventListener(Event.ENTER_FRAME, enterFrame);
        parent.removeChild(this);
    }
    protected function update():void{}
    protected function draw():void{}
    public function explosion():void{
        var num:int=width * height / 10;
        deleteObj();
    }
}

//通常のボールクラス
class Ball extends Obj
{
    //Blockの参照
    protected var blocks:Vector.<Block>;
    //Barの参照
    private var bar:Bar;
    protected var value:int; //基礎点
    protected var vx:Number; // x方向の移動量
    protected var vy:Number; // y方向の移動量
    //protected var va:Number; // alphaの変化量
    protected var r:Number; // 半径
    protected var judgeLine1:Number; //ブロックとの判定が必要になる境界線
    protected var judgeLine2:Number; //バーとの判定が必要になる境界線

    public function Ball(field:BreakBlock, x:Number, y:Number, vx:Number, vy:Number, va:Number, c:uint, r:Number)
    {
        super(field);
        field.ballNum++;
        value=100;
        this.field=field;
        this.blocks=field.BlockList;
        this.bar=field.bar;
        this.color=c;
        this.x=x;
        this.y=y;
        this.vx=vx;
        this.vy=vy;
        //this.va=va;
        this.r=r;
        draw();
        judgeLine1=BreakBlock.block_height * BreakBlock.block_row + height / 2;
        judgeLine2=field.bar.y - height / 2 - field.bar.height / 2;
        addEventListener(Event.ENTER_FRAME, enterFrame);
    }

    //描画
    override protected function draw():void{
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, r);
    }

    override protected function update():void{
        x+=vx;
        y+=vy;

        if (y + vy < judgeLine1)
            checkBlockCollision();
        if (y + vy > judgeLine2)
            checkBarCollision();
        checkStageCollision();
        checkInField();
    }

    //画面外に出ていないかどうか
    protected function checkInField():void{
        if (y > BreakBlock.H){
            removeEventListener(Event.ENTER_FRAME, enterFrame);
            parent.removeChild(this);
            //FAILイベントの発生
            field.dispatchEvent(new Event(BreakBlock.FAIL));
            field.ballNum--;
        }
    }

    //Block衝突判定
    protected function checkBlockCollision():void{
        var i:int=blocks.length;
        while (i--){
            var block:Block=blocks[i];
            if (block.hitTestObject(this)){
                if ((y - r) <= (block.y + block.height) || block.y <= (y + r)){
                    vy*=-1;
                    y+=vy;
                }
                else if ((x + r) >= block.x || (block.x + block.width) >= (x - r)){
                    vx*=-1;
                    x+=vx;
                }
                //ブロックにダメージ
                block.deleteBlock();
                blocks.splice(i, 1);
                if (blocks.length == 0){
                    field.dispatchEvent(new Event(BreakBlock.CLEAR));
                }
            }
        }
    }

    //Bar衝突判定
    protected function checkBarCollision():void{
        // バーとボールの当たり判定
        if (this.hitTestObject(bar)){
            if ((bar.y - bar.height / 2) <= (y + r)){
                vy*=-1;
                // バーにボールがめり込むのを防ぐ
                y-=bar.height / 2 + r;
                var radian:Number=Math.atan2(y - bar.y, x - bar.x);

                var point:Point=new Point(vx, vy);
                vx=Math.cos(radian) * point.length;
                vy=Math.sin(radian) * point.length;
            }
        }
    }

    protected function checkStageCollision():void{
        //ステージ全体とボールの当たり判定
        if (x < r || x > BreakBlock.W - r){
            vx*=-1;
            x+=vx;// ステージにめり込むのを防ぐ
        }else if (y < r){
            vy*=-1;
            y+=vy;// ステージにめり込むのを防ぐ
        }
    }
}


//ブロッククラス
class Block extends Obj{
    public function Block(field:BreakBlock, x:Number, y:Number, c:uint, w:Number, h:Number){
        super(field);
        this.field=field;
        this.x=x;
        this.y=y;
        this.color=c;
        // (1,1)を始点に長方形を描く
        graphics.lineStyle(1,0xaaaaff);
        graphics.drawRect(1, 1, w-1, h-1);
    }

    override public function explosion():void{
        var num:int=width * height / 10;
        deleteObj();
    }

    override public function deleteObj():void{
        parent.removeChild(this);
    }

    public function deleteBlock():void{
        var tween:ITween=BetweenAS3.to(this, {alpha: 0}, 0.3);
        tween.onComplete=function(... onCompleteParams):void{
            parent.removeChild(onCompleteParams[0])
        };
        tween.onCompleteParams=[this];
        tween.play();

        var num:int=width * height / 10;
    }
}

//反射バークラス
class Bar extends Obj{
    private var w:Number;
    private var h:Number;

    public function Bar(field:BreakBlock, x:Number, y:Number, c:uint, w:Number=50, h:Number=20){
        super(field);
        this.field=field;
        this.x=x;
        this.y=y;
        this.w=w;
        this.h=h;
        draw();

        addEventListener(Event.ENTER_FRAME, enterFrame);
    }

    override protected function draw():void{//バーを生成
        graphics.lineStyle(1,0xffffff);
        graphics.drawRect(-w/2, -h/2, w, h);
    }
/*
    override public function explosion():void{
        BetweenAS3.to(this, {scaleX: 1}, 0.5).play();
    }*/
    override public function deleteObj():void{}
    override protected function update():void{
        x+=(field.mouseX - x)/8;
        if (x + width/2 > BreakBlock.W)
            x=BreakBlock.W - width/2;
        else if (x - width/2 < 0)
            x=width / 2;
    }
}
