/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2V5q
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.events.FocusEvent;
    import flash.events.KeyboardEvent;
    
    public class MyTextField extends Sprite {
        
        public var fld:TextField;
        public var alertFld:TextField;
        public var minChars:uint = 8;
        
        public function MyTextField() {
            var tf:TextFormat = new TextFormat();
            tf.font = "_typewriter";
            tf.size = 14;
            
            fld = new TextField();
            fld.type = TextFieldType.INPUT;
            fld.defaultTextFormat = tf;
            
            fld.x = 100;
            fld.y = 50;
            fld.width = 160;
            fld.height = 24;
            fld.border = true;
            
            fld.restrict = "0-9a-zA-Z";
            fld.maxChars = 16;
            
            addChild(fld);
            
            fld.addEventListener(FocusEvent.FOCUS_IN, focusIn);
            fld.addEventListener(FocusEvent.FOCUS_OUT, focusOut);
            fld.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            
            alertFld = new TextField();
            alertFld.selectable = false;
            alertFld.background = true;
            alertFld.backgroundColor = 0XFAD163;
            alertFld.defaultTextFormat = tf;
            alertFld.autoSize = TextFieldAutoSize.LEFT;
            alertFld.text = "hankakude"+minChars+"-"+fld.maxChars+"yoroshikune!";
            alertFld.x = fld.x;
            alertFld.x = fld.y + fld.height + 2;
            alertFld.visible = false;
            addChild(alertFld);
        }
        
        public function focusIn(e:FocusEvent):void{
            alertFld.visible = false;
        }
        
        public function focusOut(e:FocusEvent):void{
            if(fld.text.length < minChars){
                alertFld.visible = true;
            }
        }
        
        public function keyDown(e:KeyboardEvent):void{
            if(e.charCode == 13){
                if(fld.text.length < minChars){
                    alertFld.visible = true;
                }
            } else {
                alertFld.visible = false;
            }
        }
    }
}