/**
 * Copyright dairyu ( http://wonderfl.net/user/dairyu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Ui1
 */

// forked from Event's SPEC vol.5 投稿用コード
//////////////////////////////////////////////////////
//  forked from Takema.Terai's flash on 2012-7-4  ////
//////////////////////////////////////////////////////
//  card_action  /////////////////////////////////////
//////////////////////////////////////////////////////

/*初投稿です。よろしくお願いします。*/

package {

    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import caurina.transitions.Tweener;

    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]

    /**
     * @author Dairyu
     */

    public class Main extends Sprite {

        //STAGE-CONTAINER
        private var container:Sprite = new Sprite();
        private var mask_mc:Sprite = new Sprite();

        //TIMELINE
        public var timeline:Sprite = new Sprite();

        //PARTS COUNT
        public var load_parts:uint = 0;
        public var load_count:uint = 0;

        //CARD-A
        private var cardA_mc:CardA_class;

        //CARD-B
        private var cardB_count:uint = 8;
        private var cardB_mc:CardB_class;
        private var cardB_container:Sprite;
        private var cardB_inner:Sprite;

        //LIGHTCIRCLE
        public  var lightParticle_count:uint = 16;
        private var lightCircle_mc:Lightcircle_class;

        //MAGIC
        private var magicSquare_mc:Magic_class;

        //LEVEL-UP
        private var levelup_mc:Level_class;

        //BACKGROUND
        private var background_mc:Sprite;
        private var background_img:Loader = new Loader()
        private var background_url:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/6/6a/6a39/6a39d24903a88ef0e43693fa953fb2aabe242387");

        public function Main() {

            mask_mc.graphics.beginFill(0xFF0000)
            mask_mc.graphics.drawRect(0, 0, 465, 465)
            mask_mc.graphics.endFill()
            addChild(mask_mc)

            container.mask = mask_mc;
            container.alpha = 0;
            addChild(container);

            setCardA();
            setMagic();
            setCardB();
            setLevelup();
            setBackground();
            setLightCircle();

            loadCheck();

        }
        

        //************************************************************
        //SET PARTS
        //************************************************************

        //-------------------------------------------------------
        //CARD-A
        private function setCardA():void {

            load_count++;

            cardA_mc = new CardA_class();
            cardA_mc.x = stage.stageWidth / 2;
            cardA_mc.y = stage.stageHeight / 2;
            container.addChild(cardA_mc);
        }

        

        

        //-------------------------------------------------------
        //CARD-B
        private function setCardB():void {

            load_count += cardB_count;

            cardB_container = new Sprite()
            container.addChild(cardB_container)
            cardB_container.x = stage.stageWidth / 2
            cardB_container.y = stage.stageHeight / 2
            cardB_inner = new Sprite()
            cardB_container.addChild(cardB_inner)

            for (var i:uint = 1; i <= cardB_count; i++ ){

                var cardB_mc = new CardB_class();
                cardB_mc.name = "cardB_" + i
                cardB_mc.angle = (90 / cardB_count) * (i-1) * Math.PI
                cardB_inner.addChild(cardB_mc);

            }

            cardB_container.y = 230//375
        }

        //-------------------------------------------------------

        //LIGHTCIRCLE

        private function setLightCircle():void {

            load_count += lightParticle_count;
            lightCircle_mc = new Lightcircle_class()
            container.addChild(lightCircle_mc)
            lightCircle_mc.x = stage.stageWidth / 2;
            lightCircle_mc.y = stage.stageHeight / 2;

        }

        
        //-------------------------------------------------------
        //LEVEL-UP
        private function setLevelup():void {

            load_count++;

            levelup_mc = new Level_class()
            container.addChild(levelup_mc);
            levelup_mc.x = stage.stageWidth / 2
            levelup_mc.y = stage.stageHeight / 2
        }

        

        
        //-------------------------------------------------------
        //MAGIC
        private function setMagic():void {

            load_count++;

            magicSquare_mc = new Magic_class();
            container.addChild(magicSquare_mc);
            magicSquare_mc.x = stage.stageWidth * 0.5;
            magicSquare_mc.y = 375;
            magicSquare_mc.scaleX = magicSquare_mc.scaleY = 1.1;

        }

        

        

        //-------------------------------------------------------
        //BACKGROUND

        private function setBackground():void {

            load_count++;

            background_img.contentLoaderInfo.addEventListener(Event.COMPLETE, setBackground_onComplete);
            background_img.load(background_url);

        }

        public function setBackground_onComplete(e:Event) {

            background_mc = new Sprite();
            background_mc.addChild(background_img);
            container.addChild(background_mc);

            load_parts++;

        }

        

        

        //-------------------------------------------------------
        //LOAD CHECK
        private function loadCheck() {
            
            //trace("LOAD START");
            addEventListener(Event.ENTER_FRAME, loadCheckHandler);
        }

        private function loadCheckHandler(e:Event):void {

            //trace(" LOAD=" + load_parts + "/" + load_count);
            if (load_parts >= load_count) {
                removeEventListener(Event.ENTER_FRAME, loadCheckHandler);
                allImageComplete();
            }
        }

        private function allImageComplete():void {

            //trace("LOAD END")
 
            //DEPTH
           container.setChildIndex(cardA_mc,             container.numChildren - 1);
           container.setChildIndex(levelup_mc,         container.numChildren - 2);
           container.setChildIndex(magicSquare_mc,     container.numChildren - 3);
           container.setChildIndex(cardB_container,    container.numChildren - 4);
           container.setChildIndex(background_mc,    0);

           //START
           Tweener.addTween(container, { alpha:1, time:0.5, transition:"easeOutCubic",onComplete:scene01 } );
       }

 
       //************************************************************
       //SCENE01
       //************************************************************
       private function scene01():void {

           //CARD-A
           cardA_mc.scene01_motion()

           //CARD-B
           for (var s:uint = 1; s <= cardB_count ; s++) {

               var targetCARD:CardB_class = cardB_inner.getChildByName("cardB_" + s) as CardB_class;
               targetCARD.scene01_motion();
           }

           //LIGHTCIRCLE
           lightCircle_mc.scene01_motion()

           //GOTO SCENE02
           Tweener.addTween(timeline,{time:1, onComplete:scene02});
       }


       //************************************************************
       //SCENE02
       //************************************************************
       public function scene02():void {

            //CARD-B
            for (var e:uint = 1; e <= cardB_count ; e++) {
                var targetCARD:CardB_class = cardB_inner.getChildByName("cardB_" + e)as CardB_class;
                targetCARD.scene02_motion();
            }
    
            Tweener.addTween(cardB_container,{rotation:180,time:1,transition:"easeInOutCubic"})
    
            //GOTO SCENE03
            Tweener.addTween(timeline,{time:0.9, onComplete:scene03});
        }

        
        //************************************************************
        //SCENE03
        //************************************************************
        public function scene03():void {

            //CARD-B
            cardB_container.y = 375
            cardB_container.scaleY = 0.4
            cardB_inner.addEventListener(Event.ENTER_FRAME, function() {
            cardB_inner.rotation += 0.5
            })
   
            for (var e:uint = 1; e <= cardB_count ; e++) {
                 var targetCARD:CardB_class = cardB_inner.getChildByName("cardB_" + e)as CardB_class;
                 targetCARD.scene03_motion();
            }
            
            //MAGIC
            magicSquare_mc.scene03_Magic()

            //GOTO SCENE04
            Tweener.addTween(timeline,{time:1.5, onComplete:scene04});

        }

        

        //************************************************************
        //SCENE04
        //************************************************************
        public function scene04():void {
            
            //CARD-A
            cardA_mc.scene04_motion()

            //LIGHTCIRCLE
            lightCircle_mc.scene04_motion()

            //MAGIC
            magicSquare_mc.scene04_Magic()

            //GOTO SCENE05
            Tweener.addTween(timeline,{time:1.5, onComplete:scene05});

        }


        //************************************************************
        //SCENE05
        //************************************************************
        public function scene05():void {

            //CARD-A
            cardA_mc.scene05_motion()

            //LIGHTCIRCLE
            lightCircle_mc.scene05_motion()

            //LEVELUP
            levelup_mc.scene05_motion() 

            //MAGIC
            magicSquare_mc.scene05_Maginc()

        }


        /*---------------END---------------*/

    }

}









//************************************************************
//IMPORT PRVATE CLASS
//************************************************************

import flash.net.URLRequest;
import flash.events.Event;
import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.BlendMode;
import flash.filters.GlowFilter;
import caurina.transitions.Tweener;
import caurina.transitions.properties.ColorShortcuts;
import caurina.transitions.properties.FilterShortcuts;

//************************************************************
//CARD-A CLASS
//************************************************************
class  CardA_class extends Sprite {

    

    //IMAGE
    private var cardA_gh:Sprite;
    private var cardA_img:Loader = new Loader();
    private var cardA_url:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/f/fc/fcfb/fcfb1f18a586ad79fd30a5c08cb4f267e9714530");

    private var effectCircle:Sprite;

    //
    public function CardA_class () {

        FilterShortcuts.init()
        addEventListener(Event.ADDED_TO_STAGE, init);

    }

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);
        cardA_img.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
        cardA_img.load(cardA_url);

    }

    private function onComplete(e:Event) {

        alpha = 0;
        visible = false;
        //
        cardA_gh = new Sprite();
        cardA_gh.addChild(cardA_img);
        cardA_img.x = -cardA_gh.width / 2;//image center
        cardA_img.y = -cardA_gh.height / 2;
        addChild(cardA_gh);

        //
        effectCircle = new Sprite();
        effectCircle.graphics.beginFill(0xFFFFFF, 0);
        effectCircle.graphics.lineStyle(200, 0xFFFFFF, 1, false, "none");
        effectCircle.graphics.drawCircle(0, 0, 150);
        effectCircle.scaleX = effectCircle.scaleY = 0.1;
        effectCircle.alpha = 0;
        effectCircle.visible = false;
        addChild(effectCircle)

        //READY
        Object(parent.parent).load_parts++
    }

    

    public function scene01_motion():void {

        Tweener.addTween(this, { scaleX:0.5,scaleY:0.5, time:1,delay:0.1, transition:"easeOutCubic"})

        //
        Tweener.addTween(this, { _brightness:1, visible:1, time:0.1, delay:0 } )
        Tweener.addTween(this, { _brightness:0, time:1,delay:0.1, transition:"easeOutCubic"})
    }

    

    public function scene02_motion():void {
    }

    

    public function scene03_motion():void {
    }

    

    public function scene04_motion():void {

        Tweener.addTween(this,  { _Glow_blurX:50, _Glow_blurY:50, _Glow_color:0xFFFFFF,transition:"easeOutCubic", time:0.5, delay:0.5 } );
        Tweener.addTween(this, { _brightness:2,y:160, time:1.5,delay:0.5,transition:"easeOutSine"})
    }

    public function scene05_motion():void {

        Tweener.addTween(this,  { _Glow_blurX:0, _Glow_blurY:0, _Glow_color:0xFFFFFF, time:1,transition:"easeOutCubic"} );
        Tweener.addTween(this, { scaleX:1.5,scaleY:1.5, time:1, transition:"easeOutCubic"})
        Tweener.addTween(this, { _brightness:0, time:2, transition:"easeInOutCubic" } )
        //
        effectCircle.alpha = 1;
        effectCircle.visible = true;
        Tweener.addTween(effectCircle, { scaleX:2, scaleY:2, time:0.3, transition:"easeOutCubic",onComplete:CB_scene05_motion } )
    }

    public function CB_scene05_motion() {

        effectCircle.alpha = 0;
        effectCircle.visible = false;
        effectCircle.scaleX = effectCircle.scaleY = 0;
    }

}


//************************************************************
//CARD-B CLASS
//************************************************************
class  CardB_class extends Sprite {

    //IMAGE
    private var cardB_gh:Sprite;
    private var cardB_img:Loader = new Loader();
    private var cardB_url:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/c/c3/c3b9/c3b9c082c57786d6d70cd72f342b232942865a1c");

    //PRAME
    public var mcNum:Number;
    public var radius:Number;
    public var angle:Number;
    public var forX:Number;
    public var forY:Number;
    public var forR:Number;

    public function CardB_class () {

        ColorShortcuts.init()
        addEventListener(Event.ADDED_TO_STAGE, init);
    }

    

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);
        cardB_img.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
        cardB_img.load(cardB_url);
        alpha = 0;
        scaleX = scaleY = 0.4;
    }

    

    private function onComplete(e:Event) {

        cardB_gh = new Sprite();
        cardB_gh.addChild(cardB_img);
        cardB_img.x = -cardB_gh.width / 2;//image center
        cardB_img.y = -cardB_gh.height / 2;
        addChild(cardB_gh);

        //
        mcNum = Number(name.substr(6,1))

        //READY
        Object(parent.parent.parent.parent).load_parts++;
    }

    

    public function scene01_motion():void {

        radius = 120;
        forX = 0 + Math.cos(angle) * radius;
        forY = 0 + Math.sin(angle) * radius;
        forR = Math.atan2( -forY, -forX) * 180 / Math.PI +90;
        rotation = forR
        Tweener.addTween(this, { x:forX, y:forY,alpha:1,time:1, transition:"easeInOutCubic" } );
    }

    

    public function scene02_motion():void {

        radius = 400;
        forX = 0 + Math.cos(angle) * radius;
        forY = 0 + Math.sin(angle) * radius;
        Tweener.addTween(cardB_img, { _brightness:1, time:1, transition:"easeOutCubic"})
        Tweener.addTween(this, { x:forX, y:forY,time:1, transition:"easeInOutCubic" } );
    }

    

    public function scene03_motion():void {

        alpha = 0
        radius = -160;
        forX = 0 + Math.cos(angle) * radius;
        forY = 0 + Math.sin(angle) * radius;
        var delayTime:Number = mcNum*0.2
        Tweener.addTween(cardB_img, { _brightness:0, time:1, transition:"easeOutCubic",delay:delayTime} )
        Tweener.addTween(this, { x:forX, y:forY,alpha:1,time:2, transition:"easeOutCubic",delay:0 } );
    }

}


//************************************************************
//LIGHTCIRCLE CLASS
//************************************************************
class  Lightcircle_class extends Sprite {

    private var container_mc:Sprite;
    public var particle_mc:LightParticle_class;

    //
    public function Lightcircle_class () {

        addEventListener(Event.ADDED_TO_STAGE, init);
        alpha = 0;
        visible = false;
        scaleX = scaleY = 2
    }

    

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);
        container_mc = new Sprite()
        addChild(container_mc)
        var count:uint = Object(parent.parent).lightParticle_count
        for (var i:uint = 1; i <=count ; i++) {
            particle_mc = new LightParticle_class()
            particle_mc.name = "particle_" + i;
            container_mc.addChild(particle_mc)

            var radius:uint = 60;
            var angle:Number = (90 / count) * (i-1) * Math.PI
            var forX:Number = 0 + Math.cos(angle) * radius;
            var forY:Number = 0 + Math.sin(angle) * radius;
            var forR:Number = Math.atan2( -forY, -forX) * 180 / Math.PI +90;

            particle_mc.x = forX;
            particle_mc.y = forY;
        }

        addEventListener(Event.ENTER_FRAME,onEnterFrameFunction)

    }

    

    private function onEnterFrameFunction(e:Event) {
        container_mc.rotation += 3;
    }

    

    public function scene01_motion():void {
        //
        Tweener.addTween(this, { alpha:1,visible:1,scaleX:1,scaleY:1, time:0.5,delay:1, transition:"easeOutCubic"})
    }

    

    public function scene02_motion():void {
        //
    }

    

    public function scene03_motion():void {
        //
    }

    

    public function scene04_motion():void {
        //
        Tweener.addTween(this, { y:160, time:1.5,delay:0.5,transition:"easeOutSine"})
    }

    

    public function scene05_motion():void {
        //
        Tweener.addTween(this, { /*scaleX:0.1, scaleY:0.1*/scaleX:10, scaleY:10, visible:0, time:1, delay:0.5, transition:"easeOutCubic" } )
        removeEventListener(Event.ENTER_FRAME,onEnterFrameFunction)
    }


}



class  LightParticle_class extends Sprite {

    //IMAGE
    private var cl_gh:Sprite;
    private var cl_img:Loader = new Loader();
    private var cl_url:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/3/31/3167/31679ab5ea5e6b984bd4476ca107be3bf2c37391");

    private var mcNum:uint

    //
    public function LightParticle_class () {

        addEventListener(Event.ADDED_TO_STAGE, init);
    }

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);
        cl_img.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
        cl_img.load(cl_url);
    }

    

    private function onComplete(e:Event) {

        cl_gh = new Sprite();
        cl_gh.addChild(cl_img);
        cl_img.x = -cl_gh.width / 2;//image center
        cl_img.y = -cl_gh.height / 2;
        addChild(cl_gh);

        mcNum = Number(name.substr(9,2))
        if (mcNum % 2 == 1) {
            scaleX = scaleY = 0.3
            alpha = 1
        }else {
            scaleX = scaleY = 0.5
            alpha = 0.5
        }

        //READY
        Object(parent.parent.parent.parent).load_parts++
    }

}







//************************************************************
//MAGIC CLASS
//************************************************************
class Magic_class extends Sprite {

    //
    private var container:Sprite;

    //IMAGE
    private var magic_mc:Sprite;
    private var magic_img:Loader = new Loader();
    private var magic_url:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/d/d3/d3a6/d3a65301bb89f0e7db4ea5b727224b8b944fba97");

    //GRAPHIC
    private var gh_mc:Sprite;
    private var gh2_mc:Sprite;

    //FILTER
    private var Glow_Filter : GlowFilter = new GlowFilter(0x00AAFF, 1, 20, 20, 3, 3, false);
    private var Glow_Array  : Array = new Array(Glow_Filter);
    private var Glow_FLG    : Boolean = true;

    //PARTYCLE
    private var circle_count:uint = 20;
    private var circle_container:Sprite;
    private var circle_mc:Circle_class;

    //TOWER
    public var tower_mc:Sprite;
    public var tower_circle:Sprite;
    public var tower_line:Sprite;

    //S_TOWER
    public var s_tower_count:uint = 8;
    public var s_tower_mc:Magic_s_tower_class;

    //
    public function Magic_class() {

        addEventListener(Event.ADDED_TO_STAGE, init);
    }

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);
        magic_img.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
        magic_img.load(magic_url);
    }

    private function onComplete(e:Event) {

        gh_mc = new Sprite();
        gh_mc.graphics.beginFill(0x00AAFF);
        gh_mc.graphics.drawCircle(0, 0, 130);
        gh_mc.graphics.endFill();
        gh_mc.alpha = 0.1;
        gh_mc.visible = false;
        gh_mc.scaleX = 0.1;
        gh_mc.scaleY = 0.1;
        addChild(gh_mc);

        gh2_mc = new Sprite();
        gh2_mc.graphics.beginFill(0xFFFFFF);
        gh2_mc.graphics.drawCircle(0, 0, 130);
        gh2_mc.graphics.endFill();
        gh2_mc.alpha = 0.1;
        gh2_mc.alpha = 0.1;
        gh2_mc.visible = false;
        gh2_mc.scaleX = 0.1;
        gh2_mc.scaleY = 0.1;
        addChild(gh2_mc);

        magic_mc = new Sprite();
        addChild(magic_mc);
        magic_mc.addChild(magic_img);
        magic_img.x = -magic_img.width / 2;
        magic_img.y = -magic_img.height / 2;
        magic_mc.alpha = 0;
        magic_mc.visible = false;
        magic_mc.scaleX = 0.1;
        magic_mc.scaleY = 0.1;

        container = new Sprite()
        addChild(container)
        container.addChild(magic_mc)
        container.scaleY = 0.4

        blendMode = BlendMode.ADD;
        if (Glow_FLG) filters = Glow_Array;

        addEventListener(Event.ENTER_FRAME, function() {
            magic_mc.rotation += 1;
        })

        //TOWER
        makeTower()

        //PARTYCLE
        partycleInit()

        //READY
        Object(parent.parent).load_parts++;

    }

    
    private function partycleInit():void {

        circle_container = new Sprite()
        addChild(circle_container);

        for (var i:uint = 1; i <= circle_count; i++) {

            var circle_mc = new Circle_class
            circle_mc.name = "circle_" + i
            circle_container.addChild(circle_mc)
        }

        //
        circle_container.alpha = 0
        circle_container.visible = false
    }


    private function makeTower():void {

        tower_mc = new Sprite()
        tower_circle = new Sprite()
        tower_circle.graphics.beginFill(0xFFFFFF);
        tower_circle.graphics.drawCircle(0, 0, 60);
        tower_circle.scaleY = 0.4;
        tower_circle.graphics.endFill()

        tower_line = new Sprite()
        tower_line.graphics.beginFill(0xFFFFFF);
        tower_line.graphics.drawRect( -60, -465, 120, 465)
        tower_line.graphics.endFill()

        tower_mc.addChild(tower_circle)
        tower_mc.addChild(tower_line)

        tower_mc.blendMode = BlendMode.LAYER
        tower_mc.alpha = 1//0.5

        //
        tower_circle.scaleX = 0
        tower_circle.scaleY = 0
        tower_line.scaleX = 0

        addChild(tower_mc)
    }

    //
    public function scene03_Magic() {

        Tweener.addTween(magic_mc, { scaleX:1, scaleY:1,alpha:1,visible:1, time:1.5, transition:"easeInOutCubic",delay:0.5 } )
        Tweener.addTween(gh_mc, { scaleX:1, scaleY:1,alpha:0.1,visible:1, time:1, transition:"easeInOutCubic",delay:0.5 } )
        gh2_mc.alpha = 1;
        Tweener.addTween(gh2_mc, { scaleX:1, scaleY:0.4,alpha:0.2,visible:1, time:0.5, transition:"easeInOutCubic",delay:0.5 } )
    }

    

    //
    public function scene04_Magic() {

        //tower
        Tweener.addTween(tower_line, { scaleX:1, scaleY:1, time:1, transition:"easeInOutCubic" } )
        Tweener.addTween(tower_circle,  { scaleX:1, scaleY:0.4, time:1, transition:"easeInOutCubic" } )
        Tweener.addTween(tower_mc,  { alpha:0.5, visible:1, time:2, transition:"easeInOutCubic" } )

        //circle
        Tweener.addTween(circle_container, { alpha:1, visible:1, time:0.5,delay:0.5,transition:"easeOutCubic" } )
    }

    public function scene05_Maginc() {
        //
        for (var i:uint = 1; i <= s_tower_count; i++ ) {

            s_tower_mc = new Magic_s_tower_class()
            addChild(s_tower_mc)
        }

    }

}



//************************************************************
//MAGIC_S_TOWER CLASS
//************************************************************
class Magic_s_tower_class extends Sprite {

    //
    public var container_mc : Sprite;

    //FILTER
    private var Glow_Filter : GlowFilter = new GlowFilter(0x00AAFF, 1, 20, 20, 3, 3, false);
    private var Glow_Array  : Array = new Array(Glow_Filter);
    private var Glow_FLG    : Boolean = false;

    //TOWER
    public var tower_width  : uint = 2;
    public var tower_mc     : Sprite;
    public var tower_circle : Sprite;
    public var tower_line   : Sprite;

    //
    public function Magic_s_tower_class() {

        addEventListener(Event.ADDED_TO_STAGE, init);
    }

    

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);
        container_mc = new Sprite()
        addChild(container_mc)

        //
        //blendMode = BlendMode.ADD;
        if (Glow_FLG) filters = Glow_Array;

        //TOWER
        makeTower()

        //
        motionInit()
    }

    

    private function makeTower():void {

        tower_mc = new Sprite()
        tower_circle = new Sprite()
        tower_circle.graphics.beginFill(0xFFFFFF);
        tower_circle.graphics.drawCircle(0, 0, tower_width);
        tower_circle.scaleY = 0.4;
        tower_circle.graphics.endFill()

        tower_line = new Sprite()
        tower_line.graphics.beginFill(0xFFFFFF);
        tower_line.graphics.drawRect( -tower_width, -465, tower_width*2, 465)
        tower_line.graphics.endFill()

        tower_mc.addChild(tower_circle)
        tower_mc.addChild(tower_line)

        tower_mc.blendMode = BlendMode.LAYER
        tower_mc.alpha = 1

        //
        tower_circle.scaleX = 0
        tower_circle.scaleY = 0
        tower_line.scaleX = 0
        container_mc.addChild(tower_mc)
    }

    

    private function startMotion() {

        Tweener.addTween(this,{time:0.3,onComplete:endMotion})
        Tweener.addTween(tower_circle, { scaleX:1, scaleY:1, time:0.3, transition:"easeOutCubic" } )
        Tweener.addTween(tower_line  , { scaleX:1, time:0.3, transition:"easeOutCubic" } )
    }


    public function endMotion() {

        Tweener.addTween(this,{time:1,onComplete:motionInit})
        Tweener.addTween(tower_circle, { scaleX:0, scaleY:0, time:1, transition:"easeInCubic" } )
        Tweener.addTween(tower_line  , { scaleX:0, time:1, transition:"easeInCubic" } )
    }

    

    public function motionInit() {

        /*
        x = Math.random() * 200 - 100
        y = Math.random() * 50 - 25
        //rotation = x
        */
        
        y = -200
        rotation = Math.ceil(Math.random() * 360)
        
        scaleX = Math.random() * 3 + 0.5
        alpha = Math.random() * 0.4 + 0.2

        var randomDelay:Number = Math.random()*0.5
        Tweener.addTween(this,{time:0.5,delay:randomDelay,onComplete:startMotion})

    }

}



//************************************************************
//CIRCLE CLASS
//************************************************************
class Circle_class extends Sprite {

    //GRAPHIC
    private var gh_mc:Sprite;

    //FILTER
    private var Glow_Filter : GlowFilter = new GlowFilter(0x00AAFF, 1, 20, 20, 3, 3, false);
    private var Glow_Array  : Array = new Array(Glow_Filter);
    private var Glow_FLG    : Boolean = false;

    //MOTION
    private var forY:uint;
    private var ampY:Number;
    private var ampA:Number;

    //
    public function Circle_class() {

        addEventListener(Event.ADDED_TO_STAGE, init);
    }

    

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);

        gh_mc = new Sprite();
        gh_mc.graphics.beginFill(0xFFFFFF);
        gh_mc.graphics.drawCircle(0, 0, 5);
        gh_mc.graphics.endFill();
        gh_mc.graphics.beginFill(0xFFFFFF,0.1);
        gh_mc.graphics.drawCircle(0, 0, 10);
        gh_mc.graphics.endFill();
        gh_mc.alpha = 1;
        addChild(gh_mc);

        //blendMode = BlendMode.ADD;
        if (Glow_FLG) filters = Glow_Array;
        alpha = 0;

        y = -Math.random() * 10;

        startMotion()
    }

    

    public function startMotion():void {

        alpha = 0;
        x = (Math.random() * 200) -100;
        forY = Math.random() * 50 + 50;
        ampY = Math.random() * 3 + 1;
        ampA = Math.random() *0.1 + 0.01
        scaleX = scaleY = Math.random() * 0.8 +0.2

        addEventListener(Event.ENTER_FRAME,enterFrameHandler)
    }

    

    public function endMotion():void {

        y = 0
        removeEventListener(Event.ENTER_FRAME,enterFrameHandler)
    }

    

    public function enterFrameHandler(e:Event):void {

        gh_mc.alpha = Math.random() * 0.3+0.7;
        gh_mc.scaleX = gh_mc.scaleY = Math.random() * 0.5+0.5

        y -= ampY;

        if (y <= -forY - 100) {

            if (alpha > 0) {
                alpha -= 0.01
            }else if (alpha <= 0) {
                endMotion()
                startMotion()
            }

        }else if (y <= 100) {

            if (alpha < 1) {
                alpha += ampA
            }

        }

    }

}




//************************************************************
//LEVEL CLASS
//************************************************************
class Level_class extends Sprite {

    //IMAGE
    private var level_gh:Sprite;
    private var level_img:Loader = new Loader();
    private var level_url:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/e/ef/efdd/efdd32f0082c3456d2268d25c487a3fc1bb12d33");

    //
    public function Level_class () {

        addEventListener(Event.ADDED_TO_STAGE, init);
        alpha = 0
        visible = false
    }

    

    private function init(e:Event) {

        removeEventListener(Event.ADDED_TO_STAGE, init);

        level_gh = new Sprite;
        addChild(level_gh)

        level_img.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
        level_img.load(level_url);
    }

    

    private function onComplete(e:Event) {

        level_gh.addChild(level_img)
        level_img.x = -level_gh.width / 2;//image center
        level_img.y = -level_gh.height / 2 + 30;

        y = 380
        scaleX = scaleY = 1.3

        //READY
        Object(parent.parent).load_parts++
    }

    public function scene05_motion() {

        alpha = 1
        visible = true

        Tweener.addTween(this, { _brightness:1, time:0})
        Tweener.addTween(this, { _brightness:0, time:3, transition:"easeOutCubic" } )

        Tweener.addTween(this,  { _Glow_blurX:100, _Glow_blurY:100, _Glow_strength:3,_Glow_color:0xFFFFFF, time:0} );
        Tweener.addTween(this,  { _Glow_blurX:10,  _Glow_blurY:10,  _Glow_strength:3,_Glow_color:0xFFFFFF, time:3,transition:"easeOutCubic"} );

        //Tweener.addTween(this, { scaleX:1.3 ,scaleY:1.3,time:2, transition:"easeOutCubic" } );
    }

}












// 以下の画像素材は自由に使っていただいて構いません
// http://jsdo.it/img/event/spec/vol5/material_fl/bg.jpg
// 
// http://jsdo.it/img/event/spec/vol5/material_fl/card01.jpg
// http://jsdo.it/img/event/spec/vol5/material_fl/card02.jpg
// http://jsdo.it/img/event/spec/vol5/material_fl/kira.png
// http://jsdo.it/img/event/spec/vol5/material_fl/kira02.png
// http://jsdo.it/img/event/spec/vol5/material_fl/lvup.png
// http://jsdo.it/img/event/spec/vol5/material_fl/lvup02.png
// http://jsdo.it/img/event/spec/vol5/material_fl/magic.png 