/**
 * Copyright ysissy ( http://wonderfl.net/user/ysissy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2UXK
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import net.hires.debug.Stats;    
    
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            var drawpad : Sprite = new Sprite();
            addChild(drawpad);

            // Capturing Mouse Cursor Coordinate
            stage.addEventListener(MouseEvent.MOUSE_DOWN,doMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP,doMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,doMouseMove);


            var drawflag : Boolean = false;
            var linedata : Array = new Array();

            // Start to add coordinate into array when mouse is down
            function doMouseDown(e:MouseEvent):void{
                drawflag = true;
                linedata = new Array();
                linedata.push ([mouseX,mouseY]);
            }


            // Add coordinate to array when mouse moves
            function doMouseMove(e:MouseEvent):void{
                if(drawflag) {
                        linedata.push([mouseX,mouseY]);
                }
            }


            // Stop to add coordinate when mouse is up
            function doMouseUp(e:MouseEvent):void{
                drawflag = false;
            }


            // Draw line during every frames
            drawpad.addEventListener(Event.ENTER_FRAME,doEnter);
            
            function doEnter(e:Event) : void {
                var wx:Number;
                var wy:Number;
                if (0<linedata.length) {
                    
                    // Clean at once
                    drawpad.graphics.clear();
            
                    //Draw with Blue Line
                    drawpad.graphics.lineStyle( 3 , 0xFF0000 );
                    wx = linedata[0][0] + Math.random() * 5 -2;
                    wy = linedata[0][1] + Math.random() * 5 -2;
             
                    drawpad.graphics.moveTo(wx,wy);
            
                    for(var i:int = 1; i < linedata.length; i++) {
                            wx = linedata[i][0] + Math.random() * 5 -2;
                            wy = linedata[i][1] + Math.random() * 5 -2;
                            drawpad.graphics.lineTo(wx,wy);
                    }
                }
            }
            addChild( new Stats());
            
        }
    }
}