/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2UKY
 */

// forked from Quasimondo's forked from: Dynamic Interpolation
// forked from Quasimondo's Dynamic Interpolation
package {
    import flash.geom.Point;
    import flash.display.Sprite;
    public class LinearDynamicInterpolation extends Sprite {
        public function LinearDynamicInterpolation() {
            
            var points:Vector.<Point> = Vector.<Point>( [ new Point(0.1,0.4), new Point(0.6,0.3)]);
            
            
            graphics.lineStyle(0,0);
            graphics.drawRect(0,0,200,200);
            
           
            for ( var i:int = 0; i < 100; i++ )
            {
                var v:Number = interpolate(i / 100,points);
                graphics.drawCircle( i * 2, v * 200,1 );
             }
        }
        
        // all arguments must be in the range 0...1
        private function interpolate( value:Number, points:Vector.<Point> ):Number
       {
            if ( points[0].x > 0 ) points.unshift( new Point(0,0) );
            if ( points[points.length-1].x < 1 ) points.push( new Point(1,1) );
           
            for ( var i:int = 0; i < points.length; i++ )
                if ( value < points[i].x )
                    break;
                
            
            var p1:Point = points[ i-1];
            var p2:Point = points[ i];
            var d:Number = (value - p1.x) / ( p2.x - p1.x );
            return p1.y + d * ( p2.y - p1.y );
         }

    }
}