/**
 * Copyright mezumona ( http://wonderfl.net/user/mezumona )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2UA3
 */

/**
 * 
 */
package
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    public class PushPopSpeedTest extends Sprite
    {
        public static const LOOP_TIME:int = 50000;
        private var textField_:TextField = new TextField();
        private var waiter_:Timer = new Timer(1000);

        public function PushPopSpeedTest()
        {
            textField_.autoSize = TextFieldAutoSize.LEFT;
            textField_.defaultTextFormat = new TextFormat("_typewriter", 12);
            addChild(textField_);
            trace("PUSH/POP と []/--length の比較。");
            trace("試行回数:", LOOP_TIME);
            trace("----");
            waiter_.addEventListener(TimerEvent.TIMER, waiterTimerHandler);
            waiter_.start();
        }

        private function trace(...rest):void
        {
            textField_.appendText(rest.join(" ").concat("\n"));
        }

        private var testCases_:Vector.<Class> = Vector.<Class>([
            ArrayPushCase,
            ArrayAccPushCase,
            ArrayPopCase,
            ArrayLenPopCase,
            VectorPushCase,
            VectorAccPushCase,
            VectorPopCase,
            VectorLenPopCase
        ]);
        private var repeatCount_:int = 0;
        private function waiterTimerHandler(event:TimerEvent):void
        {
            if (repeatCount_ < testCases_.length) {
                var testingCase:ITestCase = ITestCase(new testCases_[repeatCount_]());
                trace(testingCase.name, testingCase.exec(LOOP_TIME), "ms");
                
                // また 1 秒後
                waiter_.reset();
                waiter_.start();
                ++repeatCount_;
            }
            // 終了
            else {
                trace("終了。");
                waiter_.stop();
                waiter_.removeEventListener(TimerEvent.TIMER, waiterTimerHandler);
                waiter_ = null;
            }
        }
    }
}

/**
 * テストを実行する時に簡単にできるようにするためのインターフェイスです.
 */
internal interface ITestCase
{
    function get name():String;
    function exec(repeat:int):int;
}

//        Array
// ------------------------------------------------------------------------------------------------

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、要素を末尾に追加するときに push() で追加します.
 */
internal class ArrayPushCase implements ITestCase
{
    public function get name():String { return "ArrayPushCase         :"; }

    public function exec(loop:int):int
    {
        var arr:Array = [];
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            arr.push(i);
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、要素を末尾に追加するときに配列アクセス演算子で追加します.
 */
internal class ArrayAccPushCase implements ITestCase
{
    public function get name():String { return "ArrayAccPushCase      :"; }

    public function exec(loop:int):int
    {
        var arr:Array = [];
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            arr[arr.length] = i;
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、末尾の要素を削除するときに pop() を使用します.
 */
internal class ArrayPopCase implements ITestCase
{
    public function get name():String { return "ArrayPopCase          :"; }

    public function exec(loop:int):int
    {
        var arr:Array = new Array(loop);
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            arr.pop();
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、末尾の要素を削除するときに --length を使用します.
 */
internal class ArrayLenPopCase implements ITestCase
{
    public function get name():String { return "ArrayLenPopCase       :"; }

    public function exec(loop:int):int
    {
        var arr:Array = new Array(loop);
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            --arr.length;
        }
        return getTimer() - startTime;
    }
}

//        Vector
// ------------------------------------------------------------------------------------------------

import flash.utils.getTimer;
/**
 * コンテナに Vector を使用し、要素を末尾に追加するときに push() で追加します.
 */
internal class VectorPushCase implements ITestCase
{
    public function get name():String { return "VectorPushCase        :"; }

    public function exec(loop:int):int
    {
        var arr:Vector.<int> = new Vector.<int>();
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            arr.push(i);
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * コンテナに Vector を使用し、要素を末尾に追加するときに配列アクセス演算子で追加します.
 */
internal class VectorAccPushCase implements ITestCase
{
    public function get name():String { return "VectorAccPushCase     :"; }

    public function exec(loop:int):int
    {
        var arr:Vector.<int> = new Vector.<int>();
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            arr[arr.length] = i;
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * コンテナに Vector を使用し、末尾の要素を削除するときに pop() を使用します.
 */
internal class VectorPopCase implements ITestCase
{
    public function get name():String { return "VectorPopCase         :"; }

    public function exec(loop:int):int
    {
        var arr:Vector.<int> = new Vector.<int>(loop);
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            arr.pop();
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、末尾の要素を削除するときに --length を使用します.
 */
internal class VectorLenPopCase implements ITestCase
{
    public function get name():String { return "VectorLenPopCase      :"; }

    public function exec(loop:int):int
    {
        var arr:Vector.<int> = new Vector.<int>(loop);
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            --arr.length;
        }
        return getTimer() - startTime;
    }
}
