/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2TUr
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;    
    /**
     * ...
     * @author umhr
     */
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    public class WonderflMain extends Sprite 
    {
        
        private var maru:Sprite = new Sprite();
        public function WonderflMain():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            addChild(new Canvas());
            
            stage.addEventListener(Event.RESIZE, stage_resize);
            
            stage_resize(null);
        }
        
        private function stage_resize(event:Event):void 
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
        }
        
    }
    
}

    
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    /**
     * ...
     * @author umhr
     */
    class Box extends Sprite 
    {
        
        public function Box() 
        {
            init();
        }
        
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private var _handleList:Vector.<Sprite> = new Vector.<Sprite>();
        private var _diamondList:Vector.<Diamond> = new Vector.<Diamond>();
        private var _movieResource:MovieResource = new MovieResource();
        private var _isHideUI:Boolean;
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            var n:int = 0;
            var i:int = 0;
            
            
            for (i = 0; i < 3; i++) 
            {
                var diamond:Diamond = new Diamond();
                addChild(diamond);
                _diamondList[i] = diamond;
                diamond.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            }
            
            n = 7;
            for (i = 0; i < n; i++) 
            {
                var handle:Sprite = new Sprite();
                handle.graphics.lineStyle(0, 0xFFFFFF);
                handle.graphics.beginFill(0xFF0000, 0.3);
                handle.graphics.drawCircle(0, 0, 10);
                handle.graphics.endFill();
                if(i > 0){
                    handle.x = Math.sin((i / 6) * 2 * Math.PI) * 100;
                    handle.y = -Math.cos((i / 6) * 2 * Math.PI) * 100;
                }
                handle.addEventListener(MouseEvent.MOUSE_DOWN, handle_mouseDown);
                addChild(handle);
                _handleList.push(handle);
            }
            
            x = 200;
            y = 200;
            
        }
        
        private function mouseDown(event:MouseEvent):void 
        {
            startDrag();
            parent.addChild(this);
        }
        
        private function handle_mouseDown(event:MouseEvent):void 
        {
            var handle:Sprite = (event.target) as Sprite;
            handle.startDrag();
        }
        
        public function mouseUp():void 
        {
            stopDrag();
            var n:int = _handleList.length;
            for (var i:int = 0; i < n; i++) 
            {
                _handleList[i].stopDrag();
            }
        }
        
        public function enterFrame():void 
        {
            if (hasEventListener(Event.ADDED_TO_STAGE)) {
                return;
            }
            
            _diamondList[0].setDiamond(Vector.<Point>([new Point(_handleList[0].x, _handleList[0].y),new Point(_handleList[1].x, _handleList[1].y),new Point(_handleList[2].x, _handleList[2].y),new Point(_handleList[3].x, _handleList[3].y)]));
            _diamondList[1].setDiamond(Vector.<Point>([new Point(_handleList[0].x, _handleList[0].y),new Point(_handleList[5].x, _handleList[5].y),new Point(_handleList[4].x, _handleList[4].y),new Point(_handleList[3].x, _handleList[3].y)]));
            _diamondList[2].setDiamond(Vector.<Point>([new Point(_handleList[0].x, _handleList[0].y),new Point(_handleList[1].x, _handleList[1].y),new Point(_handleList[6].x, _handleList[6].y),new Point(_handleList[5].x, _handleList[5].y)]));
            
            
            var bitmapData:BitmapData = _movieResource.getBitmapData();
            
            _diamondList[0].bitmapData = bitmapData.clone();
            _diamondList[1].bitmapData = bitmapData.clone();
            _diamondList[2].bitmapData = bitmapData.clone();
        }
        
        public function set isHideUI(value:Boolean):void 
        {
            if (_isHideUI == value) { return; };
            _isHideUI = value;
            
            var i:int;
            var n:int = _handleList.length;
            for (i = 0; i < n; i++) 
            {
                _handleList[i].visible = !_isHideUI;
            }
            n = _diamondList.length;
            for (i = 0; i < n; i++) 
            {
                _diamondList[i].isHideUI = _isHideUI;
            }
        }
        
        public function getPositionList():Vector.<Point> {
            var result:Vector.<Point> = new Vector.<Point>();
            result[0] = new Point(x, y);
            
            var i:int;
            var n:int = _handleList.length;
            for (i = 0; i < n; i++) 
            {
                result.push(new Point(_handleList[i].x, _handleList[i].y));
            }
            
            return result;
        }
        
        public function setPositionList(positionList:Vector.<Point>):void {
            x = positionList[0].x;
            y = positionList[0].y;
            
            var i:int;
            var n:int = positionList.length - 1;
            for (i = 0; i < n; i++) 
            {
                _handleList[i].x = positionList[i + 1].x;
                _handleList[i].y = positionList[i + 1].y;
            }
            
        }
    }
    

    
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.media.Camera;
    import flash.media.Video;
    /**
     * ...
     * @author umhr
     */
    class CameraManager 
    {
        private static var _instance:CameraManager;
        public function CameraManager(block:SingletonBlock){init();}
        public static function getInstance():CameraManager{
            if ( _instance == null ) {_instance = new CameraManager(new SingletonBlock());};
            return _instance;
        }
        
        
        private var _bitmapData:BitmapData;
        private var _video:Video;
        private var _matrix:Matrix;
        private var _isCameraChecked:Boolean;
        private function init():void
        {
            setSize(100, 100);
        }
        
        public function setSize(width:int, height:int):void {
            _matrix = new Matrix();
            var scale:Number = Math.max(width / 320, height / 240);
            _matrix.scale(scale, scale);
            _matrix.translate((width - 320 * scale) * 0.5, (height - 240 * scale) * 0.5);
            _bitmapData = new BitmapData(width, height);
            
        }
        
        private function setCamera():void 
        {
            var camera:Camera = Camera.getCamera();
            //カメラの存在を確認
            if (camera) {
                camera.setMode(320, 240, 15);
                _video = new Video(320,240);
                _video.attachCamera(camera);
                _video.width = 320;
                _video.height = 240;
            } else {
                trace("カメラが見つかりませんでした。");
            }
            _isCameraChecked = true;
        }
        
        public function getBitmapData():BitmapData {
            if(_video){
                _bitmapData.draw(_video, _matrix);
            }else if (_isCameraChecked) {
                
            }else{
                setCamera();
            }
            return _bitmapData;
        }
        
        
        
    }
    

class SingletonBlock { };
    
    
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.net.SharedObject;
    import flash.ui.Mouse;
    /**
     * ...
     * @author umhr
     */
    class Canvas extends Sprite 
    {
        
        public function Canvas() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private var _isHideUI:Boolean;
        private var _controller:Sprite = new Sprite();
        private var _boxCanvas:Sprite = new Sprite();
        private var _boxList:Vector.<Box> = new Vector.<Box>();
        private var _mouseMoveCount:int = 0;
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
            addEventListener(Event.ENTER_FRAME, enterFrame);
            
            addChild(_boxCanvas);
            addChild(_controller);
            
            new PushButton(_controller, 0, 0, "addBox", addBox);
            new PushButton(_controller, 120, 0, "removeBox", removeBox);
            new PushButton(_controller, 0, 30, "FullScreen", onFullScreen);
            new PushButton(_controller, 0, 60, "WebCam", onWebCam);
            
            setBox();
        }
        
        private function setBox():void 
        {
            var boxArray:Vector.<Vector.<Point>> = SharedObjectManager.getInstance().getData();
            
            var n:int = boxArray.length;
            for (var i:int = 0; i < n; i++) 
            {
                var box:Box = new Box();
                _boxCanvas.addChild(box);
                _boxList.push(box);
                box.setPositionList(boxArray[i]);
            }
            
            
            if (n == 0) {
                addBox(null);
            }
        }
        
        private function stage_mouseMove(e:MouseEvent):void 
        {
            _mouseMoveCount = 0;
        }
        
        private function addBox(event:MouseEvent):void {
            var box:Box = new Box();
            _boxCanvas.addChild(box);
            _boxList.push(box);
        }
        
        private function removeBox(event:MouseEvent):void {
            
            var n:int = _boxCanvas.numChildren;
            if (n == 0) {
                return;
            }
            var box:Box = _boxCanvas.getChildAt(n - 1) as Box;
            
            _boxCanvas.removeChild(box);
            
            for (var i:int = 0; i < n; i++) 
            {
                if (_boxList[i] == box) {
                    _boxList.splice(i, 1);
                    return;
                }
            }
        }
        
        private function onFullScreen(event:MouseEvent):void {
            if(stage.displayState == "normal"){
                stage.displayState = "fullScreen";
            }else{
                stage.displayState = "normal";
            }
            
        }
        
        private function onWebCam(event:MouseEvent):void {
            MovieResource.isCamera = !MovieResource.isCamera;
        }
        
        private function enterFrame(event:Event):void 
        {
            var n:int = _boxList.length;
            for (var i:int = 0; i < n; i++) 
            {
                _boxList[i].enterFrame();
            }
            _mouseMoveCount ++;
            
            isHideUI = (_mouseMoveCount > 150);
            
        }
        
        private function stage_mouseUp(event:MouseEvent):void 
        {
            var n:int = _boxList.length;
            for (var i:int = 0; i < n; i++) 
            {
                _boxList[i].mouseUp();
            }
            
            var boxArray:Array = [];
            n = _boxList.length;
            for (i = 0; i < n; i++) 
            {
                var pointList:Array = [];
                var positionList:Vector.<Point> = _boxList[i].getPositionList();
                var m:int = positionList.length;
                for (var j:int = 0; j < m; j++) 
                {
                    pointList[j] = { x:positionList[j].x, y:positionList[j].y };
                    
                }
                boxArray[i] = pointList;
            }
            
            SharedObjectManager.getInstance().setData(boxArray);
        }
        
        public function get isHideUI():Boolean 
        {
            return _isHideUI;
        }
        
        public function set isHideUI(value:Boolean):void 
        {
            if (_isHideUI == value) { return; };
            _isHideUI = value;
            
            if (_isHideUI) {
                Mouse.hide();
            }else {
                Mouse.show();
            }
            
            _controller.visible = !_isHideUI;
            var n:int = _boxList.length;
            for (var i:int = 0; i < n; i++) 
            {
                _boxList[i].isHideUI = _isHideUI;
            }
        }
        
    }
    

    
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.geom.Point;
    /**
     * ...
     * @author umhr
     */
    class Diamond extends Sprite 
    {
        private var _line:Shape = new Shape();
        private var _fill:Shape = new Shape();
        private var _isHideUI:Boolean;
        private var _bitmapData:BitmapData = new BitmapData(100, 100, true, 0xFFFF0000);
        public function Diamond() 
        {
            init();
        }
        private function init():void 
        {
            addChild(_line);
            addChild(_fill);
        }
        
        public function setDiamond(positionList:Vector.<Point>):void {
            
            _line.graphics.clear();
            if(!_isHideUI){
                _line.graphics.lineStyle(0, 0x00FF00);
                _line.graphics.moveTo(positionList[0].x, positionList[0].y);
                _line.graphics.lineTo(positionList[1].x, positionList[1].y);
                _line.graphics.lineTo(positionList[2].x, positionList[2].y);
                _line.graphics.lineTo(positionList[3].x, positionList[3].y);
                _line.graphics.lineTo(positionList[0].x, positionList[0].y);
            }
            draw(positionList);
        }
        
        public function get bitmapData():BitmapData {
            return _bitmapData;
        }
        public function set bitmapData(value:BitmapData):void {
            _bitmapData = value;
        }
        
        public function draw(positionList:Vector.<Point>):void {
            
            var vertices:Vector.<Number> = new Vector.<Number>();
            var n:int = positionList.length;
            for (var i:int = 0; i < n; i++) {
                vertices.push(positionList[i].x, positionList[i].y);
            }
            
            var indices:Vector.<int> = new Vector.<int>();
            indices.push(0, 1, 2);
            indices.push(0, 2, 3);
            
            var uvtData:Vector.<Number> = new Vector.<Number>();
            uvtData.push(0, 0, 1, 0, 1, 1, 0, 1);
            
            _fill.graphics.clear();
            _fill.graphics.beginBitmapFill(_bitmapData,null,false,true);
            _fill.graphics.drawTriangles(vertices, indices, uvtData);
            _fill.graphics.endFill();
        }
        public function set isHideUI(value:Boolean):void 
        {
            if (_isHideUI == value) { return; };
            _isHideUI = value;
        }
    }
    
    import flash.display.BitmapData;
    import flash.display.Shape;
    /**
     * ...
     * @author umhr
     */
    class MovieResource 
    {
        static public var isCamera:Boolean;
        
        private var _width:int;
        private var _height:int;
        private var _resource:Daichan0;
        public function MovieResource(width:int = 100, height:int = 100) 
        {
            _width = width;
            _height = height;
            
            CameraManager.getInstance().setSize(_width, _height);
            
            _resource = new Daichan0();
        }
        
        public function getBitmapData():BitmapData {
            if (MovieResource.isCamera) {
                return CameraManager.getInstance().getBitmapData();
            }
            var result:BitmapData = new BitmapData(_width, _height, true, 0xFF000000);
            
            //var shape:Shape = new Shape();
            //shape.graphics.beginFill(0xFFCCCC);
            //shape.graphics.drawCircle(Math.random()*_width, Math.random()*_height, 50);
            //shape.graphics.endFill();
            //result.draw(shape);
            
            result.draw(_resource,new Matrix(100/465,0,0,100/465));
            
            return result;
        }
        
        
    }
    
    import flash.geom.Point;
    import flash.net.SharedObject;
    /**
     * ...
     * @author umhr
     */
    class SharedObjectManager 
    {
        private static var _instance:SharedObjectManager;
        public function SharedObjectManager(block:SingletonBlock){init();}
        public static function getInstance():SharedObjectManager{
            if ( _instance == null ) {_instance = new SharedObjectManager(new SingletonBlock());};
            return _instance;
        }
        
        
        private function init():void
        {
            
        }
        
        public function setData(data:Array ):void {
            var sharedObject:SharedObject = SharedObject.getLocal("jpMztmMapping", "/");
            if (sharedObject) {
                var soData:Object = sharedObject.data;
                soData["list"] = data;
                sharedObject.flush();
            }
        }
        
        
        
        public function getData():Vector.<Vector.<Point>> {
            var sharedObject:SharedObject = SharedObject.getLocal("jpMztmMapping", "/");
            if (sharedObject && sharedObject.data && sharedObject.data["list"]) {
                
                var soData:Object = sharedObject.data;
                
                var boxArray:Vector.<Vector.<Point>> = new Vector.<Vector.<Point>>();
                var n:int = soData.list.length;
                for (var i:int = 0; i < n; i++) 
                {
                    
                    var pointList:Vector.<Point> = new Vector.<Point>();
                    var m:int = soData.list[i].length;
                    for (var j:int = 0; j < m; j++) 
                    {
                        pointList[j] = new Point(soData.list[i][j].x, soData.list[i][j].y );
                    }
                    trace(pointList)
                    boxArray[i] = pointList;
                    
                }
                //trace(boxArray)
                return boxArray;
            }else {
                return new Vector.<Vector.<Point>>();
            }
        }
        
        
    }
    
/////////////
// forked from Daisuke.Kobayashi's 信号機的な。
// forked from umhr's BetweenAS3(serial)を使ってみる。
// forked from umhr's forked from: flash on 2012-3-10
// forked from umhr's flash on 2012-3-10
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import org.libspark.betweenas3.tweens.ITween;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    
    class Daichan0 extends Sprite {
        
        private var lienR:Sprite = new Sprite();
        private var lienG:Sprite = new Sprite();
        private var lienB:Sprite = new Sprite();
        private var box:Sprite = new Sprite();
        
        public function Daichan0() {
            // write as3 code here..
            box.graphics.beginFill(0x000000);
            box.graphics.drawRect(0,0,465,465);
            lienR.graphics.beginFill(0xFF0000,0.8);
            lienR.graphics.drawRect(0,0,465,100);
            lienG.graphics.beginFill(0x00FF00,0.8);
            lienG.graphics.drawRect(0,150,465,100);
            lienB.graphics.beginFill(0x0000FF,0.8);
            lienB.graphics.drawRect(0,300,465,100);

            this.addChild(box);
            this.addChild(lienR);
            this.addChild(lienG);
            this.addChild(lienB);
            
            
           
          
           
           onClick(null);
            //BetweenAS3.to( circle, { x:300 },2,Back.easeOut ).play();
            //stage.addEventListener(MouseEvent.CLICK,onClick);
        }
        
        private function onClick(event:MouseEvent):void{
            var t1:ITween;
            t1 = BetweenAS3.serial(
            BetweenAS3.parallel(
                BetweenAS3.to(lienR, { x:0 }, 2, Back.easeInOut),
                BetweenAS3.to(lienR, { y:320 }, 2, Elastic.easeInOut),
                BetweenAS3.to(lienG, { x:0, y:220 }, 2, Cubic.easeOut),
                BetweenAS3.to(lienB, { x:0, y:120 }, 2, Elastic.easeInOut)
                
            ),
            BetweenAS3.parallel(
                BetweenAS3.to(lienR, { x:0, y:220 }, 1, Back.easeInOut),
                BetweenAS3.to(lienR, { x:0 }, 1, Elastic.easeIn),
                BetweenAS3.to(lienG, { y:120 }, 1, Cubic.easeOut),
                BetweenAS3.to(lienB, { x:0, y:20 }, 1, Elastic.easeInOut)
            ),
            
            BetweenAS3.parallel(
                BetweenAS3.to(lienR, { x:0, y: 20 }, 1, Back.easeInOut),
                BetweenAS3.to(lienG, { x:0, y:20 }, 1, Cubic.easeOut),
                BetweenAS3.to(lienB, { x:0, y:120 }, 1, Elastic.easeInOut)
            ),
            
            BetweenAS3.parallel(
                BetweenAS3.to(lienR, { x:0, y:0 }, 1, Back.easeInOut),
                BetweenAS3.to(lienG, { x:0, y:0 }, 1, Cubic.easeOut),
                BetweenAS3.to(lienB, { x:0, y:0 }, 1, Elastic.easeInOut)
            )
            
          )
            
            t1.stopOnComplete = false;
            t1.play();
        }
    }
